/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.javabean.lifecycle;

import java.util.Map;
import java.util.Set;
import org.dhatim.cdr.annotation.ConfigParam;
import org.dhatim.container.ExecutionContext;
import org.dhatim.delivery.ExecutionLifecycleCleanable;
import org.dhatim.delivery.annotation.Initialize;
import org.dhatim.javabean.context.BeanContext;
import org.dhatim.util.CollectionsUtil;

public class BeanResultCleanup
implements ExecutionLifecycleCleanable {
    @ConfigParam
    private String[] beanIDs;
    private Set<String> beanIDSet;

    @Initialize
    public void initialize() {
        this.beanIDSet = CollectionsUtil.toSet(this.beanIDs);
    }

    @Override
    public void executeExecutionLifecycleCleanup(ExecutionContext executionContext) {
        BeanContext beanContext = executionContext.getBeanContext();
        Set<Map.Entry<String, Object>> beanSet = beanContext.getBeanMap().entrySet();
        for (Map.Entry<String, Object> beanEntry : beanSet) {
            String beanID = beanEntry.getKey();
            if (this.beanIDSet.contains(beanID)) continue;
            beanContext.removeBean(beanID, null);
        }
    }
}

