/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.profile;

import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import org.dhatim.profile.BasicProfile;
import org.dhatim.profile.DefaultProfileSet;
import org.dhatim.profile.DefaultProfileStore;
import org.dhatim.profile.ProfileConfigDigester;
import org.dhatim.profile.ProfileStore;
import org.dhatim.profile.UnknownProfileMemberException;
import org.dhatim.xml.XmlUtil;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class DefaultProfileConfigDigester
implements ProfileConfigDigester {
    @Override
    public ProfileStore parse(InputStream input) throws SAXException, IOException {
        DefaultProfileStore store = new DefaultProfileStore();
        Document profileDoc = null;
        int count = 0;
        int profileIndex = 1;
        String profileSelector = null;
        if (input == null) {
            throw new IllegalArgumentException("null 'stream' exception in method call.");
        }
        profileDoc = XmlUtil.parseStream(input, XmlUtil.VALIDATION_TYPE.DTD, true);
        profileSelector = "/device-profiles/device-profile[" + profileIndex + "]";
        while (!XmlUtil.getString(profileDoc, profileSelector).equals("")) {
            String name = XmlUtil.getString(profileDoc, profileSelector + "/@name");
            String list = XmlUtil.getString(profileDoc, profileSelector + "/@list");
            StringTokenizer tokenizer = null;
            if (name == null) {
                throw new SAXException("<device-profile> mandatory attribute 'name' no present.");
            }
            if ((name = name.trim()).equals("")) {
                throw new SAXException("<device-profile> attribute 'name' contains invalid empty value.");
            }
            if (list == null) {
                throw new SAXException("<device-profile> mandatory attribute 'list' no present.");
            }
            if ((list = list.trim()).equals("")) {
                throw new SAXException("<device-profile> attribute 'list' contains invalid empty value.");
            }
            tokenizer = new StringTokenizer(list, ",|;");
            if (tokenizer.countTokens() == 0) {
                throw new SAXException("<device-profile> attribute 'list' contains invalid value [" + list + "].");
            }
            while (tokenizer.hasMoreTokens()) {
                String profileMember = tokenizer.nextToken();
                DefaultProfileSet profileSet = null;
                try {
                    profileSet = (DefaultProfileSet)store.getProfileSet(profileMember);
                }
                catch (UnknownProfileMemberException unknown) {
                    profileSet = new DefaultProfileSet(profileMember);
                    try {
                        store.addProfileSet(profileSet);
                    }
                    catch (IllegalArgumentException invalid) {
                        SAXException saxE = new SAXException("<device-profile> attribute 'list' contains invalid device-name token value [" + profileMember + "].");
                        saxE.initCause(invalid);
                        throw saxE;
                    }
                }
                profileSet.addProfile(new BasicProfile(name));
            }
            ++count;
            profileSelector = "/device-profiles/device-profile[" + ++profileIndex + "]";
        }
        if (count == 0) {
            throw new SAXException("No <device-profile> elements defined.");
        }
        store.expandProfiles();
        return store;
    }
}

