/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.dhatim.annotation.AnnotatedClass;
import org.dhatim.annotation.AnnotatedMethod;
import org.dhatim.annotation.AnnotationManager;

class AnnotatedMethodImpl
implements AnnotatedMethod {
    private final AnnotatedClass annotatedClass;
    private final Method method;
    private Map<Class<?>, Annotation> classToAnnotationMap;
    private Annotation[] annotations;
    private Annotation[][] parameterAnnotations;

    AnnotatedMethodImpl(AnnotatedClass annotatedClass, Method method) {
        this.annotatedClass = annotatedClass;
        this.method = method;
    }

    private Map<Class<?>, Annotation> getAllAnnotationMap() {
        if (this.classToAnnotationMap == null) {
            this.classToAnnotationMap = this.getAllAnnotationMapCalculated();
        }
        return this.classToAnnotationMap;
    }

    private Map<Class<?>, Annotation> getAllAnnotationMapCalculated() {
        HashMap result = new HashMap();
        Class<?> superClass = this.getAnnotatedClass().getTheClass().getSuperclass();
        if (superClass != null) {
            this.fillAnnotationsForOneMethod(result, AnnotationManager.getAnnotatedClass(superClass).getAnnotatedMethod(this.getMethod().getName(), this.getMethod().getParameterTypes()));
        }
        for (Class<?> c : this.getAnnotatedClass().getTheClass().getInterfaces()) {
            this.fillAnnotationsForOneMethod(result, AnnotationManager.getAnnotatedClass(c).getAnnotatedMethod(this.getMethod().getName(), this.getMethod().getParameterTypes()));
        }
        for (Annotation annotation : this.getMethod().getDeclaredAnnotations()) {
            result.put(annotation.getClass().getInterfaces()[0], annotation);
        }
        return result;
    }

    private void fillAnnotationsForOneMethod(HashMap<Class<?>, Annotation> result, AnnotatedMethod annotatedMethod) {
        if (annotatedMethod == null) {
            return;
        }
        this.addAnnotations(result, annotatedMethod.getAllAnnotations());
    }

    private void addAnnotations(Map<Class<?>, Annotation> result, Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (annotation == null) continue;
            result.put(annotation.getClass().getInterfaces()[0], annotation);
        }
    }

    @Override
    public Annotation[] getAllAnnotations() {
        if (this.annotations == null) {
            this.annotations = this.getAllAnnotationsCalculated();
        }
        return this.annotations;
    }

    private Annotation[] getAllAnnotationsCalculated() {
        Collection<Annotation> values = this.getAllAnnotationMap().values();
        return values.toArray(new Annotation[0]);
    }

    @Override
    public AnnotatedClass getAnnotatedClass() {
        return this.annotatedClass;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return (T)this.getAllAnnotationMap().get(annotationClass);
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.getAnnotation(annotationClass) != null;
    }

    private void fillAnnotationsForParameters(Map<Class<?>, Annotation>[] result, Annotation[][] paramAnnotations) {
        for (int i = 0; i < paramAnnotations.length; ++i) {
            Annotation[] annontations = paramAnnotations[i];
            Map<Class<?>, Annotation> map = result[i];
            if (map == null) {
                result[i] = map = new HashMap();
            }
            this.addAnnotations(map, annontations);
        }
    }

    private Annotation[][] getParameterAnnotationsCalculated() {
        Class<?>[] aClass;
        AnnotatedMethod aMethod;
        Map[] mapResult = new Map[this.method.getParameterAnnotations().length];
        Class<?> superClass = this.getAnnotatedClass().getTheClass().getSuperclass();
        if (superClass != null && (aMethod = (aClass = AnnotationManager.getAnnotatedClass(superClass)).getAnnotatedMethod(this.getMethod().getName(), this.getMethod().getParameterTypes())) != null) {
            Annotation[][] paramAnnotations = aMethod.getParameterAnnotations();
            this.fillAnnotationsForParameters(mapResult, paramAnnotations);
        }
        for (Class<?> c : this.getAnnotatedClass().getTheClass().getInterfaces()) {
            AnnotatedClass aClass2 = AnnotationManager.getAnnotatedClass(c);
            AnnotatedMethod aMethod2 = aClass2.getAnnotatedMethod(this.getMethod().getName(), this.getMethod().getParameterTypes());
            if (aMethod2 == null) continue;
            Annotation[][] paramAnnotations = aMethod2.getParameterAnnotations();
            this.fillAnnotationsForParameters(mapResult, paramAnnotations);
        }
        this.fillAnnotationsForParameters(mapResult, this.method.getParameterAnnotations());
        Annotation[][] result = new Annotation[mapResult.length][];
        Annotation[] arrayTemplate = new Annotation[]{};
        for (int i = 0; i < mapResult.length; ++i) {
            result[i] = mapResult[i].values().toArray(arrayTemplate);
        }
        return result;
    }

    @Override
    public Annotation[][] getParameterAnnotations() {
        if (this.parameterAnnotations == null) {
            this.parameterAnnotations = this.getParameterAnnotationsCalculated();
        }
        return this.parameterAnnotations;
    }
}

