/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.cdr.xpath.evaluators;

import java.util.Properties;
import org.dhatim.assertion.AssertArgument;
import org.dhatim.cdr.xpath.SelectorStep;
import org.dhatim.cdr.xpath.evaluators.equality.EqualsEvaluator;
import org.dhatim.cdr.xpath.evaluators.equality.GreaterThanEvaluator;
import org.dhatim.cdr.xpath.evaluators.equality.IndexEvaluator;
import org.dhatim.cdr.xpath.evaluators.equality.LessThanEvaluator;
import org.dhatim.cdr.xpath.evaluators.equality.NotEqualsEvaluator;
import org.dhatim.cdr.xpath.evaluators.logical.AndEvaluator;
import org.dhatim.cdr.xpath.evaluators.logical.OrEvaluator;
import org.dhatim.container.ExecutionContext;
import org.dhatim.delivery.sax.SAXElement;
import org.jaxen.expr.EqualityExpr;
import org.jaxen.expr.Expr;
import org.jaxen.expr.LogicalExpr;
import org.jaxen.expr.NumberExpr;
import org.jaxen.expr.RelationalExpr;
import org.jaxen.saxpath.SAXPathException;
import org.w3c.dom.Element;

public abstract class XPathExpressionEvaluator {
    public abstract boolean evaluate(SAXElement var1, ExecutionContext var2);

    public abstract boolean evaluate(Element var1, ExecutionContext var2);

    public static XPathExpressionEvaluator getInstance(Expr expr, SelectorStep selectorStep, Properties namespaces) throws SAXPathException {
        AssertArgument.isNotNull(expr, "expr");
        if (expr instanceof LogicalExpr) {
            LogicalExpr logicalExpr = (LogicalExpr)expr;
            if (logicalExpr.getOperator().equalsIgnoreCase("and")) {
                return new AndEvaluator(logicalExpr, selectorStep, namespaces);
            }
            if (logicalExpr.getOperator().equalsIgnoreCase("or")) {
                return new OrEvaluator(logicalExpr, selectorStep, namespaces);
            }
        } else if (expr instanceof EqualityExpr) {
            EqualityExpr equalityExpr = (EqualityExpr)expr;
            if (equalityExpr.getOperator().equalsIgnoreCase("=")) {
                return new EqualsEvaluator(equalityExpr, namespaces);
            }
            if (equalityExpr.getOperator().equalsIgnoreCase("!=")) {
                return new NotEqualsEvaluator(equalityExpr, namespaces);
            }
        } else if (expr instanceof RelationalExpr) {
            RelationalExpr relationalExpr = (RelationalExpr)expr;
            if (relationalExpr.getOperator().equalsIgnoreCase("<")) {
                return new LessThanEvaluator(relationalExpr, namespaces);
            }
            if (relationalExpr.getOperator().equalsIgnoreCase(">")) {
                return new GreaterThanEvaluator(relationalExpr, namespaces);
            }
        } else if (expr instanceof NumberExpr) {
            return new IndexEvaluator(((NumberExpr)expr).getNumber().intValue(), selectorStep);
        }
        throw new SAXPathException("Unsupported XPath expr token '" + expr.getText() + "'.");
    }
}

