/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.cdr.xpath.evaluators.equality;

import org.dhatim.cdr.xpath.SelectorStep;
import org.dhatim.cdr.xpath.evaluators.XPathExpressionEvaluator;
import org.dhatim.cdr.xpath.evaluators.equality.ElementIndexCounter;
import org.dhatim.container.ExecutionContext;
import org.dhatim.delivery.sax.SAXElement;
import org.dhatim.xml.DomUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IndexEvaluator
extends XPathExpressionEvaluator {
    private int index;
    private ElementIndexCounter counter;
    private String elementName;
    private String elementNS;

    public IndexEvaluator(int index, SelectorStep selectorStep) {
        this.index = index;
        this.elementName = selectorStep.getTargetElement().getLocalPart();
        this.elementNS = selectorStep.getTargetElement().getNamespaceURI();
        if (this.elementNS == "") {
            this.elementNS = null;
        }
    }

    public ElementIndexCounter getCounter() {
        return this.counter;
    }

    public void setCounter(ElementIndexCounter indexCounter) {
        this.counter = indexCounter;
    }

    @Override
    public boolean evaluate(SAXElement element, ExecutionContext executionContext) {
        return this.counter.getCount(element) == this.index;
    }

    @Override
    public boolean evaluate(Element element, ExecutionContext executionContext) {
        Node parent = element.getParentNode();
        if (parent == null) {
            return this.index == 0;
        }
        NodeList siblings = parent.getChildNodes();
        int count = 0;
        int siblingCount = siblings.getLength();
        for (int i = 0; i < siblingCount; ++i) {
            Node sibling = siblings.item(i);
            if (sibling.getNodeType() == 1 && DomUtils.getName((Element)sibling).equalsIgnoreCase(this.elementName) && (this.elementNS == null || this.elementNS.equals(sibling.getNamespaceURI()))) {
                ++count;
            }
            if (sibling == element) break;
        }
        return this.index == count;
    }

    public String toString() {
        return "[" + this.index + "]";
    }
}

