/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.cdr.xpath.evaluators.value;

import org.dhatim.cdr.xpath.evaluators.value.Value;
import org.dhatim.delivery.sax.SAXElement;
import org.dhatim.javabean.DataDecoder;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class AttributeValue
extends Value {
    private String namespaceURI;
    private String localPart;
    private DataDecoder decoder;
    private static final String EMPTY_STRING = "";

    public AttributeValue(String namespaceURI, String localPart, DataDecoder decoder) {
        this.namespaceURI = namespaceURI;
        this.localPart = localPart;
        this.decoder = decoder;
    }

    @Override
    public Object getValue(SAXElement element) {
        String attribValue = this.namespaceURI != null ? element.getAttributeNS(this.namespaceURI, this.localPart) : element.getAttribute(this.localPart);
        return this.decoder.decode(attribValue);
    }

    @Override
    public Object getValue(Element element) {
        String attribValue = EMPTY_STRING;
        if (this.namespaceURI != null) {
            attribValue = element.getAttributeNS(this.namespaceURI, this.localPart);
        } else {
            NamedNodeMap attributes = element.getAttributes();
            int numAttributes = attributes.getLength();
            for (int i = 0; i < numAttributes; ++i) {
                Attr attr = (Attr)attributes.item(i);
                String attrName = attr.getLocalName();
                if (attrName == null) {
                    attrName = attr.getName();
                }
                if (!attrName.equals(this.localPart)) continue;
                attribValue = attr.getValue();
                break;
            }
        }
        return this.decoder.decode(attribValue);
    }

    public String toString() {
        if (this.namespaceURI != null) {
            return "@{" + this.namespaceURI + "}" + this.localPart;
        }
        return "@" + this.localPart;
    }
}

