/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.container.plugin;

import javax.xml.transform.Result;
import javax.xml.transform.Source;
import org.dhatim.Smooks;
import org.dhatim.SmooksException;
import org.dhatim.assertion.AssertArgument;
import org.dhatim.container.ExecutionContext;
import org.dhatim.container.plugin.ResultFactory;
import org.dhatim.container.plugin.ResultType;
import org.dhatim.container.plugin.SourceFactory;
import org.dhatim.container.plugin.SourceResult;
import org.dhatim.payload.ByteResult;
import org.dhatim.payload.JavaResult;
import org.dhatim.payload.StringResult;

public class PayloadProcessor {
    private Smooks smooks;
    private ResultType resultType;
    private String javaResultBeanId;

    public PayloadProcessor(Smooks smooks, ResultType resultType) {
        AssertArgument.isNotNull(smooks, "smooks");
        AssertArgument.isNotNull((Object)resultType, "resultType");
        this.smooks = smooks;
        this.resultType = resultType;
    }

    public void setJavaResultBeanId(String javaResultBeanId) {
        AssertArgument.isNotNullAndNotEmpty(javaResultBeanId, "javaResultBeanId");
        this.javaResultBeanId = javaResultBeanId;
    }

    public final Object process(Object payload, ExecutionContext executionContext) throws SmooksException {
        Result result;
        Source source;
        AssertArgument.isNotNull(payload, "payload");
        if (payload instanceof SourceResult) {
            SourceResult sourceResult = (SourceResult)payload;
            source = sourceResult.getSource();
            result = sourceResult.getResult();
        } else {
            source = SourceFactory.getInstance().createSource(payload);
            result = ResultFactory.getInstance().createResult(this.resultType);
        }
        this.smooks.filterSource(executionContext, source, result);
        if (result instanceof JavaResult) {
            if (this.javaResultBeanId != null) {
                return ((JavaResult)result).getResultMap().get(this.javaResultBeanId);
            }
            return ((JavaResult)result).getResultMap();
        }
        if (result instanceof StringResult) {
            return ((StringResult)result).getResult();
        }
        if (result instanceof ByteResult) {
            return ((ByteResult)result).getResult();
        }
        return result;
    }
}

