/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.edisax.interchange;

import java.util.Map;
import org.dhatim.assertion.AssertArgument;
import org.dhatim.edisax.BufferedSegmentReader;
import org.dhatim.edisax.EDIParser;
import org.dhatim.edisax.interchange.ControlBlockHandler;
import org.dhatim.edisax.interchange.ControlBlockHandlerFactory;
import org.dhatim.edisax.model.EdifactModel;
import org.dhatim.edisax.model.internal.Delimiters;
import org.dhatim.edisax.model.internal.Description;
import org.dhatim.edisax.model.internal.Edimap;
import org.dhatim.edisax.model.internal.Segment;
import org.dhatim.edisax.registry.MappingsRegistry;
import org.dhatim.lang.MutableInt;
import org.dhatim.namespace.NamespaceDeclarationStack;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class InterchangeContext {
    public static final String INTERCHANGE_MESSAGE_BLOCK_ELEMENT_NAME = "interchangeMessage";
    private BufferedSegmentReader segmentReader;
    private ContentHandler contentHandler;
    private Map<String, Boolean> features;
    private EDIParser controlSegmentParser;
    public MutableInt indentDepth = new MutableInt(0);
    private ControlBlockHandlerFactory controlBlockHandlerFactory;
    private boolean validate;
    private MappingsRegistry registry;
    private NamespaceDeclarationStack namespaceDeclarationStack;
    private boolean containerManagedNamespaceStack = false;

    public InterchangeContext(BufferedSegmentReader segmentReader, MappingsRegistry registry, ContentHandler contentHandler, Map<String, Boolean> parserFeatures, ControlBlockHandlerFactory controlBlockHandlerFactory, NamespaceDeclarationStack namespaceDeclarationStack, boolean validate) {
        AssertArgument.isNotNull(segmentReader, "segmentReader");
        AssertArgument.isNotNull(registry, "registry");
        AssertArgument.isNotNull(contentHandler, "contentHandler");
        AssertArgument.isNotNull(controlBlockHandlerFactory, "controlBlockHandlerFactory");
        this.segmentReader = segmentReader;
        this.registry = registry;
        this.contentHandler = contentHandler;
        this.features = parserFeatures;
        this.controlBlockHandlerFactory = controlBlockHandlerFactory;
        this.validate = validate;
        this.namespaceDeclarationStack = namespaceDeclarationStack;
        this.controlSegmentParser = new EDIParser();
        this.controlSegmentParser.setBufferedSegmentReader(segmentReader);
        this.controlSegmentParser.setContentHandler(contentHandler);
        this.controlSegmentParser.setIndentDepth(this.indentDepth);
        if (this.namespaceDeclarationStack == null) {
            this.namespaceDeclarationStack = new NamespaceDeclarationStack();
        } else {
            this.containerManagedNamespaceStack = true;
        }
        this.controlSegmentParser.setNamespaceDeclarationStack(this.namespaceDeclarationStack);
        Edimap controlMap = new Edimap();
        EdifactModel controlModel = new EdifactModel(controlMap);
        controlMap.setDescription(new Description().setName("EDI Message Interchange Control Model").setVersion("N/A"));
        this.controlSegmentParser.setMappingModel(controlModel);
    }

    public ControlBlockHandler getControlBlockHandler(String segCode) throws SAXException {
        return this.controlBlockHandlerFactory.getControlBlockHandler(segCode);
    }

    public BufferedSegmentReader getSegmentReader() {
        return this.segmentReader;
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public boolean isValidate() {
        return this.validate;
    }

    public String getNamespace() {
        return this.controlBlockHandlerFactory.getNamespace();
    }

    public NamespaceDeclarationStack getNamespaceDeclarationStack() {
        return this.namespaceDeclarationStack;
    }

    public EDIParser newParser(EdifactModel mappingModel) {
        EDIParser parser = new EDIParser();
        parser.setContentHandler(this.contentHandler);
        parser.setMappingModel(mappingModel);
        parser.setBufferedSegmentReader(this.segmentReader);
        parser.setIndentDepth(this.indentDepth);
        parser.getFeatures().putAll(this.features);
        parser.setFeature("http://xml.org/sax/features/validation", this.validate);
        parser.setNamespaceDeclarationStack(this.namespaceDeclarationStack);
        return parser;
    }

    public EDIParser getControlSegmentParser() {
        return this.controlSegmentParser;
    }

    public void mapControlSegment(Segment controlSegment, boolean clearSegmentBuffer) throws SAXException {
        this.controlSegmentParser.startElement(controlSegment, true);
        this.controlSegmentParser.mapFields(this.segmentReader.getCurrentSegmentFields(), controlSegment);
        this.controlSegmentParser.endElement(controlSegment, true);
        if (clearSegmentBuffer) {
            this.segmentReader.getSegmentBuffer().setLength(0);
        }
    }

    public void pushDelimiters(Delimiters delimiters) {
        this.segmentReader.pushDelimiters(delimiters);
    }

    public void popDelimiters() {
        this.segmentReader.popDelimiters();
    }

    public MappingsRegistry getRegistry() {
        return this.registry;
    }

    public boolean isContainerManagedNamespaceStack() {
        return this.containerManagedNamespaceStack;
    }
}

