/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.expression;

import org.dhatim.cdr.SmooksConfigurationException;
import org.dhatim.expression.ExecutionContextExpressionEvaluator;
import org.dhatim.expression.ExpressionEvaluationException;
import org.dhatim.util.ClassUtil;

public interface ExpressionEvaluator {
    public ExpressionEvaluator setExpression(String var1) throws SmooksConfigurationException;

    public String getExpression();

    public boolean eval(Object var1) throws ExpressionEvaluationException;

    public Object getValue(Object var1) throws ExpressionEvaluationException;

    public static class Factory {
        public static ExpressionEvaluator createInstance(String className, String conditionExpression) {
            try {
                ExpressionEvaluator evaluator = (ExpressionEvaluator)ClassUtil.forName(className, Factory.class).newInstance();
                if (!(evaluator instanceof ExecutionContextExpressionEvaluator)) {
                    throw new SmooksConfigurationException("Unsupported ExpressionEvaluator type '" + className + "'.  Currently only support '" + ExecutionContextExpressionEvaluator.class.getName() + "' implementations.");
                }
                evaluator.setExpression(conditionExpression);
                return evaluator;
            }
            catch (ClassNotFoundException e) {
                throw new SmooksConfigurationException("Failed to load ExpressionEvaluator Class '" + className + "'.", e);
            }
            catch (ClassCastException e) {
                throw new SmooksConfigurationException("Class '" + className + "' is not a valid ExpressionEvaluator.  It doesn't implement " + ExpressionEvaluator.class.getName());
            }
            catch (IllegalAccessException e) {
                throw new SmooksConfigurationException("Failed to load ExpressionEvaluator Class '" + className + "'.", e);
            }
            catch (InstantiationException e) {
                throw new SmooksConfigurationException("Failed to load ExpressionEvaluator Class '" + className + "'.", e);
            }
        }
    }
}

