/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.flatfile;

import java.util.ArrayList;
import java.util.List;
import org.dhatim.assertion.AssertArgument;
import org.dhatim.cdr.SmooksConfigurationException;
import org.dhatim.flatfile.FieldMetaData;

public class RecordMetaData {
    private String name;
    private List<FieldMetaData> fields;
    private boolean wildCardRecord;
    private int ignoredFieldCount;
    private int unignoredFieldCount;
    private List<String> fieldNames;

    public RecordMetaData(String name, List<FieldMetaData> fields) {
        this(name, fields, false);
    }

    public RecordMetaData(String name, List<FieldMetaData> fields, boolean wildCardRecord) {
        AssertArgument.isNotNullAndNotEmpty(name, "name");
        AssertArgument.isNotNull(fields, "fields");
        this.name = name.trim();
        this.fields = fields;
        this.wildCardRecord = wildCardRecord;
        this.countIgnoredFields();
        this.gatherFieldNames();
    }

    public String getName() {
        return this.name;
    }

    public List<FieldMetaData> getFields() {
        return this.fields;
    }

    public boolean isWildCardRecord() {
        return this.wildCardRecord;
    }

    public int getIgnoredFieldCount() {
        return this.ignoredFieldCount;
    }

    public int getUnignoredFieldCount() {
        return this.unignoredFieldCount;
    }

    public List<String> getFieldNames() {
        return this.fieldNames;
    }

    public void assertValidFieldName(String fieldName) {
        if (!this.fieldNames.contains(fieldName)) {
            throw new SmooksConfigurationException("Invalid field name '" + fieldName + "'.  Valid names: " + this.fieldNames + ".");
        }
    }

    private void countIgnoredFields() {
        for (FieldMetaData field : this.fields) {
            if (field.ignore()) {
                ++this.ignoredFieldCount;
                continue;
            }
            ++this.unignoredFieldCount;
        }
    }

    private void gatherFieldNames() {
        if (this.fields == null) {
            this.fieldNames = new ArrayList<String>();
        }
        this.fieldNames = new ArrayList<String>();
        for (FieldMetaData field : this.fields) {
            if (field.ignore()) continue;
            this.fieldNames.add(field.getName());
        }
    }
}

