/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.flatfile.variablefield;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dhatim.SmooksException;
import org.dhatim.cdr.SmooksConfigurationException;
import org.dhatim.cdr.annotation.ConfigParam;
import org.dhatim.container.ExecutionContext;
import org.dhatim.delivery.VisitorAppender;
import org.dhatim.delivery.VisitorConfigMap;
import org.dhatim.delivery.annotation.Initialize;
import org.dhatim.delivery.dom.DOMVisitAfter;
import org.dhatim.delivery.ordering.Consumer;
import org.dhatim.delivery.sax.SAXElement;
import org.dhatim.delivery.sax.SAXVisitAfter;
import org.dhatim.expression.MVELExpressionEvaluator;
import org.dhatim.flatfile.BindingType;
import org.dhatim.flatfile.FieldMetaData;
import org.dhatim.flatfile.RecordMetaData;
import org.dhatim.flatfile.RecordParserFactory;
import org.dhatim.flatfile.variablefield.VariableFieldRecordMetaData;
import org.dhatim.javabean.Bean;
import org.dhatim.javabean.context.BeanContext;
import org.dhatim.xml.XmlUtil;
import org.w3c.dom.Element;

public abstract class VariableFieldRecordParserFactory
implements RecordParserFactory,
VisitorAppender {
    @ConfigParam(defaultVal="##NULL")
    private String fields;
    private VariableFieldRecordMetaData vfRecordMetaData;
    @ConfigParam(use=ConfigParam.Use.OPTIONAL)
    private String recordDelimiter;
    private Pattern recordDelimiterPattern;
    @ConfigParam(defaultVal="false")
    private boolean keepDelimiter;
    @ConfigParam(defaultVal="record")
    private String recordElementName;
    @ConfigParam(use=ConfigParam.Use.OPTIONAL)
    private String bindBeanId;
    @ConfigParam(use=ConfigParam.Use.OPTIONAL)
    private Class<?> bindBeanClass;
    @ConfigParam(use=ConfigParam.Use.OPTIONAL)
    private BindingType bindingType;
    @ConfigParam(use=ConfigParam.Use.OPTIONAL)
    private String bindMapKeyField;
    private static final String RECORD_BEAN = "recordBean";
    @ConfigParam(name="skip-line-count", defaultVal="0")
    private int skipLines;
    @ConfigParam(name="fields-in-message", defaultVal="0")
    private boolean fieldsInMessage;
    @ConfigParam(defaultVal="false")
    private boolean validateHeader;
    @ConfigParam(defaultVal="false")
    private boolean strict;
    private String overFlowFromLastRecord = "";

    public int getSkipLines() {
        if (this.skipLines < 0) {
            return 0;
        }
        return this.skipLines;
    }

    public boolean fieldsInMessage() {
        return this.fieldsInMessage;
    }

    public boolean validateHeader() {
        return this.validateHeader;
    }

    public String getRecordElementName() {
        return this.recordElementName;
    }

    public RecordMetaData getRecordMetaData() {
        return this.vfRecordMetaData.getRecordMetaData();
    }

    public RecordMetaData getRecordMetaData(List<String> fieldValues) {
        return this.vfRecordMetaData.getRecordMetaData(fieldValues);
    }

    public boolean isMultiTypeRecordSet() {
        return this.vfRecordMetaData.isMultiTypeRecordSet();
    }

    public boolean strict() {
        return this.strict;
    }

    @Override
    public void addVisitors(VisitorConfigMap visitorMap) {
        if (this.bindBeanId != null && this.bindBeanClass != null) {
            if (this.fieldsInMessage) {
                throw new SmooksConfigurationException("Unsupported reader based bean binding config.  Not supported when fields are defined in message.  See 'fieldsInMessage' attribute.");
            }
            if (this.vfRecordMetaData.isMultiTypeRecordSet()) {
                throw new SmooksConfigurationException("Unsupported reader based bean binding config for a multi record type record set.  Only supported for single record type record sets.  Use <jb:bean> configs for multi binding record type record sets.");
            }
            if (this.bindingType == BindingType.LIST) {
                Bean listBean = new Bean(ArrayList.class, this.bindBeanId, "#document");
                Bean bean = listBean.newBean(this.bindBeanClass, this.recordElementName);
                listBean.bindTo(bean);
                this.addFieldBindings(bean);
                listBean.addVisitors(visitorMap);
            } else if (this.bindingType == BindingType.MAP) {
                if (this.bindMapKeyField == null) {
                    throw new SmooksConfigurationException("'MAP' Binding must specify a 'keyField' property on the binding configuration.");
                }
                this.vfRecordMetaData.getRecordMetaData().assertValidFieldName(this.bindMapKeyField);
                Bean mapBean = new Bean(LinkedHashMap.class, this.bindBeanId, "#document");
                Bean recordBean = new Bean(this.bindBeanClass, RECORD_BEAN, this.recordElementName);
                MapBindingWiringVisitor wiringVisitor = new MapBindingWiringVisitor(this.bindMapKeyField, this.bindBeanId);
                this.addFieldBindings(recordBean);
                mapBean.addVisitors(visitorMap);
                recordBean.addVisitors(visitorMap);
                visitorMap.addVisitor(wiringVisitor, this.recordElementName, null, false);
            } else {
                Bean bean = new Bean(this.bindBeanClass, this.bindBeanId, this.recordElementName);
                this.addFieldBindings(bean);
                bean.addVisitors(visitorMap);
            }
        }
    }

    @Initialize
    public final void fixupRecordDelimiter() {
        if (this.recordDelimiter == null) {
            return;
        }
        if (this.recordDelimiter.startsWith("regex:")) {
            this.recordDelimiterPattern = Pattern.compile(this.recordDelimiter.substring("regex:".length()), 40);
        } else {
            this.recordDelimiter = VariableFieldRecordParserFactory.removeSpecialCharEncodeString(this.recordDelimiter, "\\n", '\n');
            this.recordDelimiter = VariableFieldRecordParserFactory.removeSpecialCharEncodeString(this.recordDelimiter, "\\r", '\r');
            this.recordDelimiter = VariableFieldRecordParserFactory.removeSpecialCharEncodeString(this.recordDelimiter, "\\t", '\t');
            this.recordDelimiter = XmlUtil.removeEntities(this.recordDelimiter);
        }
    }

    @Initialize
    public final void buildRecordMetaData() {
        this.vfRecordMetaData = new VariableFieldRecordMetaData(this.recordElementName, this.fields);
    }

    public void readRecord(Reader recordReader, StringBuilder recordBuffer, int recordNumber) throws IOException {
        int c;
        recordBuffer.setLength(0);
        recordBuffer.append(this.overFlowFromLastRecord);
        RecordBoundaryLocator boundaryLocator = this.recordDelimiterPattern != null ? new RegexRecordBoundaryLocator(recordBuffer, recordNumber) : new SimpleRecordBoundaryLocator(recordBuffer, recordNumber);
        while ((c = recordReader.read()) != -1) {
            if (recordBuffer.length() == 0 && (c == 10 || c == 13)) continue;
            recordBuffer.append((char)c);
            if (!boundaryLocator.atEndOfRecord()) continue;
        }
        this.overFlowFromLastRecord = boundaryLocator.getOverflowCharacters();
    }

    private void addFieldBindings(Bean bean) {
        for (FieldMetaData fieldMetaData : this.vfRecordMetaData.getRecordMetaData().getFields()) {
            if (fieldMetaData.ignore()) continue;
            bean.bindTo(fieldMetaData.getName(), this.recordElementName + "/" + fieldMetaData.getName());
        }
    }

    private static String removeSpecialCharEncodeString(String string, String encodedString, char replaceChar) {
        return string.replace(encodedString, new String(new char[]{replaceChar}));
    }

    private abstract class RecordBoundaryLocator {
        protected StringBuilder recordBuffer;
        protected int recordNumber;

        protected RecordBoundaryLocator(StringBuilder recordBuffer, int recordNumber) {
            this.recordBuffer = recordBuffer;
            this.recordNumber = recordNumber;
        }

        abstract boolean atEndOfRecord();

        abstract String getOverflowCharacters();
    }

    private class RegexRecordBoundaryLocator
    extends RecordBoundaryLocator {
        private int startFindIndex;
        private int endRecordIndex;
        private String overFlow;

        protected RegexRecordBoundaryLocator(StringBuilder recordBuffer, int recordNumber) {
            super(recordBuffer, recordNumber);
            this.overFlow = "";
            this.startFindIndex = recordBuffer.length();
        }

        @Override
        boolean atEndOfRecord() {
            Matcher matcher = VariableFieldRecordParserFactory.this.recordDelimiterPattern.matcher(this.recordBuffer);
            if (matcher.find(this.startFindIndex)) {
                if (this.recordNumber == 1 && this.startFindIndex == 0) {
                    this.startFindIndex = matcher.end();
                    return false;
                }
                this.endRecordIndex = matcher.start();
                this.overFlow = this.recordBuffer.substring(this.endRecordIndex);
                this.recordBuffer.setLength(this.endRecordIndex);
                return true;
            }
            return false;
        }

        @Override
        String getOverflowCharacters() {
            return this.overFlow;
        }
    }

    private class SimpleRecordBoundaryLocator
    extends RecordBoundaryLocator {
        private SimpleRecordBoundaryLocator(StringBuilder recordBuffer, int recordNumber) {
            super(recordBuffer, recordNumber);
        }

        @Override
        boolean atEndOfRecord() {
            int builderLen = this.recordBuffer.length();
            char lastChar = this.recordBuffer.charAt(builderLen - 1);
            if (VariableFieldRecordParserFactory.this.recordDelimiter != null) {
                int stringLen = VariableFieldRecordParserFactory.this.recordDelimiter.length();
                if (builderLen < stringLen) {
                    return false;
                }
                int stringIndx = 0;
                for (int i = builderLen - stringLen; i < builderLen; ++i) {
                    if (this.recordBuffer.charAt(i) != VariableFieldRecordParserFactory.this.recordDelimiter.charAt(stringIndx)) {
                        return false;
                    }
                    ++stringIndx;
                }
                if (!VariableFieldRecordParserFactory.this.keepDelimiter) {
                    this.recordBuffer.setLength(builderLen - stringLen);
                }
                return true;
            }
            if (lastChar == '\r' || lastChar == '\n') {
                if (!VariableFieldRecordParserFactory.this.keepDelimiter) {
                    this.recordBuffer.setLength(builderLen - 1);
                }
                return true;
            }
            return false;
        }

        @Override
        String getOverflowCharacters() {
            return "";
        }
    }

    private class MapBindingWiringVisitor
    implements DOMVisitAfter,
    SAXVisitAfter,
    Consumer {
        private MVELExpressionEvaluator keyExtractor = new MVELExpressionEvaluator();
        private String mapBindingKey;

        private MapBindingWiringVisitor(String bindKeyField, String mapBindingKey) {
            this.keyExtractor.setExpression("recordBean." + bindKeyField);
            this.mapBindingKey = mapBindingKey;
        }

        @Override
        public void visitAfter(Element element, ExecutionContext executionContext) throws SmooksException {
            this.wireObject(executionContext);
        }

        @Override
        public void visitAfter(SAXElement element, ExecutionContext executionContext) throws SmooksException, IOException {
            this.wireObject(executionContext);
        }

        private void wireObject(ExecutionContext executionContext) {
            BeanContext beanContext = executionContext.getBeanContext();
            Map<String, Object> beanMap = beanContext.getBeanMap();
            Object key = this.keyExtractor.getValue(beanMap);
            Map map = (Map)beanContext.getBean(this.mapBindingKey);
            Object record = beanContext.getBean(VariableFieldRecordParserFactory.RECORD_BEAN);
            map.put(key, record);
        }

        @Override
        public boolean consumes(Object object) {
            return this.keyExtractor.getExpression().indexOf(object.toString()) != -1;
        }
    }
}

