/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.javabean.binding.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.dhatim.Smooks;
import org.dhatim.assertion.AssertArgument;
import org.dhatim.cdr.SmooksConfigurationException;
import org.dhatim.cdr.SmooksResourceConfiguration;
import org.dhatim.cdr.SmooksResourceConfigurationList;
import org.dhatim.cdr.xpath.SelectorStep;
import org.dhatim.cdr.xpath.SelectorStepBuilder;
import org.dhatim.javabean.BeanInstanceCreator;
import org.dhatim.javabean.BeanInstancePopulator;
import org.dhatim.javabean.DataDecoder;
import org.dhatim.javabean.DataEncoder;
import org.dhatim.javabean.binding.AbstractBinding;
import org.dhatim.javabean.binding.BeanSerializationException;
import org.dhatim.javabean.binding.SerializationContext;
import org.dhatim.javabean.binding.model.Bean;
import org.dhatim.javabean.binding.model.Binding;
import org.dhatim.javabean.binding.model.DataBinding;
import org.dhatim.javabean.binding.model.ModelSet;
import org.dhatim.javabean.binding.model.WiredBinding;
import org.dhatim.javabean.binding.model.get.ConstantGetter;
import org.dhatim.javabean.binding.model.get.GetterGraph;
import org.dhatim.javabean.binding.xml.XMLAttributeSerializationNode;
import org.dhatim.javabean.binding.xml.XMLElementSerializationNode;
import org.dhatim.javabean.binding.xml.XMLSerializationNode;
import org.dhatim.payload.StringSource;
import org.dhatim.xml.NamespaceMappings;
import org.xml.sax.SAXException;

public class XMLBinding
extends AbstractBinding {
    private ModelSet beanModelSet;
    private List<XMLElementSerializationNode> graphs;
    private Set<QName> rootElementNames = new HashSet<QName>();
    private Map<Class, RootNodeSerializer> serializers = new LinkedHashMap<Class, RootNodeSerializer>();
    private boolean omitXMLDeclaration = false;

    public XMLBinding() {
    }

    public XMLBinding(Smooks smooks) {
        super(smooks);
    }

    @Override
    public XMLBinding add(String smooksConfigURI) throws IOException, SAXException {
        super.add(smooksConfigURI);
        return this;
    }

    @Override
    public XMLBinding add(InputStream smooksConfigStream) throws IOException, SAXException {
        return (XMLBinding)super.add(smooksConfigStream);
    }

    @Override
    public XMLBinding setReportPath(String reportPath) {
        super.setReportPath(reportPath);
        return this;
    }

    @Override
    public XMLBinding intiailize() {
        super.intiailize();
        this.beanModelSet = ModelSet.get(this.getSmooks().getApplicationContext());
        this.graphs = this.createExpandedXMLOutputGraphs(this.getUserDefinedResourceList());
        this.createRootSerializers(this.graphs);
        this.mergeBeanModelsIntoXMLGraphs();
        return this;
    }

    public XMLBinding setOmitXMLDeclaration(boolean omitXMLDeclaration) {
        this.omitXMLDeclaration = omitXMLDeclaration;
        return this;
    }

    public <T> T fromXML(String inputSource, Class<T> toType) {
        try {
            return this.bind(new StringSource(inputSource), toType);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unexpected IOException from a String input.", e);
        }
    }

    public <T> T fromXML(Source inputSource, Class<T> toType) throws IOException {
        return this.bind(inputSource, toType);
    }

    public <W extends Writer> W toXML(Object object, W outputWriter) throws BeanSerializationException, IOException {
        AssertArgument.isNotNull(object, "object");
        this.assertInitialized();
        Class<?> objectClass = object.getClass();
        RootNodeSerializer rootNodeSerializer = this.serializers.get(objectClass);
        if (rootNodeSerializer == null) {
            throw new BeanSerializationException("No serializer for Java type '" + objectClass.getName() + "'.");
        }
        if (!this.omitXMLDeclaration) {
            outputWriter.write("<?xml version=\"1.0\"?>\n");
        }
        XMLElementSerializationNode serializer = rootNodeSerializer.serializer;
        serializer.serialize(outputWriter, new SerializationContext(object, rootNodeSerializer.beanId));
        outputWriter.flush();
        return outputWriter;
    }

    public String toXML(Object object) throws BeanSerializationException {
        StringWriter writer = new StringWriter();
        try {
            this.toXML(object, writer);
            String string = writer.toString();
            return string;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unexpected IOException writing to a StringWriter.", e);
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException e) {
                throw new IllegalStateException("Unexpected IOException closing a StringWriter.", e);
            }
        }
    }

    private void mergeBeanModelsIntoXMLGraphs() {
        Set<Map.Entry<Class, RootNodeSerializer>> serializerSet = this.serializers.entrySet();
        for (Map.Entry<Class, RootNodeSerializer> rootNodeSerializer : serializerSet) {
            Bean model = this.beanModelSet.getModel(rootNodeSerializer.getKey());
            if (model == null) {
                throw new IllegalStateException("Unexpected error.  No Bean model for type '" + rootNodeSerializer.getKey().getName() + "'.");
            }
            this.merge(rootNodeSerializer.getValue().serializer, model);
        }
    }

    private void merge(XMLElementSerializationNode serializer, Bean bean) {
        boolean isCollection = bean.isCollection();
        for (Binding binding : bean.getBindings()) {
            BeanInstancePopulator populator = binding.getPopulator();
            if (!isCollection && binding instanceof DataBinding) {
                XMLSerializationNode node = serializer.findNode(populator.getConfig().getSelectorSteps());
                if (node == null) continue;
                node.setGetter(this.constructContextualGetter((DataBinding)binding));
                DataDecoder bindingDecoder = binding.getPopulator().getDecoder(this.getSmooks().createExecutionContext().getDeliveryConfig());
                if (!(bindingDecoder instanceof DataEncoder)) continue;
                node.setEncoder((DataEncoder)bindingDecoder);
                continue;
            }
            if (!(binding instanceof WiredBinding)) continue;
            Bean wiredBean = ((WiredBinding)binding).getWiredBean();
            XMLElementSerializationNode node = (XMLElementSerializationNode)serializer.findNode(wiredBean.getCreator().getConfig().getSelectorSteps());
            if (node != null) {
                if (isCollection) {
                    Bean collectionBean = wiredBean.getWiredInto();
                    GetterGraph getter = this.constructContextualGetter(collectionBean);
                    node.setIsCollection(true);
                    node.setCollectionGetter(wiredBean.getBeanId(), getter);
                } else {
                    node.setGetter(this.constructContextualGetter(wiredBean));
                }
            }
            this.merge(serializer, wiredBean);
        }
    }

    private void createRootSerializers(List<XMLElementSerializationNode> graphs) {
        Collection<Bean> beanModels = this.beanModelSet.getModels().values();
        for (Bean model : beanModels) {
            BeanInstanceCreator creator = model.getCreator();
            SelectorStep[] selectorSteps = creator.getConfig().getSelectorSteps();
            XMLElementSerializationNode createNode = (XMLElementSerializationNode)this.findNode(graphs, selectorSteps);
            if (!this.rootElementNames.contains(createNode.getQName())) continue;
            createNode = (XMLElementSerializationNode)createNode.clone();
            createNode.setParent(null);
            Class<?> beanClass = creator.getBeanRuntimeInfo().getPopulateType();
            if (Collection.class.isAssignableFrom(beanClass)) continue;
            this.serializers.put(beanClass, new RootNodeSerializer(creator.getBeanId(), createNode));
            this.addNamespaceAttributes(createNode);
        }
    }

    private void addNamespaceAttributes(XMLElementSerializationNode serializer) {
        Properties namespaces = NamespaceMappings.getMappings(this.getSmooks().getApplicationContext());
        if (namespaces != null) {
            Enumeration<?> namespacePrefixes = namespaces.propertyNames();
            while (namespacePrefixes.hasMoreElements()) {
                String prefix = (String)namespacePrefixes.nextElement();
                String namespace = namespaces.getProperty(prefix);
                QName nsAttributeName = new QName("http://www.w3.org/2000/xmlns/", prefix, "xmlns");
                XMLAttributeSerializationNode nsAttribute = new XMLAttributeSerializationNode(nsAttributeName);
                serializer.getAttributes().add(nsAttribute);
                nsAttribute.setGetter(new ConstantGetter(namespace));
            }
        }
    }

    private List<XMLElementSerializationNode> createExpandedXMLOutputGraphs(SmooksResourceConfigurationList userConfigList) {
        ArrayList<XMLElementSerializationNode> graphRoots = new ArrayList<XMLElementSerializationNode>();
        for (int i = 0; i < userConfigList.size(); ++i) {
            SmooksResourceConfiguration config = userConfigList.get(i);
            Object javaResource = config.getJavaResourceObject();
            if (javaResource instanceof BeanInstanceCreator) {
                this.assertSelectorOK(config);
                this.constructNodePath(config.getSelectorSteps(), graphRoots);
                continue;
            }
            if (!(javaResource instanceof BeanInstancePopulator)) continue;
            this.assertSelectorOK(config);
            this.constructNodePath(config.getSelectorSteps(), graphRoots);
        }
        return graphRoots;
    }

    private XMLSerializationNode constructNodePath(SelectorStep[] selectorSteps, List<XMLElementSerializationNode> graphRoots) {
        if (selectorSteps == null || selectorSteps.length == 0) {
            throw new IllegalStateException("Invalid binding configuration.  All <jb:bean> configuration elements must specify fully qualified selector paths (createOnElement, data, executeOnElement attributes etc.).");
        }
        SelectorStep rootSelectorStep = selectorSteps[0];
        XMLElementSerializationNode root = XMLElementSerializationNode.getElement(rootSelectorStep, graphRoots, true);
        if (selectorSteps.length > 1) {
            return root.getPathNode(selectorSteps, 1, true);
        }
        if (rootSelectorStep.getTargetAttribute() != null) {
            return XMLElementSerializationNode.addAttributeNode(root, rootSelectorStep, true);
        }
        return root;
    }

    private XMLSerializationNode findNode(List<XMLElementSerializationNode> graphs, SelectorStep[] selectorSteps) {
        XMLElementSerializationNode root;
        XMLSerializationNode node = root = XMLElementSerializationNode.getElement(selectorSteps[0], graphs, false);
        if (selectorSteps.length > 1) {
            node = root.getPathNode(selectorSteps, 1, false);
        }
        if (node == null) {
            throw new IllegalStateException("Unexpected exception.  Failed to locate the node '" + SelectorStepBuilder.toString(selectorSteps) + "'.");
        }
        return node;
    }

    private void assertSelectorOK(SmooksResourceConfiguration config) {
        String selector = config.getSelector();
        if (selector != null) {
            if (selector.contains("#document") || selector.contains("$document")) {
                throw new SmooksConfigurationException("Cannot use the document selector with the XMLBinding class.  Must use an absolute path.  Selector value '" + selector + "'.");
            }
            if (!(selector.startsWith("/") || selector.startsWith("${") || selector.startsWith("#"))) {
                throw new SmooksConfigurationException("Invalid selector value '" + selector + "'.  Selector paths must be absolute.");
            }
            this.rootElementNames.add(config.getSelectorSteps()[0].getTargetElement());
        }
    }

    private class RootNodeSerializer {
        private String beanId;
        private XMLElementSerializationNode serializer;

        private RootNodeSerializer(String beanId, XMLElementSerializationNode serializer) {
            this.beanId = beanId;
            this.serializer = serializer;
        }
    }
}

