/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.javabean.binding.xml;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.xml.namespace.QName;
import org.dhatim.cdr.xpath.SelectorStep;
import org.dhatim.javabean.binding.SerializationContext;
import org.dhatim.javabean.binding.model.get.Getter;
import org.dhatim.javabean.binding.model.get.GetterGraph;
import org.dhatim.javabean.binding.xml.XMLAttributeSerializationNode;
import org.dhatim.javabean.binding.xml.XMLSerializationNode;
import org.dhatim.xml.XmlUtil;

public class XMLElementSerializationNode
extends XMLSerializationNode {
    private List<XMLAttributeSerializationNode> attributes = new ArrayList<XMLAttributeSerializationNode>();
    private List<XMLElementSerializationNode> elements = new ArrayList<XMLElementSerializationNode>();
    private static final char[] INDENT_BUF = new char[512];

    public XMLElementSerializationNode(QName qName) {
        super(qName);
    }

    public List<XMLAttributeSerializationNode> getAttributes() {
        return this.attributes;
    }

    public List<XMLElementSerializationNode> getElements() {
        return this.elements;
    }

    @Override
    public void serialize(Writer outputStream, SerializationContext context) throws IOException {
        this.indent(outputStream, context);
        outputStream.write("<");
        this.writeName(outputStream);
        this.writeAttributes(outputStream, context);
        if (this.elements.isEmpty()) {
            String value = this.getValue(context);
            if (value != null) {
                char[] characters = value.toCharArray();
                outputStream.write(">");
                XmlUtil.encodeTextValue(characters, 0, characters.length, outputStream);
                outputStream.write("</");
                this.writeName(outputStream);
                outputStream.write(">");
            } else {
                outputStream.write("/>");
            }
        } else {
            outputStream.write(">");
            this.writeElements(outputStream, context);
            outputStream.write("\n");
            this.indent(outputStream, context);
            outputStream.write("</");
            this.writeName(outputStream);
            outputStream.write(">");
        }
    }

    private void writeAttributes(Writer outputStream, SerializationContext context) throws IOException {
        for (XMLAttributeSerializationNode attribute : this.attributes) {
            attribute.serialize(outputStream, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeElements(Writer outputStream, SerializationContext context) throws IOException {
        context.incDepth();
        for (XMLElementSerializationNode element : this.elements) {
            if (element.isCollection) {
                XMLSerializationNode.NodeGetter collectionNodeGetter = element.getCollectionGetter();
                Getter collectionGetter = collectionNodeGetter.getter;
                List<Object> collection = null;
                Object collectionObject = collectionGetter instanceof GetterGraph ? context.getValue(((GetterGraph)collectionGetter).getContextObjectName(), collectionGetter) : context.getValue(collectionGetter);
                if (collectionObject instanceof List) {
                    collection = (List<Object>)collectionObject;
                } else if (collectionObject instanceof Object[]) {
                    collection = Arrays.asList((Object[])collectionObject);
                }
                if (collection == null || collection.isEmpty()) continue;
                try {
                    for (Object collectionItem : collection) {
                        context.addObject(collectionNodeGetter.contextObjectName, collectionItem);
                        outputStream.write("\n");
                        element.serialize(outputStream, context);
                    }
                    continue;
                }
                finally {
                    context.removeObject(collectionNodeGetter.contextObjectName);
                    continue;
                }
            }
            if (!element.hasData(context)) continue;
            outputStream.write("\n");
            element.serialize(outputStream, context);
        }
        context.decDepth();
    }

    @Override
    protected boolean hasData(SerializationContext context) {
        if (super.hasData(context)) {
            return true;
        }
        for (XMLAttributeSerializationNode attribute : this.attributes) {
            if (!attribute.hasData(context)) continue;
            return true;
        }
        return false;
    }

    private void indent(Writer outputStream, SerializationContext context) throws IOException {
        int indent = context.getCurrentDepth() * 4;
        if (indent > 0) {
            indent = Math.min(indent, INDENT_BUF.length);
            outputStream.write(INDENT_BUF, 0, indent);
        }
    }

    public XMLSerializationNode findNode(SelectorStep[] selectorSteps) {
        if (selectorSteps.length == 1) {
            if (selectorSteps[0].getTargetAttribute() != null) {
                return XMLElementSerializationNode.getAttribute(selectorSteps[0], this.attributes, false);
            }
            return this;
        }
        return this.getPathNode(selectorSteps, 1, false);
    }

    public XMLSerializationNode getPathNode(SelectorStep[] selectorSteps, int stepIndex, boolean create) {
        if (stepIndex >= selectorSteps.length) {
            throw new IllegalStateException("Unexpected call to 'addPathNode'.  SelectorStep index out of bounds.");
        }
        SelectorStep selectorStep = selectorSteps[stepIndex];
        if (stepIndex == selectorSteps.length - 1 && selectorStep.getTargetAttribute() != null) {
            XMLElementSerializationNode elementNode = XMLElementSerializationNode.getElement(selectorStep, this.elements, create);
            return XMLElementSerializationNode.addAttributeNode(elementNode, selectorStep, create);
        }
        XMLElementSerializationNode childElement = XMLElementSerializationNode.getElement(selectorStep, this.elements, create);
        if (childElement != null) {
            childElement.setParent(this);
            if (stepIndex < selectorSteps.length - 1) {
                return childElement.getPathNode(selectorSteps, stepIndex + 1, create);
            }
            return childElement;
        }
        return null;
    }

    public static XMLSerializationNode addAttributeNode(XMLElementSerializationNode elementNode, SelectorStep selectorStep, boolean create) {
        XMLAttributeSerializationNode attribute = XMLElementSerializationNode.getAttribute(selectorStep, elementNode.attributes, create);
        if (attribute != null) {
            attribute.setParent(elementNode);
        }
        return attribute;
    }

    public static XMLElementSerializationNode getElement(SelectorStep step, Collection<XMLElementSerializationNode> elementList, boolean create) {
        QName qName = step.getTargetElement();
        XMLElementSerializationNode element = XMLElementSerializationNode.getNode(qName, elementList);
        if (element == null && create) {
            element = new XMLElementSerializationNode(qName);
            elementList.add(element);
        }
        return element;
    }

    public static XMLAttributeSerializationNode getAttribute(SelectorStep step, Collection<XMLAttributeSerializationNode> attributeList, boolean create) {
        QName qName = step.getTargetAttribute();
        XMLAttributeSerializationNode attribute = XMLElementSerializationNode.getNode(qName, attributeList);
        if (attribute == null && create) {
            attribute = new XMLAttributeSerializationNode(qName);
            attributeList.add(attribute);
        }
        return attribute;
    }

    protected Object clone() {
        XMLElementSerializationNode clone = new XMLElementSerializationNode(this.qName);
        this.copyProperties(clone);
        for (XMLElementSerializationNode element : this.elements) {
            XMLElementSerializationNode elementClone = (XMLElementSerializationNode)element.clone();
            clone.elements.add(elementClone);
            elementClone.setParent(clone);
        }
        for (XMLAttributeSerializationNode attribute : this.attributes) {
            XMLAttributeSerializationNode attributeClone = (XMLAttributeSerializationNode)attribute.clone();
            clone.attributes.add(attributeClone);
            attributeClone.setParent(clone);
        }
        return clone;
    }

    static {
        Arrays.fill(INDENT_BUF, ' ');
    }
}

