/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.javabean.decoders;

import java.text.NumberFormat;
import java.text.ParseException;
import org.dhatim.javabean.DataDecodeException;
import org.dhatim.javabean.DecodeType;
import org.dhatim.javabean.decoders.NumberDecoder;

@DecodeType(value={Long.class, long.class})
public class LongDecoder
extends NumberDecoder {
    @Override
    public Object decode(String data) throws DataDecodeException {
        NumberFormat format = this.getNumberFormat();
        if (format != null) {
            try {
                Number number = format.parse(data.trim());
                if (this.isPercentage()) {
                    return (long)(number.doubleValue() * 100.0);
                }
                return number.longValue();
            }
            catch (ParseException e) {
                throw new DataDecodeException("Failed to decode Long value '" + data + "' using NumberFormat instance " + format + ".", e);
            }
        }
        try {
            return Long.parseLong(data.trim());
        }
        catch (NumberFormatException e) {
            throw new DataDecodeException("Failed to decode Long value '" + data + "'.", e);
        }
    }
}

