/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.javabean.decoders;

import java.text.NumberFormat;
import java.text.ParseException;
import org.dhatim.javabean.DataDecodeException;
import org.dhatim.javabean.DecodeType;
import org.dhatim.javabean.decoders.NumberDecoder;

@DecodeType(value={Short.class, short.class})
public class ShortDecoder
extends NumberDecoder {
    @Override
    public Object decode(String data) throws DataDecodeException {
        NumberFormat format = this.getNumberFormat();
        if (format != null) {
            try {
                Number number = format.parse(data.trim());
                if (this.isPercentage()) {
                    return (short)(number.doubleValue() * 100.0);
                }
                return number.shortValue();
            }
            catch (ParseException e) {
                throw new DataDecodeException("Failed to decode Short value '" + data + "' using NumberFormat instance " + format + ".", e);
            }
        }
        try {
            return Short.parseShort(data.trim());
        }
        catch (NumberFormatException e) {
            throw new DataDecodeException("Failed to decode Short value '" + data + "'.", e);
        }
    }
}

