/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.namespace;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class NamespaceDeclarationStack {
    private final Stack<Map<String, String>> namespaceStack = new Stack();
    private final Stack<XMLReader> readerStack = new Stack();

    public NamespaceDeclarationStack() {
    }

    public NamespaceDeclarationStack(XMLReader xmlReader) {
        this.pushReader(xmlReader);
    }

    public Attributes pushNamespaces(String qName, String namespace, Attributes attributes) throws SAXException {
        String[] qNameTokens;
        String prefix;
        if (!(attributes != null && attributes.getLength() != 0 || namespace != null && !"".equals(namespace))) {
            this.namespaceStack.push(Collections.EMPTY_MAP);
            return attributes;
        }
        LinkedHashMap<String, String> nsToURI = Collections.EMPTY_MAP;
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                String localName;
                String attrNS = attributes.getURI(i);
                if (attrNS == null || !attrNS.equals("http://www.w3.org/2000/xmlns/")) continue;
                if (nsToURI == Collections.EMPTY_MAP) {
                    nsToURI = new LinkedHashMap<String, String>();
                }
                if ((localName = attributes.getLocalName(i)).equals("xmlns")) {
                    nsToURI.put("", attributes.getValue(i));
                    continue;
                }
                nsToURI.put(localName, attributes.getValue(i));
            }
        }
        if (!("".equals(namespace) || this.prefixAlreadyDeclared(prefix = (qNameTokens = qName.split(":")).length == 1 ? "" : qNameTokens[0]) || nsToURI.containsKey(prefix))) {
            if (nsToURI == Collections.EMPTY_MAP) {
                nsToURI = new LinkedHashMap();
            }
            nsToURI.put(prefix, namespace);
        }
        if (!nsToURI.isEmpty() && !this.readerStack.isEmpty()) {
            Set namespaces = nsToURI.entrySet();
            ContentHandler contentHandler = this.readerStack.peek().getContentHandler();
            if (contentHandler != null) {
                for (Map.Entry ns : namespaces) {
                    contentHandler.startPrefixMapping((String)ns.getKey(), (String)ns.getValue());
                }
            }
        }
        this.namespaceStack.push((Map<String, String>)nsToURI);
        return attributes;
    }

    public void popNamespaces() throws SAXException {
        Map<String, String> namespaces = this.namespaceStack.pop();
        if (!namespaces.isEmpty() && !this.readerStack.isEmpty()) {
            Set<String> nsPrefixes = namespaces.keySet();
            ContentHandler contentHandler = this.readerStack.peek().getContentHandler();
            if (contentHandler != null) {
                for (String prefix : nsPrefixes) {
                    contentHandler.endPrefixMapping(prefix);
                }
            }
        }
    }

    public void pushReader(XMLReader reader) {
        this.readerStack.push(reader);
    }

    public XMLReader popReader() {
        return this.readerStack.pop();
    }

    public String getPrefix(String uri) {
        int stackDepth = this.namespaceStack.size();
        for (int i = stackDepth - 1; i >= 0; --i) {
            Map nsMap = (Map)this.namespaceStack.get(i);
            if (nsMap.isEmpty()) continue;
            Set nsEntries = nsMap.entrySet();
            for (Map.Entry nsEntry : nsEntries) {
                if (!((String)nsEntry.getValue()).equals(uri)) continue;
                return (String)nsEntry.getKey();
            }
        }
        return null;
    }

    public Map<String, String> getActiveNamespaces() {
        HashMap<String, String> activeNamespaces = new HashMap<String, String>();
        int stackDepth = this.namespaceStack.size();
        for (int i = stackDepth - 1; i >= 0; --i) {
            Map nsMap = (Map)this.namespaceStack.get(i);
            if (nsMap.isEmpty()) continue;
            activeNamespaces.putAll(nsMap);
        }
        return activeNamespaces;
    }

    public String getUri(String getKey) {
        int stackDepth = this.namespaceStack.size();
        for (int i = stackDepth - 1; i >= 0; --i) {
            Map nsMap = (Map)this.namespaceStack.get(i);
            if (nsMap.isEmpty()) continue;
            Set nsEntries = nsMap.entrySet();
            for (Map.Entry nsEntry : nsEntries) {
                if (!((String)nsEntry.getKey()).equals(getKey)) continue;
                return (String)nsEntry.getValue();
            }
        }
        return null;
    }

    private boolean prefixAlreadyDeclared(String prefix) {
        for (Map map : this.namespaceStack) {
            if (!map.containsKey(prefix)) continue;
            return true;
        }
        return false;
    }
}

