/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.routing.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dhatim.assertion.AssertArgument;
import org.dhatim.cdr.SmooksConfigurationException;
import org.dhatim.javabean.expression.BeanMapExpressionEvaluator;
import org.dhatim.routing.db.StatementType;
import org.dhatim.util.DollarBraceDecoder;
import org.dhatim.util.MVELTemplate;
import org.dhatim.xml.XmlUtil;

public class StatementExec {
    private String statement;
    private StatementType statementType;
    private boolean isJoin;
    private List<BeanMapExpressionEvaluator> statementExpressionEvaluators = new ArrayList<BeanMapExpressionEvaluator>();
    private MVELTemplate updateStatementTemplate;

    public StatementExec(String statementString) throws SmooksConfigurationException {
        AssertArgument.isNotNull(statementString, "statementString");
        this.statement = XmlUtil.removeEntities(statementString).trim();
        if (this.statement.toLowerCase().startsWith("select")) {
            this.statementType = StatementType.QUERY;
        } else {
            this.statementType = StatementType.UPDATE;
            this.updateStatementTemplate = new MVELTemplate(this.statement);
        }
        List<String> statementExecFields = DollarBraceDecoder.getTokens(this.statement);
        this.intitialiseStatementExpressions(statementExecFields);
        this.statement = DollarBraceDecoder.replaceTokens(this.statement, "?");
        this.isJoin = !statementExecFields.isEmpty();
    }

    private void intitialiseStatementExpressions(List<String> statementExecFields) {
        for (String statementExecField : statementExecFields) {
            BeanMapExpressionEvaluator expression = new BeanMapExpressionEvaluator();
            expression.setExpression(statementExecField);
            this.statementExpressionEvaluators.add(expression);
        }
    }

    public String getStatement() {
        return this.statement;
    }

    public StatementType getStatementType() {
        return this.statementType;
    }

    public boolean isJoin() {
        return this.isJoin;
    }

    public List<Map<String, Object>> executeUnjoinedQuery(Connection dbConnection, Object ... params) throws SQLException {
        return this.executeUnjoinedQuery(dbConnection, Arrays.asList(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> executeUnjoinedQuery(Connection dbConnection, List<Object> params) throws SQLException {
        try (PreparedStatement preparedStatement = dbConnection.prepareStatement(this.statement);){
            ArrayList<Map<String, Object>> arrayList;
            for (int i = 0; params != null && i < params.size(); ++i) {
                preparedStatement.setObject(i + 1, params.get(i));
            }
            ResultSet resultSet = preparedStatement.executeQuery();
            try {
                ArrayList<Map<String, Object>> resultMap = new ArrayList<Map<String, Object>>();
                this.mapResultSet(resultSet, resultMap);
                arrayList = resultMap;
            }
            catch (Throwable throwable) {
                resultSet.close();
                throw throwable;
            }
            resultSet.close();
            return arrayList;
        }
    }

    public int executeUnjoinedUpdate(Connection dbConnection, Object ... params) throws SQLException {
        return this.executeUnjoinedUpdate(dbConnection, Arrays.asList(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUnjoinedUpdate(Connection dbConnection, List<Object> params) throws SQLException {
        try (PreparedStatement preparedStatement = dbConnection.prepareStatement(this.statement);){
            for (int i = 0; params != null && i < params.size(); ++i) {
                preparedStatement.setObject(i + 1, params.get(i));
            }
            int n = preparedStatement.executeUpdate();
            return n;
        }
    }

    public void executeJoinedStatement(Connection dbConnection, List<Map<String, Object>> resultSet) throws SQLException {
        for (Map<String, Object> row : resultSet) {
            this.executeJoinedStatement(dbConnection, row);
        }
    }

    public void executeJoinedStatement(Connection dbConnection, Map<String, Object> beanMap) throws SQLException {
        if (this.getStatementType() == StatementType.QUERY) {
            this.executeJoinedQuery(dbConnection, beanMap);
        } else {
            this.executeJoinedUpdate(dbConnection, beanMap);
        }
    }

    public void executeJoinedQuery(Connection dbConnection, Map<String, Object> beanMap) throws SQLException {
        this.executeJoinedQuery(dbConnection, beanMap, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeJoinedQuery(Connection dbConnection, Map<String, Object> beanMap, List<Map<String, Object>> resultMap) throws SQLException {
        try (PreparedStatement preparedStatement = dbConnection.prepareStatement(this.statement);){
            this.setStatementParamaters(preparedStatement, beanMap);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (resultMap == null) {
                    if (resultSet.next()) {
                        this.mapResultSetRowToMap(resultSet, beanMap);
                    }
                } else {
                    this.mapResultSet(resultSet, resultMap);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeJoinedUpdate(Connection dbConnection, Map<String, Object> beanMap) throws SQLException {
        try (PreparedStatement preparedStatement = dbConnection.prepareStatement(this.statement);){
            this.setStatementParamaters(preparedStatement, beanMap);
            int n = preparedStatement.executeUpdate();
            return n;
        }
    }

    private void setStatementParamaters(PreparedStatement preparedStatement, Map<String, Object> beanMap) throws SQLException {
        for (int i = 0; i < this.statementExpressionEvaluators.size(); ++i) {
            Object value;
            try {
                value = this.statementExpressionEvaluators.get(i).getValue(beanMap);
            }
            catch (Throwable t) {
                SQLException e = new SQLException("Error evaluting expression '" + this.statementExpressionEvaluators.get(i).getExpression() + "' on map " + beanMap);
                e.initCause(t);
                throw e;
            }
            preparedStatement.setObject(i + 1, value);
        }
    }

    public String getUpdateStatement(Map<String, Object> beanMap) {
        if (this.updateStatementTemplate == null) {
            throw new RuntimeException("Illegal call to getUpdateStatement().  This is not an 'update' statement.");
        }
        return this.updateStatementTemplate.apply(beanMap);
    }

    private void mapResultSet(ResultSet resultSet, List<Map<String, Object>> resultMap) throws SQLException {
        while (resultSet.next()) {
            LinkedHashMap<String, Object> row = new LinkedHashMap<String, Object>();
            this.mapResultSetRowToMap(resultSet, row);
            resultMap.add(row);
        }
    }

    private void mapResultSetRowToMap(ResultSet resultSet, Map<String, Object> beanMap) throws SQLException {
        ResultSetMetaData resultSetMD = resultSet.getMetaData();
        int columnCount = resultSetMD.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            String colName = resultSetMD.getColumnName(i + 1);
            Object rowValue = resultSet.getObject(i + 1);
            beanMap.put(colName, rowValue);
        }
    }
}

