/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.scribe.invoker;

import java.util.Map;
import org.dhatim.assertion.AssertArgument;
import org.dhatim.scribe.NoMethodWithAnnotationFoundException;
import org.dhatim.scribe.annotation.Delete;
import org.dhatim.scribe.annotation.Flush;
import org.dhatim.scribe.annotation.Insert;
import org.dhatim.scribe.annotation.Lookup;
import org.dhatim.scribe.annotation.LookupByQuery;
import org.dhatim.scribe.annotation.Update;
import org.dhatim.scribe.invoker.DaoInvoker;
import org.dhatim.scribe.reflection.AnnotatedDaoRuntimeInfo;
import org.dhatim.scribe.reflection.EntityMethod;
import org.dhatim.scribe.reflection.FlushMethod;
import org.dhatim.scribe.reflection.LookupMethod;
import org.dhatim.scribe.reflection.LookupWithNamedQueryMethod;
import org.dhatim.scribe.reflection.LookupWithPositionalQueryMethod;

public class AnnotatedDaoInvoker
implements DaoInvoker {
    private final Object dao;
    private final AnnotatedDaoRuntimeInfo daoRuntimeInfo;

    public AnnotatedDaoInvoker(Object dao, AnnotatedDaoRuntimeInfo daoRuntimeInfo) {
        AssertArgument.isNotNull(dao, "dao");
        AssertArgument.isNotNull(daoRuntimeInfo, "daoRuntimeInfo");
        this.dao = dao;
        this.daoRuntimeInfo = daoRuntimeInfo;
    }

    @Override
    public void flush() {
        FlushMethod method = this.daoRuntimeInfo.getFlushMethod();
        this.assertMethod(method, Flush.class);
        method.invoke(this.dao);
    }

    @Override
    public Object update(Object entity) {
        EntityMethod method = this.daoRuntimeInfo.getDefaultUpdateMethod();
        this.assertMethod(method, Update.class);
        return method.invoke(this.dao, entity);
    }

    @Override
    public Object update(String name, Object entity) {
        EntityMethod method = this.daoRuntimeInfo.getUpdateMethod(name);
        this.assertMethod(method, name, Update.class);
        return method.invoke(this.dao, entity);
    }

    @Override
    public Object insert(Object entity) {
        EntityMethod method = this.daoRuntimeInfo.getDefaultInsertMethod();
        this.assertMethod(method, Insert.class);
        return method.invoke(this.dao, entity);
    }

    @Override
    public Object insert(String name, Object entity) {
        EntityMethod method = this.daoRuntimeInfo.getInsertMethod(name);
        this.assertMethod(method, name, Insert.class);
        return method.invoke(this.dao, entity);
    }

    @Override
    public Object delete(Object entity) {
        EntityMethod method = this.daoRuntimeInfo.getDefaultDeleteMethod();
        this.assertMethod(method, Delete.class);
        return method.invoke(this.dao, entity);
    }

    @Override
    public Object delete(String name, Object entity) {
        EntityMethod method = this.daoRuntimeInfo.getDeleteMethod(name);
        this.assertMethod(method, name, Delete.class);
        return method.invoke(this.dao, entity);
    }

    @Override
    public Object lookupByQuery(String query, Object ... parameters) {
        LookupWithPositionalQueryMethod method = this.daoRuntimeInfo.getLookupByPositionalQueryMethod();
        if (method == null) {
            throw new NoMethodWithAnnotationFoundException("No method found in DAO class '" + this.dao.getClass().getName() + "' that is annotated " + "with '" + LookupByQuery.class.getSimpleName() + "' annotation and has an Array argument for the positional parameters.");
        }
        return method.invoke(this.dao, query, parameters);
    }

    @Override
    public Object lookupByQuery(String query, Map<String, ?> parameters) {
        LookupWithNamedQueryMethod method = this.daoRuntimeInfo.getLookupByNamedQueryMethod();
        if (method == null) {
            throw new NoMethodWithAnnotationFoundException("No method found in DAO class '" + this.dao.getClass().getName() + "' that is annotated " + "with '" + LookupByQuery.class.getSimpleName() + "' annotation and has a Map argument for the named parameters.");
        }
        return method.invoke(this.dao, query, parameters);
    }

    @Override
    public Object lookup(String name, Map<String, ?> parameters) {
        LookupMethod method = this.daoRuntimeInfo.getLookupWithNamedParametersMethod(name);
        this.assertMethod(method, name, Lookup.class);
        return method.invoke(this.dao, parameters);
    }

    @Override
    public Object lookup(String name, Object ... parameters) {
        LookupMethod method = this.daoRuntimeInfo.getLookupWithNamedParametersMethod(name);
        this.assertMethod(method, name, Lookup.class);
        return method.invoke(this.dao, parameters);
    }

    private void assertMethod(Object method, Class<?> annotation) {
        if (method == null) {
            throw new NoMethodWithAnnotationFoundException("No method found in DAO class '" + this.dao.getClass().getName() + "' that is annotated with the '" + annotation.getSimpleName() + "' annotation.");
        }
    }

    private void assertMethod(Object method, String name, Class<?> annotation) {
        if (method == null) {
            throw new NoMethodWithAnnotationFoundException("No method found in DAO class '" + this.dao.getClass().getName() + "' that is annotated with the '" + annotation.getSimpleName() + "' annotation and has the name '" + name + "'.");
        }
    }
}

