/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.smooks.edi;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dhatim.cdr.ProfileTargetingExpression;
import org.dhatim.cdr.SmooksResourceConfiguration;
import org.dhatim.cdr.annotation.AppContext;
import org.dhatim.cdr.annotation.Config;
import org.dhatim.cdr.annotation.ConfigParam;
import org.dhatim.container.ApplicationContext;
import org.dhatim.container.ExecutionContext;
import org.dhatim.edisax.EDIConfigurationException;
import org.dhatim.edisax.EDIParser;
import org.dhatim.edisax.model.EdifactModel;
import org.dhatim.resource.ContainerResourceLocator;
import org.dhatim.resource.URIResourceLocator;
import org.dhatim.xml.SmooksXMLReader;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class EDIReader
extends EDIParser
implements SmooksXMLReader {
    private static Log logger = LogFactory.getLog(EDIReader.class);
    private static String MAPPING_TABLE_CTX_KEY = EDIReader.class.getName() + "#MAPPING_TABLE_CTX_KEY";
    public static final String MODEL_CONFIG_KEY = "mapping-model";
    @Config
    private SmooksResourceConfiguration configuration;
    @AppContext
    private ApplicationContext applicationContext;
    @ConfigParam(name="mapping-model")
    private String modelConfigData;
    @ConfigParam(defaultVal="false")
    private boolean ignoreNewLines;
    @ConfigParam(defaultVal="UTF-8")
    private Charset encoding;
    @ConfigParam(defaultVal="false")
    private Boolean validate;

    @Override
    public void setExecutionContext(ExecutionContext executionContext) {
    }

    @Override
    public void parse(InputSource ediSource) throws IOException, SAXException {
        EdifactModel edi2xmlMappingModel = this.getMappingModel();
        this.setMappingModel(edi2xmlMappingModel);
        this.setFeature("http://xml.org/sax/features/validation", this.validate);
        this.setFeature("http://xml.org/sax/features/ignore-newlines", this.ignoreNewLines);
        super.parse(ediSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EdifactModel getMappingModel() throws IOException, SAXException {
        EdifactModel edifactModel;
        Hashtable mappings = EDIReader.getMappingTable(this.applicationContext);
        SmooksResourceConfiguration smooksResourceConfiguration = this.configuration;
        synchronized (smooksResourceConfiguration) {
            edifactModel = (EdifactModel)mappings.get(this.configuration);
            if (edifactModel == null) {
                try {
                    ContainerResourceLocator resourceLocator = this.applicationContext.getResourceLocator();
                    if (this.modelConfigData.startsWith("urn:") || this.modelConfigData.endsWith(".jar") || this.modelConfigData.endsWith(".zip")) {
                        throw new IOException("Unsupported mapping model config URI for basic EDI Parser '" + this.modelConfigData + "'.  Check that you are using the correct EDI parser.  You may need to configure an Interchange Parser, such as the UN/EDIFACT parser.");
                    }
                    edifactModel = resourceLocator instanceof URIResourceLocator ? EDIParser.parseMappingModel(this.modelConfigData, resourceLocator.getBaseURI()) : EDIParser.parseMappingModel(this.modelConfigData, URIResourceLocator.getSystemBaseURI());
                    if (edifactModel == null) {
                        logger.error((Object)("Invalid mapping-model config value '" + this.modelConfigData + "'. Failed to locate EDI Mapping Model resource!"));
                    }
                }
                catch (IOException e) {
                    IOException newE = new IOException("Error parsing EDI mapping model [" + this.configuration.getStringParameter(MODEL_CONFIG_KEY) + "].  Target Profile(s) " + this.getTargetProfiles() + ".");
                    newE.initCause(e);
                    throw newE;
                }
                catch (SAXException e) {
                    throw new SAXException("Error parsing EDI mapping model [" + this.configuration.getStringParameter(MODEL_CONFIG_KEY) + "].  Target Profile(s) " + this.getTargetProfiles() + ".", e);
                }
                catch (EDIConfigurationException e) {
                    throw new SAXException("Error parsing EDI mapping model [" + this.configuration.getStringParameter(MODEL_CONFIG_KEY) + "].  Target Profile(s) " + this.getTargetProfiles() + ".", e);
                }
                mappings.put(this.configuration, edifactModel);
                logger.debug((Object)("Parsed, validated and cached EDI mapping model [" + edifactModel.getEdimap().getDescription().getName() + ", Version " + edifactModel.getEdimap().getDescription().getVersion() + "].  Target Profile(s) " + this.getTargetProfiles() + "."));
            } else if (logger.isInfoEnabled()) {
                logger.debug((Object)("Found EDI mapping model [" + edifactModel.getEdimap().getDescription().getName() + ", Version " + edifactModel.getEdimap().getDescription().getVersion() + "] in the model cache.  Target Profile(s) " + this.getTargetProfiles() + "."));
            }
        }
        return edifactModel;
    }

    protected static Hashtable getMappingTable(ApplicationContext context) {
        Hashtable mappingModelTable = (Hashtable)context.getAttribute(MAPPING_TABLE_CTX_KEY);
        if (mappingModelTable == null) {
            mappingModelTable = new Hashtable();
            context.setAttribute(MAPPING_TABLE_CTX_KEY, mappingModelTable);
        }
        return mappingModelTable;
    }

    private List<ProfileTargetingExpression> getTargetProfiles() {
        return Arrays.asList(this.configuration.getProfileTargetingExpressions());
    }
}

