/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.templating.stringtemplate;

import java.util.Map;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.dhatim.cdr.SmooksConfigurationException;
import org.dhatim.cdr.SmooksResourceConfiguration;
import org.dhatim.cdr.annotation.AppContext;
import org.dhatim.cdr.annotation.Configurator;
import org.dhatim.container.ApplicationContext;
import org.dhatim.container.ExecutionContext;
import org.dhatim.delivery.ContentHandler;
import org.dhatim.delivery.ContentHandlerFactory;
import org.dhatim.delivery.annotation.Resource;
import org.dhatim.delivery.dom.serialize.TextSerializationUnit;
import org.dhatim.delivery.ordering.Consumer;
import org.dhatim.event.report.annotation.VisitAfterReport;
import org.dhatim.event.report.annotation.VisitBeforeReport;
import org.dhatim.templating.AbstractTemplateProcessor;
import org.w3c.dom.Element;

@Resource(type="st")
public class StringTemplateContentHandlerFactory
implements ContentHandlerFactory {
    @AppContext
    private ApplicationContext applicationContext;

    @Override
    public synchronized ContentHandler create(SmooksResourceConfiguration resourceConfig) throws SmooksConfigurationException, InstantiationException {
        try {
            return Configurator.configure(new StringTemplateTemplateProcessor(), resourceConfig, this.applicationContext);
        }
        catch (SmooksConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            InstantiationException instanceException = new InstantiationException("StringTemplate ProcessingUnit resource [" + resourceConfig.getResource() + "] not loadable.  StringTemplate resource invalid.");
            instanceException.initCause(e);
            throw instanceException;
        }
    }

    @VisitBeforeReport(condition="false")
    @VisitAfterReport(summary="Applied StringTemplate Template.", detailTemplate="reporting/StringTemplateTemplateProcessor_After.html")
    private static class StringTemplateTemplateProcessor
    extends AbstractTemplateProcessor
    implements Consumer {
        private StringTemplate template;

        private StringTemplateTemplateProcessor() {
        }

        @Override
        protected void loadTemplate(SmooksResourceConfiguration config) {
            String path = config.getResource();
            if (path.charAt(0) == '/') {
                path = path.substring(1);
            }
            if (path.endsWith(".st")) {
                path = path.substring(0, path.length() - 3);
            }
            StringTemplateGroup templateGroup = new StringTemplateGroup(path);
            templateGroup.setFileCharEncoding(this.getEncoding().displayName());
            this.template = templateGroup.getInstanceOf(path);
        }

        @Override
        protected void visit(Element element, ExecutionContext executionContext) {
            StringTemplate thisTransTemplate = this.template.getInstanceOf();
            Map<String, Object> beans = executionContext.getBeanContext().getBeanMap();
            thisTransTemplate.setAttributes(beans);
            String templatingResult = thisTransTemplate.toString();
            Element resultNode = TextSerializationUnit.createTextElement(element, templatingResult);
            this.processTemplateAction(element, resultNode, executionContext);
        }

        @Override
        public boolean consumes(Object object) {
            return this.template.getTemplate().indexOf(object.toString()) != -1;
        }
    }
}

