/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dhatim.io.StreamUtils;
import org.dhatim.util.StdoutToLog4jFilter;
import org.hsqldb.DatabaseManager;
import org.hsqldb.Server;
import org.hsqldb.jdbcDriver;

public class HsqlServer {
    private static Log logger = LogFactory.getLog(HsqlServer.class);
    private Server hsqlServer;
    private String url;
    private String username = "sa";
    private String password = "";
    private Connection connection;
    private final CountDownLatch startGate = new CountDownLatch(1);

    public HsqlServer(final int port) throws Exception {
        final String databaseName = "milyn-hsql-" + port;
        this.url = "jdbc:hsqldb:hsql://localhost:" + port + "/" + databaseName + ";shutdown=true";
        logger.info((Object)("Starting Hypersonic Database '" + this.url + "'."));
        new Thread(){

            @Override
            public void run() {
                Server server = new Server();
                Log targetLogger = LogFactory.getLog((String)"org.hsqldb");
                server.setLogWriter(new PrintWriter(new StdoutToLog4jFilter(server.getLogWriter(), targetLogger)));
                server.setDatabasePath(0, "target/hsql/" + databaseName);
                server.setDatabaseName(0, databaseName);
                server.setNoSystemExit(true);
                server.setSilent(true);
                server.setPort(port);
                server.start();
                HsqlServer.this.hsqlServer = server;
                HsqlServer.this.startGate.countDown();
            }
        }.start();
        this.startGate.await();
        DriverManager.registerDriver((Driver)new jdbcDriver());
        this.connection = DriverManager.getConnection(this.url, this.username, this.password);
    }

    public void stop() throws Exception {
        try {
            this.hsqlServer.signalCloseAllServerConnections();
            this.connection.close();
        }
        catch (SQLException ignored) {
            logger.debug((Object)ignored.getMessage(), (Throwable)ignored);
        }
        finally {
            this.hsqlServer.stop();
            DatabaseManager.closeDatabases((int)0);
            while (this.hsqlServer.getState() != 16) {
                Thread.sleep(100L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execScript(InputStream script) throws SQLException {
        String scriptString;
        try {
            scriptString = StreamUtils.readStream(new InputStreamReader(script));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try (Statement statement = this.connection.createStatement();){
            boolean bl = statement.execute(scriptString);
            return bl;
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public int getState() {
        if (this.hsqlServer == null) {
            throw new IllegalStateException("hsqlServer was null. Perhaps there was an error upon startup?");
        }
        return this.hsqlServer.getState();
    }
}

