/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.javabean.decoders;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.text.ParseException;
import org.dhatim.javabean.DataDecodeException;
import org.dhatim.javabean.DecodeType;
import org.dhatim.javabean.decoders.NumberDecoder;

@DecodeType(value={BigDecimal.class})
public class BigDecimalDecoder
extends NumberDecoder {
    public Object decode(String data) throws DataDecodeException {
        NumberFormat format = this.getNumberFormat();
        if (format != null) {
            try {
                Number number = format.parse(data.trim());
                if (number instanceof BigDecimal) {
                    return number;
                }
                if (number instanceof BigInteger) {
                    return new BigDecimal((BigInteger)number);
                }
                return new BigDecimal(number.doubleValue());
            }
            catch (ParseException e) {
                throw new DataDecodeException("Failed to decode BigDecimal value '" + data + "' using NumberFormat instance " + format + ".", (Throwable)e);
            }
        }
        try {
            return new BigDecimal(data.trim());
        }
        catch (NumberFormatException e) {
            throw new DataDecodeException("Failed to decode BigDecimal value '" + data + "'.", (Throwable)e);
        }
    }
}

