/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.javabean.decoders;

import java.util.Properties;
import org.dhatim.config.Configurable;
import org.dhatim.javabean.DataDecodeException;
import org.dhatim.javabean.DataDecoder;

public class MappingDecoder
implements DataDecoder,
Configurable {
    private Properties resourceConfig;
    private boolean strict = true;

    public void setConfiguration(Properties resourceConfig) {
        this.resourceConfig = resourceConfig;
        this.strict = resourceConfig.getProperty("strict", "true").equals("true");
    }

    public Properties getConfiguration() {
        return this.resourceConfig;
    }

    public Object decode(String data) throws DataDecodeException {
        if (this.resourceConfig != null) {
            String mappingValue = this.resourceConfig.getProperty(data);
            if (mappingValue == null) {
                if (this.strict) {
                    throw new DataDecodeException("Mapping <param> for data '" + data + "' not defined.");
                }
                return data;
            }
            return mappingValue;
        }
        return data;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }
}

