/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.ejc;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.dhatim.assertion.AssertArgument;
import org.dhatim.edisax.EDIConfigurationException;
import org.dhatim.edisax.model.EdifactModel;
import org.dhatim.edisax.model.internal.Edimap;
import org.dhatim.edisax.model.internal.MappingNode;
import org.dhatim.edisax.util.IllegalNameException;
import org.dhatim.ejc.BeanWriter;
import org.dhatim.ejc.BindingWriter;
import org.dhatim.ejc.ClassModel;
import org.dhatim.ejc.ClassModelCompiler;
import org.dhatim.ejc.EJCLog;
import org.dhatim.ejc.EJCLogFactory;
import org.dhatim.io.FileUtils;
import org.dhatim.io.StreamUtils;
import org.dhatim.javabean.pojogen.JClass;
import org.xml.sax.SAXException;

public class EJC {
    private static Log LOG = EJCLogFactory.getLog(EJC.class);
    private static final String VERISON = "0.1";
    private static final String PARAMETER_BEAN_FOLDER = "-d";
    private static final String PARAMETER_BEAN_PACKAGE = "-p";
    private static final String PARAMETER_VERBOSE = "-version";
    private static final String PARAMETER_QUIET = "-quiet";
    private static final String PARAMETER_HELP = "-help";
    private static final String PARAMETER_VERSION = "-version";
    private Set<String> includes = new LinkedHashSet<String>();
    private boolean addEDIMessageAnnotation = false;
    public static final String BINDINGCONFIG_XML = "bindingconfig.xml";
    public static final String EDIMAPPINGCONFIG_XML = "edimappingconfig.xml";

    public EJC include(String includePackage) {
        AssertArgument.isNotNullAndNotEmpty((String)includePackage, (String)"includePackage");
        this.includes.add(includePackage);
        return this;
    }

    public void addEDIMessageAnnotation(boolean addEDIMessageAnnotation) {
        this.addEDIMessageAnnotation = addEDIMessageAnnotation;
    }

    public void compile(InputStream mappingModel, String configName, String beanPackage, String beanFolder) throws EDIConfigurationException, IOException, SAXException, IllegalNameException, ClassNotFoundException {
        ClassModel model = this.compile(mappingModel, beanPackage);
        String bindingFile = beanFolder + "/" + beanPackage.replace('.', '/') + "/" + BINDINGCONFIG_XML;
        this.writeModelToFolder(model, configName, beanPackage, beanFolder, bindingFile);
    }

    public void compile(InputStream mappingModel, String beanPackage, String beanFolder) throws EDIConfigurationException, IOException, SAXException, IllegalNameException, ClassNotFoundException {
        byte[] mappingModelBytes = StreamUtils.readStream((InputStream)mappingModel);
        ClassModel model = this.compile(new ByteArrayInputStream(mappingModelBytes), beanPackage);
        String bindingFile = beanFolder + "/" + beanPackage.replace('.', '/') + "/" + BINDINGCONFIG_XML;
        this.writeModelToFolder(model, new ByteArrayInputStream(mappingModelBytes), beanPackage, beanFolder, bindingFile);
    }

    public ClassModel compile(Edimap mappingModel, String beanPackage, String beanFolder) throws EDIConfigurationException, IOException, SAXException, IllegalNameException, ClassNotFoundException {
        return this.compile(mappingModel, beanPackage, beanFolder, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassModel compile(Edimap mappingModel, String beanPackage, String beanFolder, Map<MappingNode, JClass> commonTypes) throws EDIConfigurationException, IOException, SAXException, IllegalNameException, ClassNotFoundException {
        ClassModel model = this.compile(mappingModel, beanPackage, commonTypes);
        String bindingFile = beanFolder + "/" + beanPackage.replace('.', '/') + "/" + BINDINGCONFIG_XML;
        this.writeModelToFolder(model, beanFolder, bindingFile);
        String bundleConfigPath = "/" + beanPackage.replace('.', '/') + "/" + EDIMAPPINGCONFIG_XML;
        File mappingFile = new File(beanFolder + bundleConfigPath);
        if (!mappingFile.exists()) {
            try (FileWriter writer = new FileWriter(mappingFile);){
                mappingModel.write((Writer)writer);
            }
        }
        return model;
    }

    public ClassModel compile(InputStream mappingModel, String beanPackage) throws EDIConfigurationException, IOException, SAXException, IllegalNameException, ClassNotFoundException {
        Edimap edimap = this.readEDIConfig(mappingModel);
        return this.compile(edimap, beanPackage, (Map<MappingNode, JClass>)null);
    }

    private ClassModel compile(Edimap edimap, String beanPackage, Map<MappingNode, JClass> commonTypes) throws IllegalNameException {
        LOG.info((Object)"Reading the edi-configuration...");
        ClassModelCompiler classModelCompiler = new ClassModelCompiler(commonTypes, this.addEDIMessageAnnotation);
        return classModelCompiler.compile(edimap, beanPackage);
    }

    public void writeModelToFolder(ClassModel model, InputStream mappingModel, String beanFolder, String bindingFile) throws IOException, IllegalNameException, ClassNotFoundException {
        this.writeModelToFolder(model, mappingModel, model.getRootBeanConfig().getClass().getPackage().getName(), beanFolder, bindingFile);
    }

    private void writeModelToFolder(ClassModel model, String mappingModelPath, String beanPackage, String beanFolder, String bindingFile) throws IOException, IllegalNameException, ClassNotFoundException {
        this.writeModelToFolder(model, new FileInputStream(mappingModelPath), beanPackage, beanFolder, bindingFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeModelToFolder(ClassModel model, InputStream mappingModel, String beanPackage, String beanFolder, String bindingFile) throws IOException, IllegalNameException, ClassNotFoundException {
        try {
            String bundleConfigPath = "/" + beanPackage.replace('.', '/') + "/" + EDIMAPPINGCONFIG_XML;
            this.writeModelToFolder(model, beanFolder, bindingFile);
            FileUtils.writeFile((byte[])StreamUtils.readStream((InputStream)mappingModel), (File)new File(beanFolder + bundleConfigPath));
        }
        finally {
            mappingModel.close();
        }
    }

    private void writeModelToFolder(ClassModel model, String beanFolder, String bindingFile) throws IOException, IllegalNameException, ClassNotFoundException {
        LOG.info((Object)("Writing java beans to " + beanFolder + "..."));
        BeanWriter.writeBeansToFolder(model, beanFolder, bindingFile);
        LOG.info((Object)"Creating bindingfile...");
        BindingWriter bindingWriter = new BindingWriter(model);
        bindingWriter.generate(bindingFile);
        model.setBindingFilePath(bindingFile);
        LOG.info((Object)"-----------------------------------------------------------------------");
        LOG.info((Object)" Compilatation complete.");
        LOG.info((Object)"-----------------------------------------------------------------------");
        LOG.info((Object)" Files are located in folder ");
        LOG.info((Object)(" " + beanFolder));
        LOG.info((Object)"-----------------------------------------------------------------------");
    }

    private Edimap readEDIConfig(InputStream inputStream) throws EDIConfigurationException, IOException, SAXException {
        EdifactModel edifactModel = new EdifactModel(inputStream);
        return edifactModel.getEdimap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException, EDIConfigurationException, IllegalNameException, SAXException, ClassNotFoundException {
        EJC ejc = new EJC();
        if (args.length % 2 == 0) {
            System.out.println(EJC.writeUsageText());
            return;
        }
        String configFile = args[args.length - 1];
        String beanPackage = EJC.getParameter(PARAMETER_BEAN_PACKAGE, args);
        String beanFolder = EJC.getParameter(PARAMETER_BEAN_FOLDER, args);
        boolean isVerbose = EJC.containsParameter("-version", args);
        boolean isQuiet = EJC.containsParameter(PARAMETER_QUIET, args);
        if (EJC.containsParameter(PARAMETER_HELP, args)) {
            System.out.println(EJC.writeAboutText());
            System.out.println(EJC.writeUsageText());
            if (args.length == 1) {
                return;
            }
        }
        if (EJC.containsParameter("-version", args)) {
            System.out.println(EJC.writeVersionText());
            if (args.length == 1) {
                return;
            }
        }
        if (isVerbose && isQuiet) {
            LOG.error((Object)"Both 'quiet' and 'verbose' is activated. Only one of these can be active at once.");
            return;
        }
        ((EJCLog)LOG).setLevel(isVerbose ? EJCLogFactory.Level.DEBUG : (isQuiet ? EJCLogFactory.Level.ERROR : EJCLogFactory.Level.INFO));
        try (InputStream configInputStream = null;){
            configInputStream = new ByteArrayInputStream(StreamUtils.readStream((InputStream)new FileInputStream(configFile)));
            ejc.compile(configInputStream, configFile, beanPackage, beanFolder);
        }
    }

    private static String writeAboutText() {
        return "\n\n***********************************************************************\n* A toolkit for compiling an edi-mapping-file into a class-structure  *\n* with a corresponding binding-config-file.                           *\n***********************************************************************\n";
    }

    private static String writeUsageText() {
        return "Usage: " + EJC.class.getName() + " [-options ...] <edi file/URL/dir>\n" + "Options:\n" + "\n" + "  -d <dir>           :  generated files will go into this directory\n" + "  -p <pkg>           :  specifies the target package\n" + "\n" + "  -verbose           :  be extra verbose\n" + "  -quiet             :  suppress compiler output\n" + "  -help              :  display this help message\n" + "  -version           :  display version information\n\n\n";
    }

    private static String writeVersionText() {
        return "ejc version 0.1\nMilyn Smooks toolkit for binding edi.";
    }

    private static String getParameter(String flag, String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equalsIgnoreCase(flag) || i + 1 >= args.length) continue;
            return args[i + 1];
        }
        throw new RuntimeException("Mandatory command line parameter '' not specified.\n\n" + EJC.writeUsageText());
    }

    private static boolean containsParameter(String flag, String[] args) {
        for (String arg : args) {
            if (!arg.equalsIgnoreCase(flag)) continue;
            return true;
        }
        return false;
    }
}

