/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.ejc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.dhatim.edisax.model.internal.Edimap;
import org.dhatim.edisax.model.internal.MappingNode;
import org.dhatim.ejc.BindingConfig;
import org.dhatim.ejc.EJCLogFactory;
import org.dhatim.javabean.pojogen.JClass;

public class ClassModel {
    private static Log LOG = EJCLogFactory.getLog(ClassModel.class);
    private BindingConfig rootBeanConfig;
    private Edimap edimap;
    private List<JClass> createdClasses;
    private Collection<JClass> referencedClasses;
    private Map<MappingNode, JClass> classesByNode;
    private String bindingFilePath;

    public void setEdimap(Edimap edimap) {
        this.edimap = edimap;
    }

    public Edimap getEdimap() {
        return this.edimap;
    }

    public BindingConfig getRootBeanConfig() {
        return this.rootBeanConfig;
    }

    public void setRootBeanConfig(BindingConfig rootBeanConfig) {
        this.rootBeanConfig = rootBeanConfig;
    }

    public List<JClass> getCreatedClasses() {
        if (this.createdClasses == null) {
            this.createdClasses = new ArrayList<JClass>();
        }
        return this.createdClasses;
    }

    public void addCreatedClass(JClass jclass) {
        this.getCreatedClasses().add(jclass);
        LOG.info((Object)("Added class " + jclass.getPackageName() + "." + jclass.getClassName() + " to model."));
    }

    public void setClassesByNode(Map<MappingNode, JClass> classesBySegref) {
        this.classesByNode = classesBySegref;
    }

    public Map<MappingNode, JClass> getClassesByNode() {
        return this.classesByNode;
    }

    public boolean isClassCreator(JClass jClass) {
        return this.createdClasses.contains(jClass);
    }

    public void setReferencedClasses(Collection<JClass> referencedClasses) {
        this.referencedClasses = referencedClasses;
    }

    public String getBindingFilePath() {
        return this.bindingFilePath;
    }

    public void setBindingFilePath(String bindingFilePath) {
        this.bindingFilePath = bindingFilePath;
    }
}

