/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.ejc;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.dhatim.edisax.util.EDIUtils;
import org.dhatim.edisax.util.IllegalNameException;
import org.dhatim.ejc.ClassModel;
import org.dhatim.ejc.ClassModelCompiler;
import org.dhatim.ejc.EJCLogFactory;
import org.dhatim.javabean.pojogen.JClass;
import org.dhatim.util.FreeMarkerTemplate;

public class BeanWriter {
    private static Log LOG = EJCLogFactory.getLog(ClassModelCompiler.class);
    private static boolean generateFromEDINR = false;
    private static FreeMarkerTemplate template = new FreeMarkerTemplate("templates/factoryClass.ftl.xml", BeanWriter.class);

    public static void setGenerateFromEDINR(boolean generateFromEDINR) {
        BeanWriter.generateFromEDINR = generateFromEDINR;
    }

    public static void writeBeansToFolder(ClassModel model, String folder, String bindingFile) throws IOException, IllegalNameException {
        folder = new File(folder).getCanonicalPath();
        for (JClass bean : model.getCreatedClasses()) {
            BeanWriter.writeToFile(folder, bean);
        }
        BeanWriter.writeFactoryClass(folder, model, bindingFile);
    }

    public static void writeBeans(ClassModel model, Writer writer) throws IOException, IllegalNameException {
        for (JClass bean : model.getCreatedClasses()) {
            bean.writeClass(writer);
            writer.write("\n\n");
            writer.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeFactoryClass(String folder, ClassModel model, String bindingFile) throws IllegalNameException, IOException {
        JClass rootClass = model.getRootBeanConfig().getBeanClass();
        String packageName = rootClass.getPackageName();
        String className = rootClass.getClassName();
        String classId = EDIUtils.encodeAttributeName(null, (String)rootClass.getClassName());
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put("package", packageName);
        configs.put("className", className);
        configs.put("classId", classId);
        configs.put("bindingFile", new File(bindingFile).getName());
        configs.put("generateFromEDINR", generateFromEDINR);
        FileOutputStream fileOutputStream = null;
        OutputStreamWriter writer = null;
        try {
            File file = new File(folder + "/" + packageName.replace(".", "/"));
            fileOutputStream = new FileOutputStream(file.getCanonicalPath() + "/" + className + "Factory.java");
            writer = new OutputStreamWriter(fileOutputStream);
            writer.write(template.apply(configs));
        }
        finally {
            if (writer != null) {
                writer.close();
            }
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeToFile(String folder, JClass bean) throws IOException {
        File file = new File(folder + "/" + bean.getPackageName().replace(".", "/"));
        if (!file.exists()) {
            file.mkdirs();
        }
        FileOutputStream fileOutputStream = null;
        OutputStreamWriter outputStreamWriter = null;
        try {
            fileOutputStream = new FileOutputStream(file.getCanonicalPath() + "/" + bean.getClassName() + ".java");
            outputStreamWriter = new OutputStreamWriter(fileOutputStream);
            bean.writeClass((Writer)outputStreamWriter);
        }
        finally {
            if (outputStreamWriter != null) {
                outputStreamWriter.close();
            }
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
    }
}

