/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.ejc;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.dhatim.config.Configurable;
import org.dhatim.edisax.model.internal.Component;
import org.dhatim.edisax.model.internal.ContainerNode;
import org.dhatim.edisax.model.internal.DelimiterType;
import org.dhatim.edisax.model.internal.Delimiters;
import org.dhatim.edisax.model.internal.Field;
import org.dhatim.edisax.model.internal.MappingNode;
import org.dhatim.edisax.model.internal.Segment;
import org.dhatim.edisax.model.internal.SegmentGroup;
import org.dhatim.edisax.model.internal.ValueNode;
import org.dhatim.edisax.util.EDIUtils;
import org.dhatim.ejc.BindingConfig;
import org.dhatim.javabean.DataDecoder;
import org.dhatim.javabean.DataEncoder;
import org.dhatim.javabean.decoders.DABigDecimalDecoder;
import org.dhatim.javabean.pojogen.JClass;
import org.dhatim.javabean.pojogen.JMethod;
import org.dhatim.javabean.pojogen.JNamedType;
import org.dhatim.javabean.pojogen.JType;
import org.dhatim.smooks.edi.EDIWritable;

class WriteMethod
extends JMethod {
    private JClass jClass;
    private MappingNode mappingNode;
    private boolean appendFlush = false;
    private boolean trunacate;
    private DelimiterType terminatingDelimiter;

    WriteMethod(JClass jClass, MappingNode mappingNode) {
        super("write");
        this.addParameter(new JType(Writer.class), "writer");
        this.addParameter(new JType(Delimiters.class), "delimiters");
        this.getExceptions().add(new JType(IOException.class));
        jClass.getImplementTypes().add(new JType(EDIWritable.class));
        jClass.getMethods().add(this);
        this.jClass = jClass;
        this.mappingNode = mappingNode;
        boolean bl = this.trunacate = mappingNode instanceof ContainerNode && ((ContainerNode)mappingNode).isTruncatable();
        if (this.trunacate) {
            jClass.getRawImports().add(new JType(StringWriter.class));
            jClass.getRawImports().add(new JType(List.class));
            jClass.getRawImports().add(new JType(ArrayList.class));
            jClass.getRawImports().add(new JType(EDIUtils.class));
            jClass.getRawImports().add(new JType(DelimiterType.class));
        }
    }

    public void writeObject(JNamedType property, DelimiterType delimiterType, BindingConfig bindingConfig, MappingNode mappingNode) {
        this.writeDelimiter(delimiterType);
        this.writeObject(property, bindingConfig, mappingNode);
    }

    public void writeObject(JNamedType property, BindingConfig bindingConfig, MappingNode mappingNode) {
        this.appendToBody("\n        if(" + property.getName() + " != null) {");
        if (mappingNode instanceof Segment && !((Segment)mappingNode).getFields().isEmpty() && (bindingConfig.getParent() == null || this.bodyLength() > 0)) {
            this.appendToBody("\n            nodeWriter.write(\"" + ((Segment)mappingNode).getSegcode() + "\");");
            this.appendToBody("\n            nodeWriter.write(delimiters.getField());");
        }
        this.appendToBody("\n            " + property.getName() + ".write(nodeWriter, delimiters);");
        if (this.trunacate) {
            this.appendToBody("\n            nodeTokens.add(nodeWriter.toString());");
            this.appendToBody("\n            ((StringWriter)nodeWriter).getBuffer().setLength(0);");
        }
        this.appendToBody("\n        }");
    }

    public void writeValue(JNamedType property, ValueNode modelNode, DelimiterType delimiterType) {
        this.writeDelimiter(delimiterType);
        this.writeValue(property, modelNode);
    }

    public void writeValue(JNamedType property, ValueNode modelNode) {
        this.appendToBody("\n        if(" + property.getName() + " != null) {");
        DataDecoder dataDecoder = modelNode.getDecoder();
        if (dataDecoder instanceof DataEncoder) {
            Properties configuration;
            String encoderName = property.getName() + "Encoder";
            Class<?> decoderClass = dataDecoder.getClass();
            this.jClass.getProperties().add(new JNamedType(new JType(decoderClass), encoderName));
            JMethod defaultConstructor = this.jClass.getDefaultConstructor();
            defaultConstructor.appendToBody("\n        " + encoderName + " = new " + decoderClass.getSimpleName() + "();");
            if (dataDecoder instanceof Configurable && (configuration = ((Configurable)dataDecoder).getConfiguration()) != null) {
                Set<Map.Entry<Object, Object>> encoderConfig = configuration.entrySet();
                String encoderPropertiesName = encoderName + "Properties";
                this.jClass.getRawImports().add(new JType(Properties.class));
                defaultConstructor.appendToBody("\n        Properties " + encoderPropertiesName + " = new Properties();");
                for (Map.Entry<Object, Object> entry : encoderConfig) {
                    defaultConstructor.appendToBody("\n        " + encoderPropertiesName + ".setProperty(\"" + entry.getKey() + "\", \"" + entry.getValue() + "\");");
                }
                defaultConstructor.appendToBody("\n        " + encoderName + ".setConfiguration(" + encoderPropertiesName + ");");
            }
            if (decoderClass == DABigDecimalDecoder.class) {
                this.appendToBody("\n            nodeWriter.write(delimiters.escape(" + encoderName + ".encode(" + property.getName() + ", delimiters)));");
            } else {
                this.appendToBody("\n            nodeWriter.write(delimiters.escape(" + encoderName + ".encode(" + property.getName() + ")));");
            }
        } else {
            this.appendToBody("\n            nodeWriter.write(delimiters.escape(" + property.getName() + ".toString()));");
        }
        if (this.trunacate) {
            this.appendToBody("\n            nodeTokens.add(nodeWriter.toString());");
            this.appendToBody("\n            ((StringWriter)nodeWriter).getBuffer().setLength(0);");
        }
        this.appendToBody("\n        }");
    }

    public void writeSegmentCollection(JNamedType property, SegmentGroup segmentGroup) {
        this.appendToBody("\n        if(" + property.getName() + " != null && !" + property.getName() + ".isEmpty()) {");
        this.appendToBody("\n            for(" + property.getType().getGenericType().getSimpleName() + " " + property.getName() + "Inst : " + property.getName() + ") {");
        if (segmentGroup instanceof Segment && !((Segment)segmentGroup).getFields().isEmpty()) {
            this.appendToBody("\n                nodeWriter.write(\"" + segmentGroup.getSegcode() + "\");");
            this.appendToBody("\n                nodeWriter.write(delimiters.getField());");
            if (this.trunacate) {
                this.appendToBody("\n                nodeTokens.add(nodeWriter.toString());");
                this.appendToBody("\n                ((StringWriter)nodeWriter).getBuffer().setLength(0);");
            }
        }
        this.appendToBody("\n                " + property.getName() + "Inst.write(nodeWriter, delimiters);");
        this.appendToBody("\n            }");
        this.appendToBody("\n        }");
    }

    public String getBody() {
        StringBuilder builder = new StringBuilder();
        if (this.trunacate) {
            builder.append("\n        Writer nodeWriter = new StringWriter();\n");
            builder.append("\n        List<String> nodeTokens = new ArrayList<String>();\n");
        } else {
            builder.append("\n        Writer nodeWriter = writer;\n");
        }
        builder.append(super.getBody());
        if (this.trunacate) {
            builder.append("\n        nodeTokens.add(nodeWriter.toString());");
            if (this.mappingNode instanceof Segment) {
                builder.append("\n        writer.write(EDIUtils.concatAndTruncate(nodeTokens, DelimiterType.FIELD, delimiters));");
            } else if (this.mappingNode instanceof Field) {
                builder.append("\n        writer.write(EDIUtils.concatAndTruncate(nodeTokens, DelimiterType.COMPONENT, delimiters));");
            } else if (this.mappingNode instanceof Component) {
                builder.append("\n        writer.write(EDIUtils.concatAndTruncate(nodeTokens, DelimiterType.SUBCOMPONENT, delimiters));");
            }
        }
        if (this.terminatingDelimiter != null) {
            this.writeDelimiter(this.terminatingDelimiter, "writer", builder);
        }
        if (this.appendFlush) {
            builder.append("\n        writer.flush();");
        }
        return builder.toString();
    }

    public void writeDelimiter(DelimiterType delimiterType) {
        this.writeDelimiter(delimiterType, "nodeWriter", this.getBodyBuilder());
    }

    private void writeDelimiter(DelimiterType delimiterType, String writerVariableName, StringBuilder builder) {
        if (this.bodyLength() == 0) {
            return;
        }
        switch (delimiterType) {
            case SEGMENT: {
                builder.append("\n        " + writerVariableName + ".write(delimiters.getSegmentDelimiter());");
                break;
            }
            case FIELD: {
                builder.append("\n        " + writerVariableName + ".write(delimiters.getField());");
                break;
            }
            case FIELD_REPEAT: {
                builder.append("\n        " + writerVariableName + ".write(delimiters.getFieldRepeat());");
                break;
            }
            case COMPONENT: {
                builder.append("\n        " + writerVariableName + ".write(delimiters.getComponent());");
                break;
            }
            case SUB_COMPONENT: {
                builder.append("\n        " + writerVariableName + ".write(delimiters.getSubComponent());");
                break;
            }
            case DECIMAL_SEPARATOR: {
                builder.append("\n        " + writerVariableName + ".write(delimiters.getDecimalSeparator());");
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported '" + DelimiterType.class.getName() + "' enum conversion.  Enum '" + delimiterType + "' not specified in switch statement.");
            }
        }
    }

    public void addFlush() {
        this.appendFlush = true;
    }

    public void addTerminatingDelimiter(DelimiterType delimiterType) {
        this.terminatingDelimiter = delimiterType;
    }
}

