/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.ejc;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.dhatim.edisax.model.EdifactModel;
import org.dhatim.edisax.model.internal.Description;
import org.dhatim.edisax.util.EDIUtils;
import org.dhatim.edisax.util.IllegalNameException;
import org.dhatim.ejc.ClassModel;
import org.dhatim.ejc.EJC;
import org.dhatim.ejc.EJCException;
import org.dhatim.io.FileUtils;
import org.dhatim.javabean.pojogen.JClass;
import org.dhatim.resource.URIResourceLocator;
import org.dhatim.util.CollectionsUtil;
import org.dhatim.util.FreeMarkerTemplate;
import org.xml.sax.SAXException;

public class EJCExecutor {
    private String ediMappingModel;
    private Set<String> messages;
    private File destDir;
    private String packageName;
    private static FreeMarkerTemplate messageBindingTemplate = new FreeMarkerTemplate("templates/interchange-message-bindingConfig.ftl.xml", EJCExecutor.class);
    private static FreeMarkerTemplate interchangeBindingTemplate = new FreeMarkerTemplate("templates/interchange-bindingConfig.ftl.xml", EJCExecutor.class);

    public void execute() throws EJCException, IOException, SAXException, IllegalNameException, ClassNotFoundException {
        this.assertMandatoryProperty(this.ediMappingModel, "ediMappingModel");
        this.assertMandatoryProperty(this.destDir, "destDir");
        this.assertMandatoryProperty(this.packageName, "packageName");
        if (this.destDir.exists() && !this.destDir.isDirectory()) {
            throw new EJCException("Specified EJC destination directory '" + this.destDir.getAbsoluteFile() + "' exists, but is not a directory.");
        }
        Properties interchangeProperties = EDIUtils.getInterchangeProperties((String)this.ediMappingModel);
        LinkedHashMap mappingModels = new LinkedHashMap();
        EDIUtils.loadMappingModels((String)this.ediMappingModel, mappingModels, (URI)URIResourceLocator.DEFAULT_BASE_URI);
        EdifactModel definitionsModel = (EdifactModel)mappingModels.get(EDIUtils.MODEL_SET_DEFINITIONS_DESCRIPTION_LOOKUP_NAME);
        String commonsPackageName = this.packageName + ".common";
        ClassModel definitionsClassModel = null;
        if (definitionsModel != null) {
            EJC ejc = new EJC();
            definitionsClassModel = ejc.compile(definitionsModel.getEdimap(), commonsPackageName, this.destDir.getAbsolutePath());
            this.deleteFile(commonsPackageName, "bindingconfig.xml");
            this.deleteFile(commonsPackageName, "edimappingconfig.xml");
        }
        ArrayList<MessageDefinition> messageSetDefinitions = new ArrayList<MessageDefinition>();
        Set modelSet = mappingModels.entrySet();
        StringBuilder rootClassesListFileBuilder = new StringBuilder();
        for (Map.Entry model : modelSet) {
            Description description = ((EdifactModel)model.getValue()).getDescription();
            if (description.equals((Object)EDIUtils.MODEL_SET_DEFINITIONS_DESCRIPTION_LOOKUP_NAME) || this.messages != null && !this.messages.contains(description.getName())) continue;
            EJC ejc = new EJC();
            ejc.include(commonsPackageName);
            ejc.addEDIMessageAnnotation(true);
            if (definitionsClassModel != null) {
                String messagePackageName = this.packageName + "." + description.getName();
                ClassModel classModel = ejc.compile(((EdifactModel)model.getValue()).getEdimap(), messagePackageName, this.destDir.getAbsolutePath(), definitionsClassModel.getClassesByNode());
                if (interchangeProperties == null) continue;
                MessageDefinition messageDef = new MessageDefinition(description.getName(), "/" + messagePackageName.replace('.', '/') + "/" + "bindingconfig.xml");
                messageSetDefinitions.add(messageDef);
                this.deleteFile(messagePackageName, "edimappingconfig.xml");
                this.deleteFile(messagePackageName, EDIUtils.encodeClassName((String)description.getName()) + "Factory.java");
                JClass beanClass = classModel.getRootBeanConfig().getBeanClass();
                rootClassesListFileBuilder.append(beanClass.getPackageName()).append(".").append(beanClass.getClassName()).append("\n");
                continue;
            }
            ejc.compile(((EdifactModel)model.getValue()).getEdimap(), this.packageName, this.destDir.getAbsolutePath());
        }
        FileUtils.writeFile((byte[])rootClassesListFileBuilder.toString().getBytes("UTF-8"), (File)new File(this.destDir, this.packageName.replace('.', '/') + "/ejc-classes.lst"));
        if (interchangeProperties != null && !messageSetDefinitions.isEmpty()) {
            this.applyTemplate("message-bindingconfig.xml", messageBindingTemplate, interchangeProperties, messageSetDefinitions);
            this.applyTemplate("interchange-bindingconfig.xml", interchangeBindingTemplate, interchangeProperties, messageSetDefinitions);
            this.generateFactoryClass(interchangeProperties);
        }
    }

    private void deleteFile(String packageName, String fileName) {
        File file = new File(this.destDir, packageName.replace('.', '/') + "/" + fileName);
        file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyTemplate(String outFile, FreeMarkerTemplate template, Properties interchangeProperties, List<MessageDefinition> messageSetDefinitions) throws IOException {
        File messageBindingConfigFile = new File(this.destDir, this.packageName.replace('.', '/') + "/" + outFile);
        FileWriter interchangeBindingConfigWriter = new FileWriter(messageBindingConfigFile);
        try {
            HashMap<String, Object> contextObj = new HashMap<String, Object>();
            contextObj.put("interchangeProperties", interchangeProperties);
            contextObj.put("messageSetDef", messageSetDefinitions);
            template.apply(contextObj, (Writer)interchangeBindingConfigWriter);
        }
        finally {
            try {
                interchangeBindingConfigWriter.flush();
            }
            finally {
                interchangeBindingConfigWriter.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateFactoryClass(Properties interchangeProperties) throws IOException {
        FreeMarkerTemplate factoryTemplate = new FreeMarkerTemplate("templates/" + interchangeProperties.getProperty("interchangeType") + "-interchange-factoryClass.ftl.xml", EJCExecutor.class);
        HashMap<String, String> contextObj = new HashMap<String, String>();
        String[] packageTokens = this.packageName.split("\\.");
        String messageSetName = packageTokens[packageTokens.length - 1].toUpperCase();
        contextObj.put("mappingModel", this.ediMappingModel);
        contextObj.put("package", this.packageName);
        contextObj.put("messageSetName", messageSetName);
        contextObj.put("bindingConfig", "/" + this.packageName.replace('.', '/') + "/interchange-bindingconfig.xml");
        File interchangeFactoryFile = new File(this.destDir, this.packageName.replace('.', '/') + "/" + messageSetName + "InterchangeFactory.java");
        FileWriter interchangeBindingConfigWriter = new FileWriter(interchangeFactoryFile);
        try {
            factoryTemplate.apply(contextObj, (Writer)interchangeBindingConfigWriter);
        }
        finally {
            try {
                interchangeBindingConfigWriter.flush();
            }
            finally {
                interchangeBindingConfigWriter.close();
            }
        }
    }

    public void setEdiMappingModel(String ediMappingModel) {
        this.ediMappingModel = ediMappingModel;
    }

    public void setMessages(String messages) {
        if (messages != null) {
            this.messages = CollectionsUtil.toSet((Object[])messages.split(","));
        }
    }

    public void setMessages(Set<String> messages) {
        this.messages = messages;
    }

    public void setDestDir(File destDir) {
        this.destDir = destDir;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    private void assertMandatoryProperty(Object obj, String name) {
        if (obj == null) {
            throw new EJCException("Mandatory EJC property '" + name + "' + not specified.");
        }
    }

    public static class MessageDefinition {
        private String messageName;
        private String bindingConfigPath;

        public MessageDefinition(String messageName, String bindingConfigPath) {
            this.messageName = messageName;
            this.bindingConfigPath = bindingConfigPath;
        }

        public String getMessageName() {
            return this.messageName;
        }

        public String getBindingConfigPath() {
            return this.bindingConfigPath;
        }
    }
}

