/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.rules.mvel;

import au.com.bytecode.opencsv.CSVReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dhatim.SmooksException;
import org.dhatim.cdr.SmooksConfigurationException;
import org.dhatim.container.ExecutionContext;
import org.dhatim.expression.ExpressionEvaluator;
import org.dhatim.expression.MVELExpressionEvaluator;
import org.dhatim.resource.URIResourceLocator;
import org.dhatim.rules.RuleEvalResult;
import org.dhatim.rules.RuleProvider;
import org.dhatim.rules.mvel.MVELRuleEvalResult;

public class MVELProvider
implements RuleProvider {
    private static Log logger = LogFactory.getLog(MVELProvider.class);
    private String name;
    private String src;
    private Map<String, ExpressionEvaluator> rules = new HashMap<String, ExpressionEvaluator>();

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getSrc() {
        return this.src;
    }

    @Override
    public void setSrc(String src) {
        this.src = src;
        this.loadRules();
    }

    @Override
    public RuleEvalResult evaluate(String ruleName, CharSequence selectedData, ExecutionContext context) throws SmooksException {
        ExpressionEvaluator evaluator = this.rules.get(ruleName);
        if (evaluator == null) {
            throw new SmooksException("Unknown rule name '" + ruleName + "' on MVEL RuleProvider '" + this.name + "'.");
        }
        try {
            return new MVELRuleEvalResult(evaluator.eval((Object)context.getBeanContext().getBeanMap()), ruleName, this.name, selectedData.toString());
        }
        catch (Throwable t) {
            return new MVELRuleEvalResult(t, ruleName, this.name, selectedData.toString());
        }
    }

    private void loadRules() {
        List entries;
        InputStream ruleStream;
        if (this.src == null) {
            throw new SmooksException("ruleFile not specified.");
        }
        try {
            ruleStream = new URIResourceLocator().getResource(this.src);
        }
        catch (IOException e) {
            throw new SmooksException("Failed to open rule file '" + this.src + "'.", (Throwable)e);
        }
        CSVReader csvLineReader = new CSVReader((Reader)new InputStreamReader(ruleStream));
        try {
            entries = csvLineReader.readAll();
        }
        catch (IOException e) {
            throw new SmooksConfigurationException("Error reading MVEL rule file (CSV format) '" + this.src + "'.", (Throwable)e);
        }
        finally {
            try {
                ruleStream.close();
            }
            catch (IOException e) {
                logger.debug((Object)("Error closing MVEL rule file '" + this.src + "'."), (Throwable)e);
            }
        }
        for (String[] ruleLine : entries) {
            if (ruleLine.length != 2 || ruleLine[0].trim().charAt(0) == '#') continue;
            String ruleName = ruleLine[0].trim();
            String ruleExpression = ruleLine[1];
            if (this.rules.containsKey(ruleName)) {
                logger.debug((Object)("Duplicate rule definition '" + ruleName + "' in MVEL rule file '" + ruleName + "'.  Ignoring duplicate."));
                continue;
            }
            this.rules.put(ruleName, new MVELExpressionEvaluator().setExpression(ruleExpression));
        }
    }
}

