/*
 * Decompiled with CFR 0.152.
 */
package org.dianahep.histogrammar;

import org.dianahep.histogrammar.Aggregation;
import org.dianahep.histogrammar.Branched;
import org.dianahep.histogrammar.BranchedList;
import org.dianahep.histogrammar.BranchedNil$;
import org.dianahep.histogrammar.Branching;
import org.dianahep.histogrammar.BranchingNil$;
import org.dianahep.histogrammar.Container;
import org.dianahep.histogrammar.Factory;
import org.dianahep.histogrammar.Factory$;
import org.dianahep.histogrammar.NoAggregation;
import org.dianahep.histogrammar.json.Json;
import org.dianahep.histogrammar.json.JsonArray;
import org.dianahep.histogrammar.json.JsonFormatException;
import org.dianahep.histogrammar.json.JsonNumber$;
import org.dianahep.histogrammar.json.JsonObject;
import org.dianahep.histogrammar.json.JsonString;
import org.dianahep.histogrammar.json.package$;
import org.dianahep.histogrammar.util.Compatible;
import org.dianahep.histogrammar.util.KeySetComparisons$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class Branch$
implements Factory {
    public static final Branch$ MODULE$;

    static {
        new Branch$();
    }

    @Override
    public String name() {
        return "Branch";
    }

    @Override
    public String help() {
        return "Accumulate aggregators of different types, indexed by i0 through i9. Every sub-aggregator is filled with every input datum.";
    }

    @Override
    public String detailedHelp() {
        return "This primitive provides an anonymous collection of aggregators of ''different types,'' usually for gluing together various statistics. For instance, if the following associates a sum of weights to every bin in a histogram,\n\n{{{Bin.ing(100, 0, 1, {d: Datum => d.x},\n  Sum.ing({d: Datum => d.weight}))}}}\n\nthe following would associate the sum of weights and the sum of squared weights to every bin:\n\n{{{Bin.ing(100, 0, 1, {d: Datum => d.x},\n  Branch.ing(Sum.ing({d: Datum => d.weight}),\n             Sum.ing({d: Datum => d.weight*d.weight})))}}}\n\nBranch is a basic building block for complex aggregators. The limitation to ten branches, indexed from i0 to i9, is a concession to type inference in statically typed languages. It is not a fundamental limit, but the type-metaprogramming becomes increasingly complex as branches are added. Error messages may be convoluted as the compiler presents internals of the type-metaprogramming in response to a user's simple mistake.\n\nTherefore, individual implementations may allow more than ten branches, but the Histogrammar standard only requires ten.\n\nTo collect an unlimited number of aggregators of the ''same type'' without naming them, use [[org.dianahep.histogrammar.Index]]. To collect aggregators of the ''same type'' with string-based labels, use [[org.dianahep.histogrammar.Label]]. To collect aggregators of ''different types'' with string-based labels, use [[org.dianahep.histogrammar.UntypedLabel]].";
    }

    public <C0 extends Container<C0> & NoAggregation> Branched<C0, BranchedNil$> ed(double entries, C0 i0) {
        return new Branched<C0, BranchedNil$>(entries, i0, BranchedNil$.MODULE$);
    }

    public <C0 extends Container<C0> & NoAggregation, C1 extends Container<C1> & NoAggregation> Branched<C0, Branched<C1, BranchedNil$>> ed(double entries, C0 i0, C1 i1) {
        return new Branched<C0, Branched<C1, BranchedNil$>>(entries, i0, new Branched<C1, BranchedNil$>(entries, i1, BranchedNil$.MODULE$));
    }

    public <C0 extends Container<C0> & NoAggregation, C1 extends Container<C1> & NoAggregation, C2 extends Container<C2> & NoAggregation> Branched<C0, Branched<C1, Branched<C2, BranchedNil$>>> ed(double entries, C0 i0, C1 i1, C2 i2) {
        return new Branched<C0, Branched<C1, Branched<C2, BranchedNil$>>>(entries, i0, new Branched<C1, Branched<C2, BranchedNil$>>(entries, i1, new Branched<C2, BranchedNil$>(entries, i2, BranchedNil$.MODULE$)));
    }

    public <C0 extends Container<C0> & NoAggregation, C1 extends Container<C1> & NoAggregation, C2 extends Container<C2> & NoAggregation, C3 extends Container<C3> & NoAggregation> Branched<C0, Branched<C1, Branched<C2, Branched<C3, BranchedNil$>>>> ed(double entries, C0 i0, C1 i1, C2 i2, C3 i3) {
        return new Branched<C0, Branched<C1, Branched<C2, Branched<C3, BranchedNil$>>>>(entries, i0, new Branched<C1, Branched<C2, Branched<C3, BranchedNil$>>>(entries, i1, new Branched<C2, Branched<C3, BranchedNil$>>(entries, i2, new Branched<C3, BranchedNil$>(entries, i3, BranchedNil$.MODULE$))));
    }

    public <C0 extends Container<C0> & NoAggregation, C1 extends Container<C1> & NoAggregation, C2 extends Container<C2> & NoAggregation, C3 extends Container<C3> & NoAggregation, C4 extends Container<C4> & NoAggregation> Branched<C0, Branched<C1, Branched<C2, Branched<C3, Branched<C4, BranchedNil$>>>>> ed(double entries, C0 i0, C1 i1, C2 i2, C3 i3, C4 i4) {
        return new Branched<C0, Branched<C1, Branched<C2, Branched<C3, Branched<C4, BranchedNil$>>>>>(entries, i0, new Branched<C1, Branched<C2, Branched<C3, Branched<C4, BranchedNil$>>>>(entries, i1, new Branched<C2, Branched<C3, Branched<C4, BranchedNil$>>>(entries, i2, new Branched<C3, Branched<C4, BranchedNil$>>(entries, i3, new Branched<C4, BranchedNil$>(entries, i4, BranchedNil$.MODULE$)))));
    }

    public <C0 extends Container<C0> & NoAggregation, C1 extends Container<C1> & NoAggregation, C2 extends Container<C2> & NoAggregation, C3 extends Container<C3> & NoAggregation, C4 extends Container<C4> & NoAggregation, C5 extends Container<C5> & NoAggregation> Branched<C0, Branched<C1, Branched<C2, Branched<C3, Branched<C4, Branched<C5, BranchedNil$>>>>>> ed(double entries, C0 i0, C1 i1, C2 i2, C3 i3, C4 i4, C5 i5) {
        return new Branched<C0, Branched<C1, Branched<C2, Branched<C3, Branched<C4, Branched<C5, BranchedNil$>>>>>>(entries, i0, new Branched<C1, Branched<C2, Branched<C3, Branched<C4, Branched<C5, BranchedNil$>>>>>(entries, i1, new Branched<C2, Branched<C3, Branched<C4, Branched<C5, BranchedNil$>>>>(entries, i2, new Branched<C3, Branched<C4, Branched<C5, BranchedNil$>>>(entries, i3, new Branched<C4, Branched<C5, BranchedNil$>>(entries, i4, new Branched<C5, BranchedNil$>(entries, i5, BranchedNil$.MODULE$))))));
    }

    public <C0 extends Container<C0> & NoAggregation, C1 extends Container<C1> & NoAggregation, C2 extends Container<C2> & NoAggregation, C3 extends Container<C3> & NoAggregation, C4 extends Container<C4> & NoAggregation, C5 extends Container<C5> & NoAggregation, C6 extends Container<C6> & NoAggregation> Branched<C0, Branched<C1, Branched<C2, Branched<C3, Branched<C4, Branched<C5, Branched<C6, BranchedNil$>>>>>>> ed(double entries, C0 i0, C1 i1, C2 i2, C3 i3, C4 i4, C5 i5, C6 i6) {
        return new Branched<C0, Branched<C1, Branched<C2, Branched<C3, Branched<C4, Branched<C5, Branched<C6, BranchedNil$>>>>>>>(entries, i0, new Branched<C1, Branched<C2, Branched<C3, Branched<C4, Branched<C5, Branched<C6, BranchedNil$>>>>>>(entries, i1, new Branched<C2, Branched<C3, Branched<C4, Branched<C5, Branched<C6, BranchedNil$>>>>>(entries, i2, new Branched<C3, Branched<C4, Branched<C5, Branched<C6, BranchedNil$>>>>(entries, i3, new Branched<C4, Branched<C5, Branched<C6, BranchedNil$>>>(entries, i4, new Branched<C5, Branched<C6, BranchedNil$>>(entries, i5, new Branched<C6, BranchedNil$>(entries, i6, BranchedNil$.MODULE$)))))));
    }

    public <C0 extends Container<C0> & NoAggregation, C1 extends Container<C1> & NoAggregation, C2 extends Container<C2> & NoAggregation, C3 extends Container<C3> & NoAggregation, C4 extends Container<C4> & NoAggregation, C5 extends Container<C5> & NoAggregation, C6 extends Container<C6> & NoAggregation, C7 extends Container<C7> & NoAggregation> Branched<C0, Branched<C1, Branched<C2, Branched<C3, Branched<C4, Branched<C5, Branched<C6, Branched<C7, BranchedNil$>>>>>>>> ed(double entries, C0 i0, C1 i1, C2 i2, C3 i3, C4 i4, C5 i5, C6 i6, C7 i7) {
        return new Branched<C0, Branched<C1, Branched<C2, Branched<C3, Branched<C4, Branched<C5, Branched<C6, Branched<C7, BranchedNil$>>>>>>>>(entries, i0, new Branched<C1, Branched<C2, Branched<C3, Branched<C4, Branched<C5, Branched<C6, Branched<C7, BranchedNil$>>>>>>>(entries, i1, new Branched<C2, Branched<C3, Branched<C4, Branched<C5, Branched<C6, Branched<C7, BranchedNil$>>>>>>(entries, i2, new Branched<C3, Branched<C4, Branched<C5, Branched<C6, Branched<C7, BranchedNil$>>>>>(entries, i3, new Branched<C4, Branched<C5, Branched<C6, Branched<C7, BranchedNil$>>>>(entries, i4, new Branched<C5, Branched<C6, Branched<C7, BranchedNil$>>>(entries, i5, new Branched<C6, Branched<C7, BranchedNil$>>(entries, i6, new Branched<C7, BranchedNil$>(entries, i7, BranchedNil$.MODULE$))))))));
    }

    public <C0 extends Container<C0> & NoAggregation, C1 extends Container<C1> & NoAggregation, C2 extends Container<C2> & NoAggregation, C3 extends Container<C3> & NoAggregation, C4 extends Container<C4> & NoAggregation, C5 extends Container<C5> & NoAggregation, C6 extends Container<C6> & NoAggregation, C7 extends Container<C7> & NoAggregation, C8 extends Container<C8> & NoAggregation> Branched<C0, Branched<C1, Branched<C2, Branched<C3, Branched<C4, Branched<C5, Branched<C6, Branched<C7, Branched<C8, BranchedNil$>>>>>>>>> ed(double entries, C0 i0, C1 i1, C2 i2, C3 i3, C4 i4, C5 i5, C6 i6, C7 i7, C8 i8) {
        return new Branched<C0, Branched<C1, Branched<C2, Branched<C3, Branched<C4, Branched<C5, Branched<C6, Branched<C7, Branched<C8, BranchedNil$>>>>>>>>>(entries, i0, new Branched<C1, Branched<C2, Branched<C3, Branched<C4, Branched<C5, Branched<C6, Branched<C7, Branched<C8, BranchedNil$>>>>>>>>(entries, i1, new Branched<C2, Branched<C3, Branched<C4, Branched<C5, Branched<C6, Branched<C7, Branched<C8, BranchedNil$>>>>>>>(entries, i2, new Branched<C3, Branched<C4, Branched<C5, Branched<C6, Branched<C7, Branched<C8, BranchedNil$>>>>>>(entries, i3, new Branched<C4, Branched<C5, Branched<C6, Branched<C7, Branched<C8, BranchedNil$>>>>>(entries, i4, new Branched<C5, Branched<C6, Branched<C7, Branched<C8, BranchedNil$>>>>(entries, i5, new Branched<C6, Branched<C7, Branched<C8, BranchedNil$>>>(entries, i6, new Branched<C7, Branched<C8, BranchedNil$>>(entries, i7, new Branched<C8, BranchedNil$>(entries, i8, BranchedNil$.MODULE$)))))))));
    }

    public <C0 extends Container<C0> & NoAggregation, C1 extends Container<C1> & NoAggregation, C2 extends Container<C2> & NoAggregation, C3 extends Container<C3> & NoAggregation, C4 extends Container<C4> & NoAggregation, C5 extends Container<C5> & NoAggregation, C6 extends Container<C6> & NoAggregation, C7 extends Container<C7> & NoAggregation, C8 extends Container<C8> & NoAggregation, C9 extends Container<C9> & NoAggregation> Branched<C0, Branched<C1, Branched<C2, Branched<C3, Branched<C4, Branched<C5, Branched<C6, Branched<C7, Branched<C8, Branched<C9, BranchedNil$>>>>>>>>>> ed(double entries, C0 i0, C1 i1, C2 i2, C3 i3, C4 i4, C5 i5, C6 i6, C7 i7, C8 i8, C9 i9) {
        return new Branched<C0, Branched<C1, Branched<C2, Branched<C3, Branched<C4, Branched<C5, Branched<C6, Branched<C7, Branched<C8, Branched<C9, BranchedNil$>>>>>>>>>>(entries, i0, new Branched<C1, Branched<C2, Branched<C3, Branched<C4, Branched<C5, Branched<C6, Branched<C7, Branched<C8, Branched<C9, BranchedNil$>>>>>>>>>(entries, i1, new Branched<C2, Branched<C3, Branched<C4, Branched<C5, Branched<C6, Branched<C7, Branched<C8, Branched<C9, BranchedNil$>>>>>>>>(entries, i2, new Branched<C3, Branched<C4, Branched<C5, Branched<C6, Branched<C7, Branched<C8, Branched<C9, BranchedNil$>>>>>>>(entries, i3, new Branched<C4, Branched<C5, Branched<C6, Branched<C7, Branched<C8, Branched<C9, BranchedNil$>>>>>>(entries, i4, new Branched<C5, Branched<C6, Branched<C7, Branched<C8, Branched<C9, BranchedNil$>>>>>(entries, i5, new Branched<C6, Branched<C7, Branched<C8, Branched<C9, BranchedNil$>>>>(entries, i6, new Branched<C7, Branched<C8, Branched<C9, BranchedNil$>>>(entries, i7, new Branched<C8, Branched<C9, BranchedNil$>>(entries, i8, new Branched<C9, BranchedNil$>(entries, i9, BranchedNil$.MODULE$))))))))));
    }

    public <C0 extends Container<C0> & Aggregation> Branching<C0, BranchingNil$> apply(C0 i0) {
        return new Branching<C0, BranchingNil$>(0.0, i0, BranchingNil$.MODULE$);
    }

    public <C0 extends Container<C0> & Aggregation, C1 extends Container<C1> & Aggregation> Branching<C0, Branching<C1, BranchingNil$>> apply(C0 i0, C1 i1, Compatible<C0, C1> e01) {
        return new Branching<C0, Branching<C1, BranchingNil$>>(0.0, i0, new Branching<C1, BranchingNil$>(0.0, i1, BranchingNil$.MODULE$));
    }

    public <C0 extends Container<C0> & Aggregation, C1 extends Container<C1> & Aggregation, C2 extends Container<C2> & Aggregation> Branching<C0, Branching<C1, Branching<C2, BranchingNil$>>> apply(C0 i0, C1 i1, C2 i2, Compatible<C0, C1> e01, Compatible<C0, C2> e02) {
        return new Branching<C0, Branching<C1, Branching<C2, BranchingNil$>>>(0.0, i0, new Branching<C1, Branching<C2, BranchingNil$>>(0.0, i1, new Branching<C2, BranchingNil$>(0.0, i2, BranchingNil$.MODULE$)));
    }

    public <C0 extends Container<C0> & Aggregation, C1 extends Container<C1> & Aggregation, C2 extends Container<C2> & Aggregation, C3 extends Container<C3> & Aggregation> Branching<C0, Branching<C1, Branching<C2, Branching<C3, BranchingNil$>>>> apply(C0 i0, C1 i1, C2 i2, C3 i3, Compatible<C0, C1> e01, Compatible<C0, C2> e02, Compatible<C0, C3> e03) {
        return new Branching<C0, Branching<C1, Branching<C2, Branching<C3, BranchingNil$>>>>(0.0, i0, new Branching<C1, Branching<C2, Branching<C3, BranchingNil$>>>(0.0, i1, new Branching<C2, Branching<C3, BranchingNil$>>(0.0, i2, new Branching<C3, BranchingNil$>(0.0, i3, BranchingNil$.MODULE$))));
    }

    public <C0 extends Container<C0> & Aggregation, C1 extends Container<C1> & Aggregation, C2 extends Container<C2> & Aggregation, C3 extends Container<C3> & Aggregation, C4 extends Container<C4> & Aggregation> Branching<C0, Branching<C1, Branching<C2, Branching<C3, Branching<C4, BranchingNil$>>>>> apply(C0 i0, C1 i1, C2 i2, C3 i3, C4 i4, Compatible<C0, C1> e01, Compatible<C0, C2> e02, Compatible<C0, C3> e03, Compatible<C0, C4> e04) {
        return new Branching<C0, Branching<C1, Branching<C2, Branching<C3, Branching<C4, BranchingNil$>>>>>(0.0, i0, new Branching<C1, Branching<C2, Branching<C3, Branching<C4, BranchingNil$>>>>(0.0, i1, new Branching<C2, Branching<C3, Branching<C4, BranchingNil$>>>(0.0, i2, new Branching<C3, Branching<C4, BranchingNil$>>(0.0, i3, new Branching<C4, BranchingNil$>(0.0, i4, BranchingNil$.MODULE$)))));
    }

    public <C0 extends Container<C0> & Aggregation, C1 extends Container<C1> & Aggregation, C2 extends Container<C2> & Aggregation, C3 extends Container<C3> & Aggregation, C4 extends Container<C4> & Aggregation, C5 extends Container<C5> & Aggregation> Branching<C0, Branching<C1, Branching<C2, Branching<C3, Branching<C4, Branching<C5, BranchingNil$>>>>>> apply(C0 i0, C1 i1, C2 i2, C3 i3, C4 i4, C5 i5, Compatible<C0, C1> e01, Compatible<C0, C2> e02, Compatible<C0, C3> e03, Compatible<C0, C4> e04, Compatible<C0, C5> e05) {
        return new Branching<C0, Branching<C1, Branching<C2, Branching<C3, Branching<C4, Branching<C5, BranchingNil$>>>>>>(0.0, i0, new Branching<C1, Branching<C2, Branching<C3, Branching<C4, Branching<C5, BranchingNil$>>>>>(0.0, i1, new Branching<C2, Branching<C3, Branching<C4, Branching<C5, BranchingNil$>>>>(0.0, i2, new Branching<C3, Branching<C4, Branching<C5, BranchingNil$>>>(0.0, i3, new Branching<C4, Branching<C5, BranchingNil$>>(0.0, i4, new Branching<C5, BranchingNil$>(0.0, i5, BranchingNil$.MODULE$))))));
    }

    public <C0 extends Container<C0> & Aggregation, C1 extends Container<C1> & Aggregation, C2 extends Container<C2> & Aggregation, C3 extends Container<C3> & Aggregation, C4 extends Container<C4> & Aggregation, C5 extends Container<C5> & Aggregation, C6 extends Container<C6> & Aggregation> Branching<C0, Branching<C1, Branching<C2, Branching<C3, Branching<C4, Branching<C5, Branching<C6, BranchingNil$>>>>>>> apply(C0 i0, C1 i1, C2 i2, C3 i3, C4 i4, C5 i5, C6 i6, Compatible<C0, C1> e01, Compatible<C0, C2> e02, Compatible<C0, C3> e03, Compatible<C0, C4> e04, Compatible<C0, C5> e05, Compatible<C0, C6> e06) {
        return new Branching<C0, Branching<C1, Branching<C2, Branching<C3, Branching<C4, Branching<C5, Branching<C6, BranchingNil$>>>>>>>(0.0, i0, new Branching<C1, Branching<C2, Branching<C3, Branching<C4, Branching<C5, Branching<C6, BranchingNil$>>>>>>(0.0, i1, new Branching<C2, Branching<C3, Branching<C4, Branching<C5, Branching<C6, BranchingNil$>>>>>(0.0, i2, new Branching<C3, Branching<C4, Branching<C5, Branching<C6, BranchingNil$>>>>(0.0, i3, new Branching<C4, Branching<C5, Branching<C6, BranchingNil$>>>(0.0, i4, new Branching<C5, Branching<C6, BranchingNil$>>(0.0, i5, new Branching<C6, BranchingNil$>(0.0, i6, BranchingNil$.MODULE$)))))));
    }

    public <C0 extends Container<C0> & Aggregation, C1 extends Container<C1> & Aggregation, C2 extends Container<C2> & Aggregation, C3 extends Container<C3> & Aggregation, C4 extends Container<C4> & Aggregation, C5 extends Container<C5> & Aggregation, C6 extends Container<C6> & Aggregation, C7 extends Container<C7> & Aggregation> Branching<C0, Branching<C1, Branching<C2, Branching<C3, Branching<C4, Branching<C5, Branching<C6, Branching<C7, BranchingNil$>>>>>>>> apply(C0 i0, C1 i1, C2 i2, C3 i3, C4 i4, C5 i5, C6 i6, C7 i7, Compatible<C0, C1> e01, Compatible<C0, C2> e02, Compatible<C0, C3> e03, Compatible<C0, C4> e04, Compatible<C0, C5> e05, Compatible<C0, C6> e06, Compatible<C0, C7> e07) {
        return new Branching<C0, Branching<C1, Branching<C2, Branching<C3, Branching<C4, Branching<C5, Branching<C6, Branching<C7, BranchingNil$>>>>>>>>(0.0, i0, new Branching<C1, Branching<C2, Branching<C3, Branching<C4, Branching<C5, Branching<C6, Branching<C7, BranchingNil$>>>>>>>(0.0, i1, new Branching<C2, Branching<C3, Branching<C4, Branching<C5, Branching<C6, Branching<C7, BranchingNil$>>>>>>(0.0, i2, new Branching<C3, Branching<C4, Branching<C5, Branching<C6, Branching<C7, BranchingNil$>>>>>(0.0, i3, new Branching<C4, Branching<C5, Branching<C6, Branching<C7, BranchingNil$>>>>(0.0, i4, new Branching<C5, Branching<C6, Branching<C7, BranchingNil$>>>(0.0, i5, new Branching<C6, Branching<C7, BranchingNil$>>(0.0, i6, new Branching<C7, BranchingNil$>(0.0, i7, BranchingNil$.MODULE$))))))));
    }

    public <C0 extends Container<C0> & Aggregation, C1 extends Container<C1> & Aggregation, C2 extends Container<C2> & Aggregation, C3 extends Container<C3> & Aggregation, C4 extends Container<C4> & Aggregation, C5 extends Container<C5> & Aggregation, C6 extends Container<C6> & Aggregation, C7 extends Container<C7> & Aggregation, C8 extends Container<C8> & Aggregation> Branching<C0, Branching<C1, Branching<C2, Branching<C3, Branching<C4, Branching<C5, Branching<C6, Branching<C7, Branching<C8, BranchingNil$>>>>>>>>> apply(C0 i0, C1 i1, C2 i2, C3 i3, C4 i4, C5 i5, C6 i6, C7 i7, C8 i8, Compatible<C0, C1> e01, Compatible<C0, C2> e02, Compatible<C0, C3> e03, Compatible<C0, C4> e04, Compatible<C0, C5> e05, Compatible<C0, C6> e06, Compatible<C0, C7> e07, Compatible<C0, C8> e08) {
        return new Branching<C0, Branching<C1, Branching<C2, Branching<C3, Branching<C4, Branching<C5, Branching<C6, Branching<C7, Branching<C8, BranchingNil$>>>>>>>>>(0.0, i0, new Branching<C1, Branching<C2, Branching<C3, Branching<C4, Branching<C5, Branching<C6, Branching<C7, Branching<C8, BranchingNil$>>>>>>>>(0.0, i1, new Branching<C2, Branching<C3, Branching<C4, Branching<C5, Branching<C6, Branching<C7, Branching<C8, BranchingNil$>>>>>>>(0.0, i2, new Branching<C3, Branching<C4, Branching<C5, Branching<C6, Branching<C7, Branching<C8, BranchingNil$>>>>>>(0.0, i3, new Branching<C4, Branching<C5, Branching<C6, Branching<C7, Branching<C8, BranchingNil$>>>>>(0.0, i4, new Branching<C5, Branching<C6, Branching<C7, Branching<C8, BranchingNil$>>>>(0.0, i5, new Branching<C6, Branching<C7, Branching<C8, BranchingNil$>>>(0.0, i6, new Branching<C7, Branching<C8, BranchingNil$>>(0.0, i7, new Branching<C8, BranchingNil$>(0.0, i8, BranchingNil$.MODULE$)))))))));
    }

    public <C0 extends Container<C0> & Aggregation, C1 extends Container<C1> & Aggregation, C2 extends Container<C2> & Aggregation, C3 extends Container<C3> & Aggregation, C4 extends Container<C4> & Aggregation, C5 extends Container<C5> & Aggregation, C6 extends Container<C6> & Aggregation, C7 extends Container<C7> & Aggregation, C8 extends Container<C8> & Aggregation, C9 extends Container<C9> & Aggregation> Branching<C0, Branching<C1, Branching<C2, Branching<C3, Branching<C4, Branching<C5, Branching<C6, Branching<C7, Branching<C8, Branching<C9, BranchingNil$>>>>>>>>>> apply(C0 i0, C1 i1, C2 i2, C3 i3, C4 i4, C5 i5, C6 i6, C7 i7, C8 i8, C9 i9, Compatible<C0, C1> e01, Compatible<C0, C2> e02, Compatible<C0, C3> e03, Compatible<C0, C4> e04, Compatible<C0, C5> e05, Compatible<C0, C6> e06, Compatible<C0, C7> e07, Compatible<C0, C8> e08, Compatible<C0, C9> e09) {
        return new Branching<C0, Branching<C1, Branching<C2, Branching<C3, Branching<C4, Branching<C5, Branching<C6, Branching<C7, Branching<C8, Branching<C9, BranchingNil$>>>>>>>>>>(0.0, i0, new Branching<C1, Branching<C2, Branching<C3, Branching<C4, Branching<C5, Branching<C6, Branching<C7, Branching<C8, Branching<C9, BranchingNil$>>>>>>>>>(0.0, i1, new Branching<C2, Branching<C3, Branching<C4, Branching<C5, Branching<C6, Branching<C7, Branching<C8, Branching<C9, BranchingNil$>>>>>>>>(0.0, i2, new Branching<C3, Branching<C4, Branching<C5, Branching<C6, Branching<C7, Branching<C8, Branching<C9, BranchingNil$>>>>>>>(0.0, i3, new Branching<C4, Branching<C5, Branching<C6, Branching<C7, Branching<C8, Branching<C9, BranchingNil$>>>>>>(0.0, i4, new Branching<C5, Branching<C6, Branching<C7, Branching<C8, Branching<C9, BranchingNil$>>>>>(0.0, i5, new Branching<C6, Branching<C7, Branching<C8, Branching<C9, BranchingNil$>>>>(0.0, i6, new Branching<C7, Branching<C8, Branching<C9, BranchingNil$>>>(0.0, i7, new Branching<C8, Branching<C9, BranchingNil$>>(0.0, i8, new Branching<C9, BranchingNil$>(0.0, i9, BranchingNil$.MODULE$))))))))));
    }

    public <C0 extends Container<C0> & Aggregation> Branching<C0, BranchingNil$> ing(C0 i0) {
        return this.apply(i0);
    }

    public <C0 extends Container<C0> & Aggregation, C1 extends Container<C1> & Aggregation> Branching<C0, Branching<C1, BranchingNil$>> ing(C0 i0, C1 i1, Compatible<C0, C1> e01) {
        return this.apply(i0, i1, e01);
    }

    public <C0 extends Container<C0> & Aggregation, C1 extends Container<C1> & Aggregation, C2 extends Container<C2> & Aggregation> Branching<C0, Branching<C1, Branching<C2, BranchingNil$>>> ing(C0 i0, C1 i1, C2 i2, Compatible<C0, C1> e01, Compatible<C0, C2> e02) {
        return this.apply(i0, i1, i2, e01, e02);
    }

    public <C0 extends Container<C0> & Aggregation, C1 extends Container<C1> & Aggregation, C2 extends Container<C2> & Aggregation, C3 extends Container<C3> & Aggregation> Branching<C0, Branching<C1, Branching<C2, Branching<C3, BranchingNil$>>>> ing(C0 i0, C1 i1, C2 i2, C3 i3, Compatible<C0, C1> e01, Compatible<C0, C2> e02, Compatible<C0, C3> e03) {
        return this.apply(i0, i1, i2, i3, e01, e02, e03);
    }

    public <C0 extends Container<C0> & Aggregation, C1 extends Container<C1> & Aggregation, C2 extends Container<C2> & Aggregation, C3 extends Container<C3> & Aggregation, C4 extends Container<C4> & Aggregation> Branching<C0, Branching<C1, Branching<C2, Branching<C3, Branching<C4, BranchingNil$>>>>> ing(C0 i0, C1 i1, C2 i2, C3 i3, C4 i4, Compatible<C0, C1> e01, Compatible<C0, C2> e02, Compatible<C0, C3> e03, Compatible<C0, C4> e04) {
        return this.apply(i0, i1, i2, i3, i4, e01, e02, e03, e04);
    }

    public <C0 extends Container<C0> & Aggregation, C1 extends Container<C1> & Aggregation, C2 extends Container<C2> & Aggregation, C3 extends Container<C3> & Aggregation, C4 extends Container<C4> & Aggregation, C5 extends Container<C5> & Aggregation> Branching<C0, Branching<C1, Branching<C2, Branching<C3, Branching<C4, Branching<C5, BranchingNil$>>>>>> ing(C0 i0, C1 i1, C2 i2, C3 i3, C4 i4, C5 i5, Compatible<C0, C1> e01, Compatible<C0, C2> e02, Compatible<C0, C3> e03, Compatible<C0, C4> e04, Compatible<C0, C5> e05) {
        return this.apply(i0, i1, i2, i3, i4, i5, e01, e02, e03, e04, e05);
    }

    public <C0 extends Container<C0> & Aggregation, C1 extends Container<C1> & Aggregation, C2 extends Container<C2> & Aggregation, C3 extends Container<C3> & Aggregation, C4 extends Container<C4> & Aggregation, C5 extends Container<C5> & Aggregation, C6 extends Container<C6> & Aggregation> Branching<C0, Branching<C1, Branching<C2, Branching<C3, Branching<C4, Branching<C5, Branching<C6, BranchingNil$>>>>>>> ing(C0 i0, C1 i1, C2 i2, C3 i3, C4 i4, C5 i5, C6 i6, Compatible<C0, C1> e01, Compatible<C0, C2> e02, Compatible<C0, C3> e03, Compatible<C0, C4> e04, Compatible<C0, C5> e05, Compatible<C0, C6> e06) {
        return this.apply(i0, i1, i2, i3, i4, i5, i6, e01, e02, e03, e04, e05, e06);
    }

    public <C0 extends Container<C0> & Aggregation, C1 extends Container<C1> & Aggregation, C2 extends Container<C2> & Aggregation, C3 extends Container<C3> & Aggregation, C4 extends Container<C4> & Aggregation, C5 extends Container<C5> & Aggregation, C6 extends Container<C6> & Aggregation, C7 extends Container<C7> & Aggregation> Branching<C0, Branching<C1, Branching<C2, Branching<C3, Branching<C4, Branching<C5, Branching<C6, Branching<C7, BranchingNil$>>>>>>>> ing(C0 i0, C1 i1, C2 i2, C3 i3, C4 i4, C5 i5, C6 i6, C7 i7, Compatible<C0, C1> e01, Compatible<C0, C2> e02, Compatible<C0, C3> e03, Compatible<C0, C4> e04, Compatible<C0, C5> e05, Compatible<C0, C6> e06, Compatible<C0, C7> e07) {
        return this.apply(i0, i1, i2, i3, i4, i5, i6, i7, e01, e02, e03, e04, e05, e06, e07);
    }

    public <C0 extends Container<C0> & Aggregation, C1 extends Container<C1> & Aggregation, C2 extends Container<C2> & Aggregation, C3 extends Container<C3> & Aggregation, C4 extends Container<C4> & Aggregation, C5 extends Container<C5> & Aggregation, C6 extends Container<C6> & Aggregation, C7 extends Container<C7> & Aggregation, C8 extends Container<C8> & Aggregation> Branching<C0, Branching<C1, Branching<C2, Branching<C3, Branching<C4, Branching<C5, Branching<C6, Branching<C7, Branching<C8, BranchingNil$>>>>>>>>> ing(C0 i0, C1 i1, C2 i2, C3 i3, C4 i4, C5 i5, C6 i6, C7 i7, C8 i8, Compatible<C0, C1> e01, Compatible<C0, C2> e02, Compatible<C0, C3> e03, Compatible<C0, C4> e04, Compatible<C0, C5> e05, Compatible<C0, C6> e06, Compatible<C0, C7> e07, Compatible<C0, C8> e08) {
        return this.apply(i0, i1, i2, i3, i4, i5, i6, i7, i8, e01, e02, e03, e04, e05, e06, e07, e08);
    }

    public <C0 extends Container<C0> & Aggregation, C1 extends Container<C1> & Aggregation, C2 extends Container<C2> & Aggregation, C3 extends Container<C3> & Aggregation, C4 extends Container<C4> & Aggregation, C5 extends Container<C5> & Aggregation, C6 extends Container<C6> & Aggregation, C7 extends Container<C7> & Aggregation, C8 extends Container<C8> & Aggregation, C9 extends Container<C9> & Aggregation> Branching<C0, Branching<C1, Branching<C2, Branching<C3, Branching<C4, Branching<C5, Branching<C6, Branching<C7, Branching<C8, Branching<C9, BranchingNil$>>>>>>>>>> ing(C0 i0, C1 i1, C2 i2, C3 i3, C4 i4, C5 i5, C6 i6, C7 i7, C8 i8, C9 i9, Compatible<C0, C1> e01, Compatible<C0, C2> e02, Compatible<C0, C3> e03, Compatible<C0, C4> e04, Compatible<C0, C5> e05, Compatible<C0, C6> e06, Compatible<C0, C7> e07, Compatible<C0, C8> e08, Compatible<C0, C9> e09) {
        return this.apply(i0, i1, i2, i3, i4, i5, i6, i7, i8, i9, e01, e02, e03, e04, e05, e06, e07, e08, e09);
    }

    @Override
    public Container<?> fromJsonFragment(Json json, Option<String> nameFromParent) {
        JsonObject jsonObject;
        Seq<Tuple2<JsonString, Json>> pairs;
        Json json2 = json;
        if (json2 instanceof JsonObject && KeySetComparisons$.MODULE$.KeySetFromSet(package$.MODULE$.HasKeySet(pairs = (jsonObject = (JsonObject)json2).pairs()).keySet()).has(KeySetComparisons$.MODULE$.KeySetFromSet((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"entries", "data"})))))) {
            JsonArray jsonArray;
            Seq<Json> values2;
            double x;
            double d;
            Map get = pairs.toMap(Predef$.MODULE$.$conforms());
            Json json3 = (Json)get.apply((Object)package$.MODULE$.stringToJson("entries"));
            Option<Object> option = JsonNumber$.MODULE$.unapply(json3);
            if (option.isEmpty()) {
                throw new JsonFormatException(json3, new StringBuilder().append((Object)this.name()).append((Object)".entries").toString());
            }
            double entries = d = (x = BoxesRunTime.unboxToDouble((Object)option.get()));
            Json json4 = (Json)get.apply((Object)package$.MODULE$.stringToJson("data"));
            if (json4 instanceof JsonArray && (values2 = (jsonArray = (JsonArray)json4).elements()).size() >= 1) {
                Container container;
                ObjectRef out = ObjectRef.create((Object)BranchedNil$.MODULE$);
                ((TraversableOnce)values2.zipWithIndex(Seq$.MODULE$.canBuildFrom())).toList().reverse().foreach((Function1)new Serializable(entries, out){
                    public static final long serialVersionUID = 0L;
                    private final double entries$1;
                    private final ObjectRef out$1;

                    public final void apply(Tuple2<Json, Object> x0$21) {
                        JsonObject jsonObject;
                        Seq<Tuple2<JsonString, Json>> typedata;
                        Json json;
                        Tuple2<Json, Object> tuple2 = x0$21;
                        if (tuple2 != null && (json = (Json)tuple2._1()) instanceof JsonObject && KeySetComparisons$.MODULE$.KeySetFromSet(package$.MODULE$.HasKeySet(typedata = (jsonObject = (JsonObject)json).pairs()).keySet()).has(KeySetComparisons$.MODULE$.KeySetFromSet((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"type", "data"})))))) {
                            Map subget = typedata.toMap(Predef$.MODULE$.$conforms());
                            Tuple2 tuple22 = new Tuple2(subget.apply((Object)package$.MODULE$.stringToJson("type")), subget.apply((Object)package$.MODULE$.stringToJson("data")));
                            if (tuple22 != null) {
                                Json json2 = (Json)tuple22._1();
                                Json sub = (Json)tuple22._2();
                                if (json2 instanceof JsonString) {
                                    JsonString jsonString = (JsonString)json2;
                                    String factory = jsonString.value();
                                    Container<?> item = Factory$.MODULE$.apply(factory).fromJsonFragment(sub, (Option<String>)None$.MODULE$);
                                    this.out$1.elem = new Branched<Container<?>, BranchedList>(this.entries$1, item, (BranchedList)this.out$1.elem);
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                                    return;
                                }
                            }
                            if (tuple22 != null) {
                                Json x = (Json)tuple22._2();
                                throw new JsonFormatException(x, new StringBuilder().append((Object)Branch$.MODULE$.name()).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{".data"})).s((Seq)Nil$.MODULE$)).toString());
                            }
                            throw new MatchError((Object)tuple22);
                        }
                        if (tuple2 != null) {
                            Json x = (Json)tuple2._1();
                            int i = tuple2._2$mcI$sp();
                            throw new JsonFormatException(x, new StringBuilder().append((Object)Branch$.MODULE$.name()).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{".data ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)}))).toString());
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.entries$1 = entries$1;
                        this.out$1 = out$1;
                    }
                });
                Container container2 = container = (Container)((Object)((BranchedList)out.elem));
                return container2;
            }
            throw new JsonFormatException(json4, new StringBuilder().append((Object)this.name()).append((Object)".data").toString());
        }
        throw new JsonFormatException(json, this.name());
    }

    private Branch$() {
        MODULE$ = this;
    }
}

