/*
 * Decompiled with CFR 0.152.
 */
package org.didcommx.peerdid;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.didcommx.peerdid.VerificationMaterial;
import org.didcommx.peerdid.VerificationMethodType;
import org.didcommx.peerdid.VerificationMethodTypeAgreement;
import org.didcommx.peerdid.VerificationMethodTypeAuthentication;
import org.didcommx.peerdid.core.Numalgo2Prefix;
import org.didcommx.peerdid.core.PeerDIDUtils;
import org.didcommx.peerdid.core.ValidationKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u001c\u0010\u0000\u001a\u00060\u0001j\u0002`\u00022\u0010\u0010\u0003\u001a\f\u0012\u0004\u0012\u00020\u00050\u0004j\u0002`\u0006\u001aJ\u0010\u0007\u001a\u00060\u0001j\u0002`\u00022\u0016\u0010\b\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\n0\u0004j\u0002`\u000b0\t2\u0016\u0010\f\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00050\u0004j\u0002`\u00060\t2\u000e\u0010\r\u001a\n\u0018\u00010\u0001j\u0004\u0018\u0001`\u000e\u001a\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0001\u00a8\u0006\u0012"}, d2={"createPeerDIDNumalgo0", "", "Lorg/didcommx/peerdid/PeerDID;", "inceptionKey", "Lorg/didcommx/peerdid/VerificationMaterial;", "Lorg/didcommx/peerdid/VerificationMethodTypeAuthentication;", "Lorg/didcommx/peerdid/VerificationMaterialAuthentication;", "createPeerDIDNumalgo2", "encryptionKeys", "", "Lorg/didcommx/peerdid/VerificationMethodTypeAgreement;", "Lorg/didcommx/peerdid/VerificationMaterialAgreement;", "signingKeys", "service", "Lorg/didcommx/peerdid/JSON;", "isPeerDID", "", "peerDID", "peerdid"})
@JvmName(name="PeerDIDCreator")
public final class PeerDIDCreator {
    public static final boolean isPeerDID(@NotNull String peerDID) {
        Intrinsics.checkNotNullParameter(peerDID, "peerDID");
        String string = "^did:peer:(([0](z)([1-9a-km-zA-HJ-NP-Z]{46,47}))|(2((.[AEVID](z)([1-9a-km-zA-HJ-NP-Z]{46,47}))+(.(S)[0-9a-zA-Z=]*)?)))$";
        boolean bl = false;
        Regex regex = new Regex(string);
        return regex.matches(peerDID);
    }

    @NotNull
    public static final String createPeerDIDNumalgo0(@NotNull VerificationMaterial<VerificationMethodTypeAuthentication> inceptionKey) {
        Intrinsics.checkNotNullParameter(inceptionKey, "inceptionKey");
        ValidationKt.validateAuthenticationMaterialType(inceptionKey);
        return Intrinsics.stringPlus("did:peer:0", PeerDIDUtils.createMultibaseEncnumbasis(inceptionKey));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String createPeerDIDNumalgo2(@NotNull List<VerificationMaterial<VerificationMethodTypeAgreement>> encryptionKeys, @NotNull List<VerificationMaterial<VerificationMethodTypeAuthentication>> signingKeys, @Nullable String service) {
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        String string;
        String it;
        Collection collection;
        Iterable $this$mapTo$iv$iv2;
        Iterable $this$map$iv2;
        VerificationMaterial it2;
        Object element$iv2;
        Intrinsics.checkNotNullParameter(encryptionKeys, "encryptionKeys");
        Intrinsics.checkNotNullParameter(signingKeys, "signingKeys");
        Iterable $this$forEach$iv = encryptionKeys;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            it2 = (VerificationMaterial)element$iv2;
            boolean bl = false;
            ValidationKt.validateAgreementMaterialType(it2);
        }
        $this$forEach$iv = signingKeys;
        $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            it2 = (VerificationMaterial)element$iv2;
            boolean bl = false;
            ValidationKt.validateAuthenticationMaterialType(it2);
        }
        Iterable $i$f$forEach2 = encryptionKeys;
        boolean $i$f$map = false;
        element$iv2 = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            VerificationMaterial verificationMaterial = (VerificationMaterial)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            string = PeerDIDUtils.createMultibaseEncnumbasis((VerificationMaterial<? extends VerificationMethodType>)((Object)it));
            collection.add(string);
        }
        $this$map$iv2 = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv2 = $this$map$iv2;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            string = "" + '.' + Numalgo2Prefix.KEY_AGREEMENT.getPrefix() + it;
            collection.add(string);
        }
        String encodedEncryptionKeysStr = CollectionsKt.joinToString$default((List)destination$iv$iv, "", null, null, 0, null, null, 62, null);
        Iterable $i$f$map2 = signingKeys;
        boolean $i$f$map3 = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it3;
            VerificationMaterial bl = (VerificationMaterial)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            string = PeerDIDUtils.createMultibaseEncnumbasis((VerificationMaterial<? extends VerificationMethodType>)it3);
            collection.add(string);
        }
        $this$map$iv = (List)destination$iv$iv2;
        $i$f$map3 = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String it3 = (String)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            string = "" + '.' + Numalgo2Prefix.AUTHENTICATION.getPrefix() + it3;
            collection.add(string);
        }
        String encodedSigningKeysStr = CollectionsKt.joinToString$default((List)destination$iv$iv2, "", null, null, 0, null, null, 62, null);
        CharSequence charSequence = service;
        boolean bl = false;
        boolean bl3 = false;
        String encodedService = charSequence == null || charSequence.length() == 0 ? "" : PeerDIDUtils.encodeService(service);
        return "did:peer:2" + encodedEncryptionKeysStr + encodedSigningKeysStr + encodedService;
    }
}

