/*
 * Decompiled with CFR 0.152.
 */
package org.didcommx.peerdid.core;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.didcommx.peerdid.DIDCommServicePeerDID;
import org.didcommx.peerdid.DIDDocPeerDID;
import org.didcommx.peerdid.OtherService;
import org.didcommx.peerdid.PublicKeyField;
import org.didcommx.peerdid.Service;
import org.didcommx.peerdid.VerificationMaterial;
import org.didcommx.peerdid.VerificationMaterialFormatPeerDID;
import org.didcommx.peerdid.VerificationMethodPeerDID;
import org.didcommx.peerdid.VerificationMethodType;
import org.didcommx.peerdid.VerificationMethodTypeAgreement;
import org.didcommx.peerdid.VerificationMethodTypeAuthentication;
import org.didcommx.peerdid.core.UtilsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u001a\u0010\u0010\n\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tH\u0000\u001a\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0000\"\u001a\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00050\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"verTypeToField", "", "Lorg/didcommx/peerdid/VerificationMethodType;", "Lorg/didcommx/peerdid/PublicKeyField;", "verTypeToFormat", "Lorg/didcommx/peerdid/VerificationMaterialFormatPeerDID;", "didDocFromJson", "Lorg/didcommx/peerdid/DIDDocPeerDID;", "jsonObject", "Lcom/google/gson/JsonObject;", "getVerMethodType", "serviceFromJson", "Lorg/didcommx/peerdid/Service;", "verificationMethodFromJson", "Lorg/didcommx/peerdid/VerificationMethodPeerDID;", "peerdid"})
public final class DIDDocHelperKt {
    @NotNull
    private static final Map<VerificationMethodType, PublicKeyField> verTypeToField;
    @NotNull
    private static final Map<VerificationMethodType, VerificationMaterialFormatPeerDID> verTypeToFormat;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final DIDDocPeerDID didDocFromJson(@NotNull JsonObject jsonObject) {
        List list;
        JsonObject jsonObject2;
        Iterable $this$mapTo$iv$iv;
        List list2;
        Object object;
        Collection collection;
        Collection destination$iv$iv;
        Iterable iterable;
        JsonElement jsonElement;
        List list3;
        String string;
        Intrinsics.checkNotNullParameter(jsonObject, "jsonObject");
        JsonElement jsonElement2 = jsonObject.get("id");
        String string2 = string = jsonElement2 == null ? null : jsonElement2.getAsString();
        if (string == null) {
            throw new IllegalArgumentException("No 'id' field");
        }
        String did = string;
        JsonElement jsonElement3 = jsonObject.get("authentication");
        if (jsonElement3 == null) {
            list3 = null;
        } else {
            jsonElement = jsonElement3.getAsJsonArray();
            if (jsonElement == null) {
                list3 = null;
            } else {
                void $this$mapTo$iv$iv2;
                void $this$map$iv;
                iterable = (Iterable)((Object)jsonElement);
                boolean $i$f$map = false;
                void var8_10 = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void it;
                    JsonElement jsonElement4 = (JsonElement)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    JsonObject jsonObject3 = it.getAsJsonObject();
                    Intrinsics.checkNotNullExpressionValue(jsonObject3, "it.asJsonObject");
                    object = DIDDocHelperKt.verificationMethodFromJson(jsonObject3);
                    collection.add(object);
                }
                list3 = (List)destination$iv$iv;
            }
        }
        jsonElement2 = list3;
        Object authentication = jsonElement2 == null ? CollectionsKt.emptyList() : jsonElement2;
        jsonElement = jsonObject.get("keyAgreement");
        if (jsonElement == null) {
            list2 = null;
        } else {
            iterable = jsonElement.getAsJsonArray();
            if (iterable == null) {
                list2 = null;
            } else {
                void $this$map$iv;
                Iterable $i$f$map = iterable;
                boolean $i$f$map2 = false;
                destination$iv$iv = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    JsonElement bl = (JsonElement)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl2 = false;
                    jsonObject2 = it.getAsJsonObject();
                    Intrinsics.checkNotNullExpressionValue(jsonObject2, "it.asJsonObject");
                    object = DIDDocHelperKt.verificationMethodFromJson(jsonObject2);
                    collection.add(object);
                }
                list2 = (List)destination$iv$iv2;
            }
        }
        jsonElement3 = list2;
        Object keyAgreement = jsonElement3 == null ? CollectionsKt.emptyList() : jsonElement3;
        jsonElement = jsonObject.get("service");
        if (jsonElement == null) {
            list = null;
        } else {
            iterable = jsonElement.getAsJsonArray();
            if (iterable == null) {
                list = null;
            } else {
                Iterable $this$map$iv = iterable;
                boolean $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    JsonElement it = (JsonElement)item$iv$iv;
                    collection = destination$iv$iv3;
                    boolean bl = false;
                    jsonObject2 = it.getAsJsonObject();
                    Intrinsics.checkNotNullExpressionValue(jsonObject2, "it.asJsonObject");
                    object = DIDDocHelperKt.serviceFromJson(jsonObject2);
                    collection.add(object);
                }
                list = (List)destination$iv$iv3;
            }
        }
        List service = list;
        return new DIDDocPeerDID(did, (List<VerificationMethodPeerDID>)authentication, (List<VerificationMethodPeerDID>)keyAgreement, service);
    }

    @NotNull
    public static final VerificationMethodPeerDID verificationMethodFromJson(@NotNull JsonObject jsonObject) {
        Object object;
        JsonElement jsonElement;
        String string;
        Intrinsics.checkNotNullParameter(jsonObject, "jsonObject");
        Object object2 = jsonObject.get("id");
        String string2 = string = object2 == null ? null : ((JsonElement)object2).getAsString();
        if (string == null) {
            throw new IllegalArgumentException(Intrinsics.stringPlus("No 'id' field in method ", jsonObject.getAsString()));
        }
        String id = string;
        JsonElement jsonElement2 = jsonObject.get("controller");
        Object object3 = object2 = jsonElement2 == null ? null : jsonElement2.getAsString();
        if (object2 == null) {
            throw new IllegalArgumentException(Intrinsics.stringPlus("No 'controller' field in method ", jsonObject.getAsString()));
        }
        Object controller = object2;
        VerificationMethodType verMaterialType = DIDDocHelperKt.getVerMethodType(jsonObject);
        PublicKeyField field = MapsKt.getValue(verTypeToField, verMaterialType);
        VerificationMaterialFormatPeerDID format = MapsKt.getValue(verTypeToFormat, verMaterialType);
        if (verMaterialType instanceof VerificationMethodTypeAgreement.JSON_WEB_KEY_2020 || verMaterialType instanceof VerificationMethodTypeAuthentication.JSON_WEB_KEY_2020) {
            JsonObject jsonObject2;
            String string3;
            JsonElement jsonElement3 = jsonObject.get(field.getValue());
            String string4 = jsonElement3 == null ? null : (string3 = (jsonObject2 = jsonElement3.getAsJsonObject()) == null ? null : jsonObject2.toString());
            if (string3 == null) {
                throw new IllegalArgumentException(Intrinsics.stringPlus("No 'field' field in method ", jsonObject.getAsString()));
            }
            JsonElement jwkJson = jsonElement = string3;
            object = UtilsKt.fromJsonToMap((String)((Object)jwkJson));
        } else {
            String string5;
            jsonElement = jsonObject.get(field.getValue());
            String string6 = string5 = jsonElement == null ? null : jsonElement.getAsString();
            if (string5 == null) {
                throw new IllegalArgumentException(Intrinsics.stringPlus("No 'field' field in method ", jsonObject.getAsString()));
            }
            object = string5;
        }
        String value = object;
        return new VerificationMethodPeerDID(id, (String)controller, new VerificationMaterial<VerificationMethodType>(format, value, verMaterialType));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Service serviceFromJson(@NotNull JsonObject jsonObject) {
        List list;
        String string;
        Iterable<String> iterable;
        Iterable<String> destination$iv$iv;
        JsonElement jsonElement;
        List list2;
        String string2;
        Intrinsics.checkNotNullParameter(jsonObject, "jsonObject");
        String string3 = jsonObject.toString();
        Intrinsics.checkNotNullExpressionValue(string3, "jsonObject.toString()");
        Map<String, Object> serviceMap = UtilsKt.fromJsonToMap(string3);
        Object object = jsonObject.get("id");
        String string4 = string2 = object == null ? null : ((JsonElement)object).getAsString();
        if (string2 == null) {
            throw new IllegalArgumentException(Intrinsics.stringPlus("No 'id' field in service ", jsonObject.getAsString()));
        }
        String id = string2;
        JsonElement jsonElement2 = jsonObject.get("type");
        Object object2 = object = jsonElement2 == null ? null : jsonElement2.getAsString();
        if (object == null) {
            throw new IllegalArgumentException(Intrinsics.stringPlus("No 'type' field in service ", jsonObject.getAsString()));
        }
        Object type = object;
        if (!Intrinsics.areEqual(type, "DIDCommMessaging")) {
            return new OtherService(serviceMap);
        }
        jsonElement2 = jsonObject.get("serviceEndpoint");
        String endpoint = jsonElement2 == null ? null : jsonElement2.getAsString();
        JsonElement jsonElement3 = jsonObject.get("routingKeys");
        if (jsonElement3 == null) {
            list2 = null;
        } else {
            jsonElement = jsonElement3.getAsJsonArray();
            if (jsonElement == null) {
                list2 = null;
            } else {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = (Iterable)((Object)jsonElement);
                boolean $i$f$map = false;
                Iterable iterable2 = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    JsonElement jsonElement4 = (JsonElement)item$iv$iv;
                    iterable = destination$iv$iv;
                    boolean bl = false;
                    string = it.getAsString();
                    iterable.add(string);
                }
                list2 = (List)destination$iv$iv;
            }
        }
        List routingKeys = list2;
        jsonElement = jsonObject.get("accept");
        if (jsonElement == null) {
            list = null;
        } else {
            JsonArray jsonArray = jsonElement.getAsJsonArray();
            if (jsonArray == null) {
                list = null;
            } else {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = jsonArray;
                boolean $i$f$map = false;
                destination$iv$iv = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    JsonElement bl = (JsonElement)item$iv$iv;
                    iterable = destination$iv$iv2;
                    boolean bl2 = false;
                    string = it.getAsString();
                    iterable.add((String)string);
                }
                list = (List)destination$iv$iv2;
            }
        }
        List accept = list;
        return new DIDCommServicePeerDID(id, (String)type, endpoint, routingKeys, accept);
    }

    private static final VerificationMethodType getVerMethodType(JsonObject jsonObject) {
        VerificationMethodType verificationMethodType;
        String string;
        JsonElement jsonElement = jsonObject.get("type");
        String string2 = string = jsonElement == null ? null : jsonElement.getAsString();
        if (string == null) {
            throw new IllegalArgumentException(Intrinsics.stringPlus("No 'type' field in method ", jsonObject.getAsString()));
        }
        String type = string;
        if (Intrinsics.areEqual(string = type, VerificationMethodTypeAgreement.X25519_KEY_AGREEMENT_KEY_2019.INSTANCE.getValue())) {
            verificationMethodType = VerificationMethodTypeAgreement.X25519_KEY_AGREEMENT_KEY_2019.INSTANCE;
        } else if (Intrinsics.areEqual(string, VerificationMethodTypeAgreement.X25519_KEY_AGREEMENT_KEY_2020.INSTANCE.getValue())) {
            verificationMethodType = VerificationMethodTypeAgreement.X25519_KEY_AGREEMENT_KEY_2020.INSTANCE;
        } else if (Intrinsics.areEqual(string, VerificationMethodTypeAuthentication.ED25519_VERIFICATION_KEY_2018.INSTANCE.getValue())) {
            verificationMethodType = VerificationMethodTypeAuthentication.ED25519_VERIFICATION_KEY_2018.INSTANCE;
        } else if (Intrinsics.areEqual(string, VerificationMethodTypeAuthentication.ED25519_VERIFICATION_KEY_2020.INSTANCE.getValue())) {
            verificationMethodType = VerificationMethodTypeAuthentication.ED25519_VERIFICATION_KEY_2020.INSTANCE;
        } else if (Intrinsics.areEqual(string, VerificationMethodTypeAuthentication.JSON_WEB_KEY_2020.INSTANCE.getValue())) {
            JsonObject jsonObject2;
            Object object = jsonObject.get(PublicKeyField.JWK.getValue());
            JsonObject jsonObject3 = jsonObject2 = object == null ? null : ((JsonElement)object).getAsJsonObject();
            if (jsonObject2 == null) {
                throw new IllegalArgumentException(Intrinsics.stringPlus("No 'field' field in method ", jsonObject.getAsString()));
            }
            JsonObject v = jsonObject2;
            JsonElement jsonElement2 = v.get("crv");
            Object object2 = object = jsonElement2 == null ? null : jsonElement2.getAsString();
            if (object == null) {
                throw new IllegalArgumentException(Intrinsics.stringPlus("No 'crv' field in method ", jsonObject.getAsString()));
            }
            Object crv = object;
            verificationMethodType = Intrinsics.areEqual(crv, "X25519") ? (VerificationMethodType)VerificationMethodTypeAgreement.JSON_WEB_KEY_2020.INSTANCE : (VerificationMethodType)VerificationMethodTypeAuthentication.JSON_WEB_KEY_2020.INSTANCE;
        } else {
            throw new IllegalArgumentException(Intrinsics.stringPlus("Unknown verification method type ", type));
        }
        return verificationMethodType;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to(VerificationMethodTypeAgreement.X25519_KEY_AGREEMENT_KEY_2019.INSTANCE, PublicKeyField.BASE58), TuplesKt.to(VerificationMethodTypeAgreement.X25519_KEY_AGREEMENT_KEY_2020.INSTANCE, PublicKeyField.MULTIBASE), TuplesKt.to(VerificationMethodTypeAgreement.JSON_WEB_KEY_2020.INSTANCE, PublicKeyField.JWK), TuplesKt.to(VerificationMethodTypeAuthentication.ED25519_VERIFICATION_KEY_2018.INSTANCE, PublicKeyField.BASE58), TuplesKt.to(VerificationMethodTypeAuthentication.ED25519_VERIFICATION_KEY_2020.INSTANCE, PublicKeyField.MULTIBASE), TuplesKt.to(VerificationMethodTypeAuthentication.JSON_WEB_KEY_2020.INSTANCE, PublicKeyField.JWK)};
        verTypeToField = MapsKt.mapOf(pairArray);
        pairArray = new Pair[]{TuplesKt.to(VerificationMethodTypeAgreement.X25519_KEY_AGREEMENT_KEY_2019.INSTANCE, VerificationMaterialFormatPeerDID.BASE58), TuplesKt.to(VerificationMethodTypeAgreement.X25519_KEY_AGREEMENT_KEY_2020.INSTANCE, VerificationMaterialFormatPeerDID.MULTIBASE), TuplesKt.to(VerificationMethodTypeAgreement.JSON_WEB_KEY_2020.INSTANCE, VerificationMaterialFormatPeerDID.JWK), TuplesKt.to(VerificationMethodTypeAuthentication.ED25519_VERIFICATION_KEY_2018.INSTANCE, VerificationMaterialFormatPeerDID.BASE58), TuplesKt.to(VerificationMethodTypeAuthentication.ED25519_VERIFICATION_KEY_2020.INSTANCE, VerificationMaterialFormatPeerDID.MULTIBASE), TuplesKt.to(VerificationMethodTypeAuthentication.JSON_WEB_KEY_2020.INSTANCE, VerificationMaterialFormatPeerDID.JWK)};
        verTypeToFormat = MapsKt.mapOf(pairArray);
    }
}

