/*
 * Decompiled with CFR 0.152.
 */
package org.didcommx.peerdid.core;

import com.google.gson.JsonSyntaxException;
import io.ipfs.multibase.binary.Base64;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.didcommx.peerdid.OtherService;
import org.didcommx.peerdid.Service;
import org.didcommx.peerdid.VerificationMaterial;
import org.didcommx.peerdid.VerificationMaterialFormatPeerDID;
import org.didcommx.peerdid.VerificationMethodPeerDID;
import org.didcommx.peerdid.VerificationMethodType;
import org.didcommx.peerdid.VerificationMethodTypeAgreement;
import org.didcommx.peerdid.VerificationMethodTypeAuthentication;
import org.didcommx.peerdid.core.Codec;
import org.didcommx.peerdid.core.DecodedEncumbasis;
import org.didcommx.peerdid.core.JWK_OKPKt;
import org.didcommx.peerdid.core.MultibaseKt;
import org.didcommx.peerdid.core.MulticodecKt;
import org.didcommx.peerdid.core.Numalgo2Prefix;
import org.didcommx.peerdid.core.UtilsKt;
import org.didcommx.peerdid.core.ValidationKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0018\u0010\u0003\u001a\u00020\u00022\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005H\u0000\u001a\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a(\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r2\n\u0010\u000f\u001a\u00060\u0002j\u0002`\u00102\n\u0010\u0011\u001a\u00060\u0002j\u0002`\u0012H\u0000\u001a\u0014\u0010\u0013\u001a\u00020\u00022\n\u0010\u0014\u001a\u00060\u0002j\u0002`\u0010H\u0000\u001a\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\bH\u0000\"\u001a\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"ServicePrefix", "", "", "createMultibaseEncnumbasis", "key", "Lorg/didcommx/peerdid/VerificationMaterial;", "Lorg/didcommx/peerdid/VerificationMethodType;", "decodeMultibaseEncnumbasis", "Lorg/didcommx/peerdid/core/DecodedEncumbasis;", "multibase", "format", "Lorg/didcommx/peerdid/VerificationMaterialFormatPeerDID;", "decodeService", "", "Lorg/didcommx/peerdid/Service;", "encodedService", "Lorg/didcommx/peerdid/JSON;", "peerDID", "Lorg/didcommx/peerdid/PeerDID;", "encodeService", "service", "getVerificationMethod", "Lorg/didcommx/peerdid/VerificationMethodPeerDID;", "did", "decodedEncumbasis", "peerdid"})
@JvmName(name="PeerDIDUtils")
public final class PeerDIDUtils {
    @NotNull
    private static final Map<String, String> ServicePrefix;

    @NotNull
    public static final String encodeService(@NotNull String service) {
        String serviceToEncode;
        Intrinsics.checkNotNullParameter(service, "service");
        ValidationKt.validateJson(service);
        CharSequence charSequence = service;
        Object object = new Regex("[\n\t\\s]*");
        String string = "";
        boolean bl = false;
        string = serviceToEncode = StringsKt.replace$default(StringsKt.replace$default(StringsKt.replace$default(StringsKt.replace$default(StringsKt.replace$default(((Regex)object).replace(charSequence, string), "type", MapsKt.getValue(ServicePrefix, "type"), false, 4, null), "serviceEndpoint", MapsKt.getValue(ServicePrefix, "serviceEndpoint"), false, 4, null), "DIDCommMessaging", MapsKt.getValue(ServicePrefix, "DIDCommMessaging"), false, 4, null), "routingKeys", MapsKt.getValue(ServicePrefix, "routingKeys"), false, 4, null), "accept", MapsKt.getValue(ServicePrefix, "accept"), false, 4, null);
        Charset charset = Charsets.UTF_8;
        boolean bl2 = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue(byArray, "(this as java.lang.String).getBytes(charset)");
        object = Base64.encodeBase64URLSafe(byArray);
        Intrinsics.checkNotNullExpressionValue(object, "encodeBase64URLSafe(serviceToEncode.toByteArray())");
        String encodedService = StringsKt.decodeToString((byte[])object);
        return "" + '.' + Numalgo2Prefix.SERVICE.getPrefix() + encodedService;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final List<Service> decodeService(@NotNull String encodedService, @NotNull String peerDID) {
        void $this$mapIndexedTo$iv$iv;
        Iterable<Map<String, Object>> iterable;
        List<Map<String, Object>> list;
        Intrinsics.checkNotNullParameter(encodedService, "encodedService");
        Intrinsics.checkNotNullParameter(peerDID, "peerDID");
        CharSequence charSequence = encodedService;
        boolean bl = false;
        if (charSequence.length() == 0) {
            return null;
        }
        byte[] byArray = Base64.decodeBase64(encodedService);
        Intrinsics.checkNotNullExpressionValue(byArray, "decodeBase64(encodedService)");
        String decodedService = StringsKt.decodeToString(byArray);
        try {
            list = UtilsKt.fromJsonToList(decodedService);
        }
        catch (JsonSyntaxException e) {
            try {
                iterable = CollectionsKt.listOf(UtilsKt.fromJsonToMap(decodedService));
            }
            catch (JsonSyntaxException e2) {
                throw new IllegalArgumentException(Intrinsics.stringPlus("Invalid JSON ", decodedService));
            }
            list = iterable;
        }
        List<Map<String, Object>> serviceMapList = list;
        Iterable $this$mapIndexed$iv = serviceMapList;
        boolean $i$f$mapIndexed = false;
        iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            Object it;
            boolean bl2;
            void serviceNumber;
            void serviceMap;
            int n = index$iv$iv++;
            boolean bl3 = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Map map = (Map)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl4 = false;
            if (!serviceMap.containsKey(MapsKt.getValue(ServicePrefix, "type"))) {
                throw new IllegalArgumentException("service doesn't contain a type");
            }
            Object serviceType = StringsKt.replace$default(MapsKt.getValue(serviceMap, MapsKt.getValue(ServicePrefix, "type")).toString(), MapsKt.getValue(ServicePrefix, "DIDCommMessaging"), "DIDCommMessaging", false, 4, null);
            Object object = new Pair[2];
            StringBuilder stringBuilder = new StringBuilder().append(peerDID).append('#');
            Object object2 = serviceType;
            boolean bl5 = false;
            if (object2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string = object2.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string, "(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
            object[0] = TuplesKt.to("id", stringBuilder.append(string).append('-').append((int)serviceNumber).toString());
            object[1] = TuplesKt.to("type", serviceType);
            Map<String, Pair[]> service = MapsKt.mutableMapOf(object);
            object = serviceMap.get(MapsKt.getValue(ServicePrefix, "serviceEndpoint"));
            if (object != null) {
                object2 = object;
                bl5 = false;
                bl2 = false;
                it = object2;
                boolean bl6 = false;
                service.put("serviceEndpoint", (Pair[])it);
            }
            object = serviceMap.get(MapsKt.getValue(ServicePrefix, "routingKeys"));
            if (object != null) {
                object2 = object;
                bl5 = false;
                bl2 = false;
                it = object2;
                boolean bl7 = false;
                service.put("routingKeys", (Pair[])it);
            }
            object = serviceMap.get(MapsKt.getValue(ServicePrefix, "accept"));
            if (object != null) {
                object2 = object;
                bl5 = false;
                bl2 = false;
                it = object2;
                boolean bl8 = false;
                service.put("accept", (Pair[])it);
            }
            OtherService otherService = new OtherService(service);
            collection.add(otherService);
        }
        return CollectionsKt.toList((List)destination$iv$iv);
    }

    @NotNull
    public static final String createMultibaseEncnumbasis(@NotNull VerificationMaterial<? extends VerificationMethodType> key) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter(key, "key");
        Object object = key.getFormat();
        int n = WhenMappings.$EnumSwitchMapping$0[object.ordinal()];
        switch (n) {
            case 1: {
                byArray = MultibaseKt.fromBase58(key.getValue().toString());
                break;
            }
            case 2: {
                byArray = MultibaseKt.fromBase58Multibase(key.getValue().toString()).getSecond();
                break;
            }
            case 3: {
                byArray = JWK_OKPKt.fromJwk(key);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        byte[] decodedKey = byArray;
        ValidationKt.validateRawKeyLength(decodedKey);
        object = MultibaseKt.toBase58Multibase(MulticodecKt.toMulticodec(decodedKey, key.getType()));
        Intrinsics.checkNotNullExpressionValue(object, "toBase58Multibase(toMulticodec(decodedKey, key.type))");
        return object;
    }

    @NotNull
    public static final DecodedEncumbasis decodeMultibaseEncnumbasis(@NotNull String multibase, @NotNull VerificationMaterialFormatPeerDID format) {
        VerificationMaterial<VerificationMethodType> verificationMaterial;
        Intrinsics.checkNotNullParameter(multibase, "multibase");
        Intrinsics.checkNotNullParameter((Object)format, "format");
        Pair<String, byte[]> pair = MultibaseKt.fromBase58Multibase(multibase);
        String encnumbasis = pair.component1();
        byte[] decodedEncnumbasis = pair.component2();
        Pair<Codec, byte[]> pair2 = MulticodecKt.fromMulticodec(decodedEncnumbasis);
        Codec codec = pair2.component1();
        byte[] decodedEncnumbasisWithoutPrefix = pair2.component2();
        ValidationKt.validateRawKeyLength(decodedEncnumbasisWithoutPrefix);
        VerificationMaterialFormatPeerDID verificationMaterialFormatPeerDID = format;
        int n = WhenMappings.$EnumSwitchMapping$0[verificationMaterialFormatPeerDID.ordinal()];
        block0 : switch (n) {
            case 1: {
                Map<String, String> map;
                VerificationMethodType verificationMethodType;
                Codec codec2 = codec;
                int n2 = WhenMappings.$EnumSwitchMapping$1[codec2.ordinal()];
                switch (n2) {
                    case 1: {
                        verificationMethodType = VerificationMethodTypeAgreement.X25519_KEY_AGREEMENT_KEY_2019.INSTANCE;
                        map = MultibaseKt.toBase58(decodedEncnumbasisWithoutPrefix);
                        Intrinsics.checkNotNullExpressionValue(map, "toBase58(decodedEncnumbasisWithoutPrefix)");
                        verificationMaterial = new VerificationMaterial<VerificationMethodType>(format, map, verificationMethodType);
                        break block0;
                    }
                    case 2: {
                        verificationMethodType = VerificationMethodTypeAuthentication.ED25519_VERIFICATION_KEY_2018.INSTANCE;
                        map = MultibaseKt.toBase58(decodedEncnumbasisWithoutPrefix);
                        Intrinsics.checkNotNullExpressionValue(map, "toBase58(decodedEncnumbasisWithoutPrefix)");
                        verificationMaterial = new VerificationMaterial<VerificationMethodType>(format, map, verificationMethodType);
                        break block0;
                    }
                }
                throw new NoWhenBranchMatchedException();
            }
            case 2: {
                Map<String, String> map;
                VerificationMethodType verificationMethodType;
                Codec codec2 = codec;
                int n2 = WhenMappings.$EnumSwitchMapping$1[codec2.ordinal()];
                switch (n2) {
                    case 1: {
                        verificationMethodType = VerificationMethodTypeAgreement.X25519_KEY_AGREEMENT_KEY_2020.INSTANCE;
                        map = MultibaseKt.toBase58Multibase(decodedEncnumbasisWithoutPrefix);
                        Intrinsics.checkNotNullExpressionValue(map, "toBase58Multibase(decodedEncnumbasisWithoutPrefix)");
                        verificationMaterial = new VerificationMaterial<VerificationMethodType>(format, map, verificationMethodType);
                        break block0;
                    }
                    case 2: {
                        verificationMethodType = VerificationMethodTypeAuthentication.ED25519_VERIFICATION_KEY_2020.INSTANCE;
                        map = MultibaseKt.toBase58Multibase(decodedEncnumbasisWithoutPrefix);
                        Intrinsics.checkNotNullExpressionValue(map, "toBase58Multibase(decodedEncnumbasisWithoutPrefix)");
                        verificationMaterial = new VerificationMaterial<VerificationMethodType>(format, map, verificationMethodType);
                        break block0;
                    }
                }
                throw new NoWhenBranchMatchedException();
            }
            case 3: {
                Map<String, String> map;
                VerificationMethodType verificationMethodType;
                Codec codec2 = codec;
                int n2 = WhenMappings.$EnumSwitchMapping$1[codec2.ordinal()];
                switch (n2) {
                    case 1: {
                        verificationMethodType = VerificationMethodTypeAgreement.JSON_WEB_KEY_2020.INSTANCE;
                        map = JWK_OKPKt.toJwk(decodedEncnumbasisWithoutPrefix, VerificationMethodTypeAgreement.JSON_WEB_KEY_2020.INSTANCE);
                        verificationMaterial = new VerificationMaterial<VerificationMethodType>(format, map, verificationMethodType);
                        break block0;
                    }
                    case 2: {
                        verificationMethodType = VerificationMethodTypeAuthentication.JSON_WEB_KEY_2020.INSTANCE;
                        map = JWK_OKPKt.toJwk(decodedEncnumbasisWithoutPrefix, VerificationMethodTypeAuthentication.JSON_WEB_KEY_2020.INSTANCE);
                        verificationMaterial = new VerificationMaterial<VerificationMethodType>(format, map, verificationMethodType);
                        break block0;
                    }
                }
                throw new NoWhenBranchMatchedException();
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        VerificationMaterial<VerificationMethodType> verMaterial = verificationMaterial;
        return new DecodedEncumbasis(encnumbasis, verMaterial);
    }

    @NotNull
    public static final VerificationMethodPeerDID getVerificationMethod(@NotNull String did, @NotNull DecodedEncumbasis decodedEncumbasis) {
        Intrinsics.checkNotNullParameter(did, "did");
        Intrinsics.checkNotNullParameter(decodedEncumbasis, "decodedEncumbasis");
        return new VerificationMethodPeerDID(did + '#' + decodedEncumbasis.getEncnumbasis(), did, decodedEncumbasis.getVerMaterial());
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to("type", "t"), TuplesKt.to("serviceEndpoint", "s"), TuplesKt.to("DIDCommMessaging", "dm"), TuplesKt.to("routingKeys", "r"), TuplesKt.to("accept", "a")};
        ServicePrefix = MapsKt.mapOf(pairArray);
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[VerificationMaterialFormatPeerDID.values().length];
            nArray[VerificationMaterialFormatPeerDID.BASE58.ordinal()] = 1;
            nArray[VerificationMaterialFormatPeerDID.MULTIBASE.ordinal()] = 2;
            nArray[VerificationMaterialFormatPeerDID.JWK.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Codec.values().length];
            nArray[Codec.X25519.ordinal()] = 1;
            nArray[Codec.ED25519.ordinal()] = 2;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

