/*
 * Decompiled with CFR 0.152.
 */
package org.didcommx.peerdid.core;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.didcommx.peerdid.VerificationMaterial;
import org.didcommx.peerdid.VerificationMethodType;
import org.didcommx.peerdid.VerificationMethodTypeAgreement;
import org.didcommx.peerdid.VerificationMethodTypeAuthentication;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003H\u0000\u001a\u0018\u0010\u0005\u001a\u00020\u00012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003H\u0000\u001a\u0010\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\bH\u0000\u001a\u0010\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a8\u0006\f"}, d2={"validateAgreementMaterialType", "", "verificationMaterial", "Lorg/didcommx/peerdid/VerificationMaterial;", "Lorg/didcommx/peerdid/VerificationMethodType;", "validateAuthenticationMaterialType", "validateJson", "value", "", "validateRawKeyLength", "key", "", "peerdid"})
public final class ValidationKt {
    public static final void validateAuthenticationMaterialType(@NotNull VerificationMaterial<? extends VerificationMethodType> verificationMaterial) {
        Intrinsics.checkNotNullParameter(verificationMaterial, "verificationMaterial");
        if (!(verificationMaterial.getType() instanceof VerificationMethodTypeAuthentication)) {
            throw new IllegalArgumentException("Invalid verification material type: " + verificationMaterial.getType() + " instead of VerificationMaterialAuthentication");
        }
    }

    public static final void validateAgreementMaterialType(@NotNull VerificationMaterial<? extends VerificationMethodType> verificationMaterial) {
        Intrinsics.checkNotNullParameter(verificationMaterial, "verificationMaterial");
        if (!(verificationMaterial.getType() instanceof VerificationMethodTypeAgreement)) {
            throw new IllegalArgumentException("Invalid verification material type: " + verificationMaterial.getType() + " instead of VerificationMaterialAgreement");
        }
    }

    public static final void validateJson(@NotNull String value) {
        Intrinsics.checkNotNullParameter(value, "value");
        Gson gson = new Gson();
        try {
            gson.fromJson(value, Object.class);
        }
        catch (JsonSyntaxException ex) {
            throw new IllegalArgumentException(Intrinsics.stringPlus("Invalid JSON ", value), ex);
        }
        if (!StringsKt.contains$default((CharSequence)value, "{", false, 2, null)) {
            throw new IllegalArgumentException(Intrinsics.stringPlus("Invalid JSON ", value));
        }
    }

    public static final void validateRawKeyLength(@NotNull byte[] key) {
        Intrinsics.checkNotNullParameter(key, "key");
        if (key.length != 32) {
            throw new IllegalArgumentException(Intrinsics.stringPlus("Invalid key ", key));
        }
    }
}

