/*
 * Decompiled with CFR 0.152.
 */
package org.didcommx.peerdid;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.didcommx.peerdid.DIDDocPeerDID;
import org.didcommx.peerdid.MalformedPeerDIDException;
import org.didcommx.peerdid.PeerDIDCreator;
import org.didcommx.peerdid.Service;
import org.didcommx.peerdid.VerificationMaterialFormatPeerDID;
import org.didcommx.peerdid.core.DecodedEncumbasis;
import org.didcommx.peerdid.core.Numalgo2Prefix;
import org.didcommx.peerdid.core.PeerDIDUtils;
import org.didcommx.peerdid.core.ValidationKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001c\u0010\u0000\u001a\u00020\u00012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u001c\u0010\u0007\u001a\u00020\u00012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0018\u0010\u000b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a \u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u001c\u0010\u0010\u001a\u00020\u00032\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0011"}, d2={"buildDIDDocNumalgo0", "Lorg/didcommx/peerdid/DIDDocPeerDID;", "peerDID", "", "Lorg/didcommx/peerdid/PeerDID;", "format", "Lorg/didcommx/peerdid/VerificationMaterialFormatPeerDID;", "buildDIDDocNumalgo2", "decodeMultibaseEncnumbasisAgreement", "Lorg/didcommx/peerdid/core/DecodedEncumbasis;", "multibase", "decodeMultibaseEncnumbasisAuth", "doDecodeService", "", "Lorg/didcommx/peerdid/Service;", "service", "resolvePeerDID", "peerdid"})
@JvmName(name="PeerDIDResolver")
public final class PeerDIDResolver {
    @NotNull
    public static final String resolvePeerDID(@NotNull String peerDID, @NotNull VerificationMaterialFormatPeerDID format) {
        DIDDocPeerDID dIDDocPeerDID;
        Intrinsics.checkNotNullParameter((Object)peerDID, (String)"peerDID");
        Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
        if (!PeerDIDCreator.isPeerDID(peerDID)) {
            throw new MalformedPeerDIDException(Intrinsics.stringPlus((String)"Does not match peer DID regexp: ", (Object)peerDID), null, 2, null);
        }
        char c = peerDID.charAt(9);
        if (c == '0') {
            dIDDocPeerDID = PeerDIDResolver.buildDIDDocNumalgo0(peerDID, format);
        } else if (c == '2') {
            dIDDocPeerDID = PeerDIDResolver.buildDIDDocNumalgo2(peerDID, format);
        } else {
            throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Invalid numalgo of Peer DID: ", (Object)peerDID));
        }
        DIDDocPeerDID didDoc = dIDDocPeerDID;
        String string = didDoc.toJson();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"didDoc.toJson()");
        return string;
    }

    public static /* synthetic */ String resolvePeerDID$default(String string, VerificationMaterialFormatPeerDID verificationMaterialFormatPeerDID, int n, Object object) {
        if ((n & 2) != 0) {
            verificationMaterialFormatPeerDID = VerificationMaterialFormatPeerDID.MULTIBASE;
        }
        return PeerDIDResolver.resolvePeerDID(string, verificationMaterialFormatPeerDID);
    }

    private static final DIDDocPeerDID buildDIDDocNumalgo0(String peerDID, VerificationMaterialFormatPeerDID format) {
        String string = peerDID;
        int n = 10;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
        String inceptionKey = string3;
        DecodedEncumbasis decodedEncumbasis = PeerDIDResolver.decodeMultibaseEncnumbasisAuth(inceptionKey, format);
        return new DIDDocPeerDID(peerDID, CollectionsKt.listOf((Object)PeerDIDUtils.getVerificationMethod(peerDID, decodedEncumbasis)), null, null, 12, null);
    }

    private static final DIDDocPeerDID buildDIDDocNumalgo2(String peerDID, VerificationMaterialFormatPeerDID format) {
        String keys = StringsKt.drop((String)peerDID, (int)11);
        String service = null;
        service = "";
        boolean bl = false;
        List authentications = new ArrayList();
        boolean bl2 = false;
        List keyAgreement = new ArrayList();
        String[] stringArray = new String[]{"."};
        Iterable $this$forEach$iv = StringsKt.split$default((CharSequence)keys, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DecodedEncumbasis decodedEncumbasis;
            String it = (String)element$iv;
            boolean bl3 = false;
            char prefix = it.charAt(0);
            String value = StringsKt.drop((String)it, (int)1);
            char c = prefix;
            if (c == Numalgo2Prefix.SERVICE.getPrefix()) {
                service = value;
                continue;
            }
            if (c == Numalgo2Prefix.AUTHENTICATION.getPrefix()) {
                decodedEncumbasis = PeerDIDResolver.decodeMultibaseEncnumbasisAuth(value, format);
                authentications.add(PeerDIDUtils.getVerificationMethod(peerDID, decodedEncumbasis));
                continue;
            }
            if (c == Numalgo2Prefix.KEY_AGREEMENT.getPrefix()) {
                decodedEncumbasis = PeerDIDResolver.decodeMultibaseEncnumbasisAgreement(value, format);
                keyAgreement.add(PeerDIDUtils.getVerificationMethod(peerDID, decodedEncumbasis));
                continue;
            }
            throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Unsupported transform part of PeerDID: ", (Object)Character.valueOf(prefix)));
        }
        List<Service> decodedService = PeerDIDResolver.doDecodeService(service, peerDID);
        return new DIDDocPeerDID(peerDID, authentications, keyAgreement, decodedService);
    }

    private static final DecodedEncumbasis decodeMultibaseEncnumbasisAuth(String multibase, VerificationMaterialFormatPeerDID format) {
        try {
            DecodedEncumbasis decodedEncumbasis = PeerDIDUtils.decodeMultibaseEncnumbasis(multibase, format);
            ValidationKt.validateAuthenticationMaterialType(decodedEncumbasis.getVerMaterial());
            return decodedEncumbasis;
        }
        catch (IllegalArgumentException e) {
            throw new MalformedPeerDIDException(Intrinsics.stringPlus((String)"Invalid key ", (Object)multibase), e);
        }
    }

    private static final DecodedEncumbasis decodeMultibaseEncnumbasisAgreement(String multibase, VerificationMaterialFormatPeerDID format) {
        try {
            DecodedEncumbasis decodedEncumbasis = PeerDIDUtils.decodeMultibaseEncnumbasis(multibase, format);
            ValidationKt.validateAgreementMaterialType(decodedEncumbasis.getVerMaterial());
            return decodedEncumbasis;
        }
        catch (IllegalArgumentException e) {
            throw new MalformedPeerDIDException(Intrinsics.stringPlus((String)"Invalid key ", (Object)multibase), e);
        }
    }

    private static final List<Service> doDecodeService(String service, String peerDID) {
        try {
            return PeerDIDUtils.decodeService(service, peerDID);
        }
        catch (IllegalArgumentException e) {
            throw new MalformedPeerDIDException("Invalid service", e);
        }
    }
}

