/*
 * Decompiled with CFR 0.152.
 */
package org.didcommx.peerdid.core;

import io.ipfs.multibase.binary.Base64;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.didcommx.peerdid.VerificationMaterial;
import org.didcommx.peerdid.VerificationMethodType;
import org.didcommx.peerdid.VerificationMethodTypeAgreement;
import org.didcommx.peerdid.VerificationMethodTypeAuthentication;
import org.didcommx.peerdid.core.UtilsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u000e\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\u001a\"\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u0004\u00a8\u0006\n"}, d2={"fromJwk", "", "verMaterial", "Lorg/didcommx/peerdid/VerificationMaterial;", "Lorg/didcommx/peerdid/VerificationMethodType;", "toJwk", "", "", "publicKey", "verMethodType", "peerdid"})
public final class JWK_OKPKt {
    @NotNull
    public static final Map<String, String> toJwk(@NotNull byte[] publicKey, @NotNull VerificationMethodType verMethodType) {
        String string;
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        Intrinsics.checkNotNullParameter((Object)verMethodType, (String)"verMethodType");
        byte[] byArray = Base64.encodeBase64URLSafe(publicKey);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"encodeBase64URLSafe(publicKey)");
        String x = StringsKt.decodeToString((byte[])byArray);
        Pair[] pairArray = verMethodType;
        if (Intrinsics.areEqual((Object)pairArray, (Object)VerificationMethodTypeAuthentication.JSON_WEB_KEY_2020.INSTANCE)) {
            string = "Ed25519";
        } else if (Intrinsics.areEqual((Object)pairArray, (Object)VerificationMethodTypeAgreement.JSON_WEB_KEY_2020.INSTANCE)) {
            string = "X25519";
        } else {
            throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Unsupported JWK type ", (Object)verMethodType.getValue()));
        }
        String crv = string;
        pairArray = new Pair[]{TuplesKt.to((Object)"kty", (Object)"OKP"), TuplesKt.to((Object)"crv", (Object)crv), TuplesKt.to((Object)"x", (Object)x)};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @NotNull
    public static final byte[] fromJwk(@NotNull VerificationMaterial<? extends VerificationMethodType> verMaterial) {
        Map<String, Object> jwkDict;
        Intrinsics.checkNotNullParameter(verMaterial, (String)"verMaterial");
        Map<String, Object> map = jwkDict = verMaterial.getValue() instanceof Map ? (Map<String, Object>)verMaterial.getValue() : UtilsKt.fromJsonToMap(verMaterial.getValue().toString());
        Object object = "crv";
        boolean bl = false;
        Map<String, Object> map2 = map;
        if (map2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<K, *>");
        }
        if (!map2.containsKey(object)) {
            throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Invalid JWK key - no 'crv' fields: ", (Object)verMaterial.getValue()));
        }
        map = jwkDict;
        object = "x";
        bl = false;
        Map<String, Object> map3 = map;
        if (map3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<K, *>");
        }
        if (!map3.containsKey(object)) {
            throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Invalid JWK key - no 'x' fields: ", (Object)verMaterial.getValue()));
        }
        object = jwkDict;
        Object object2 = "crv";
        boolean bl2 = false;
        Object crv = object.get(object2);
        if (verMaterial.getType() instanceof VerificationMethodTypeAuthentication && !Intrinsics.areEqual(crv, (Object)"Ed25519")) {
            throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Invalid JWK key type - authentication expected: ", (Object)verMaterial.getValue()));
        }
        if (verMaterial.getType() instanceof VerificationMethodTypeAgreement && !Intrinsics.areEqual(crv, (Object)"X25519")) {
            throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Invalid JWK key type - key agreement expected: ", (Object)verMaterial.getValue()));
        }
        object2 = jwkDict;
        String string = "x";
        boolean bl3 = false;
        String value = String.valueOf(object2.get(string));
        object2 = Base64.decodeBase64(value);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"decodeBase64(value)");
        return object2;
    }
}

