/*
 * Decompiled with CFR 0.152.
 */
package org.didcommx.peerdid.core;

import io.ipfs.multibase.Base58;
import io.ipfs.multibase.Multibase;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.didcommx.peerdid.core.MultibasePrefix;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0003\u001a\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0016\u0010\t\u001a\n \n*\u0004\u0018\u00010\u00030\u00032\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u0016\u0010\u000b\u001a\n \n*\u0004\u0018\u00010\u00030\u00032\u0006\u0010\u0002\u001a\u00020\u0001\u00a8\u0006\f"}, d2={"fromBase58", "", "value", "", "fromBase58Multibase", "Lkotlin/Pair;", "multibase", "isBase58", "", "toBase58", "kotlin.jvm.PlatformType", "toBase58Multibase", "peerdid"})
public final class MultibaseKt {
    public static final String toBase58Multibase(@NotNull byte[] value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return Multibase.encode(Multibase.Base.Base58BTC, value);
    }

    public static final String toBase58(@NotNull byte[] value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return Base58.encode(value);
    }

    @NotNull
    public static final Pair<String, byte[]> fromBase58Multibase(@NotNull String multibase) {
        Intrinsics.checkNotNullParameter((Object)multibase, (String)"multibase");
        CharSequence charSequence = multibase;
        boolean bl = false;
        if (charSequence.length() == 0) {
            throw new IllegalArgumentException("No transform part in multibase encoding");
        }
        char transform = multibase.charAt(0);
        if (transform != MultibasePrefix.BASE58.getPrefix()) {
            throw new IllegalArgumentException("Prefix " + transform + " not supported");
        }
        String encnumbasis = StringsKt.drop((String)multibase, (int)1);
        byte[] decodedEncnumbasis = MultibaseKt.fromBase58(encnumbasis);
        return new Pair((Object)encnumbasis, (Object)decodedEncnumbasis);
    }

    @NotNull
    public static final byte[] fromBase58(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (!MultibaseKt.isBase58(value)) {
            throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Invalid base58 encoding: ", (Object)value));
        }
        byte[] byArray = Base58.decode(value);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(value)");
        return byArray;
    }

    public static final boolean isBase58(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Regex alphabet = new Regex("[1-9a-km-zA-HJ-NP-Z]+");
        return alphabet.matches((CharSequence)value);
    }
}

