/*
 * Decompiled with CFR 0.152.
 */
package org.didcommx.peerdid.core;

import com.zman.varint.VarInt;
import java.nio.ByteBuffer;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.didcommx.peerdid.VerificationMethodType;
import org.didcommx.peerdid.VerificationMethodTypeAgreement;
import org.didcommx.peerdid.VerificationMethodTypeAuthentication;
import org.didcommx.peerdid.core.Codec;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001a\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\u0004\u001a\u00020\u0003\u001a\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0010\u0010\u0005\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0016\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\u000b"}, d2={"fromMulticodec", "Lkotlin/Pair;", "Lorg/didcommx/peerdid/core/Codec;", "", "value", "getCodec", "prefix", "", "keyType", "Lorg/didcommx/peerdid/VerificationMethodType;", "toMulticodec", "peerdid"})
public final class MulticodecKt {
    @NotNull
    public static final byte[] toMulticodec(@NotNull byte[] value, @NotNull VerificationMethodType keyType) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)keyType, (String)"keyType");
        int prefix = MulticodecKt.getCodec(keyType).getPrefix();
        ByteBuffer byteBuffer = ByteBuffer.allocate(2);
        VarInt.writeVarInt((int)prefix, (ByteBuffer)byteBuffer);
        byte[] byArray = byteBuffer.array();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"byteBuffer.array()");
        return ArraysKt.plus((byte[])byArray, (byte[])value);
    }

    @NotNull
    public static final Pair<Codec, byte[]> fromMulticodec(@NotNull byte[] value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        int prefix = VarInt.readVarint((ByteBuffer)ByteBuffer.wrap(value));
        Codec codec = MulticodecKt.getCodec(prefix);
        ByteBuffer byteBuffer = ByteBuffer.allocate(2);
        VarInt.writeVarInt((int)prefix, (ByteBuffer)byteBuffer);
        return new Pair((Object)codec, (Object)CollectionsKt.toByteArray((Collection)ArraysKt.drop((byte[])value, (int)byteBuffer.array().length)));
    }

    private static final Codec getCodec(VerificationMethodType keyType) {
        Codec codec;
        VerificationMethodType verificationMethodType = keyType;
        if (verificationMethodType instanceof VerificationMethodTypeAuthentication) {
            codec = Codec.ED25519;
        } else if (verificationMethodType instanceof VerificationMethodTypeAgreement) {
            codec = Codec.X25519;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return codec;
    }

    private static final Codec getCodec(int prefix) {
        Codec codec;
        block2: {
            Codec codec2;
            Codec[] codecArray = Codec.values();
            boolean bl = false;
            Codec[] codecArray2 = codecArray;
            boolean bl2 = false;
            Codec[] codecArray3 = codecArray2;
            int n = codecArray3.length;
            for (int i = 0; i < n; ++i) {
                Codec codec3;
                Codec it = codec3 = codecArray3[i];
                boolean bl3 = false;
                if (!(it.getPrefix() == prefix)) continue;
                codec2 = codec3;
                break block2;
            }
            codec2 = codec = null;
        }
        if (codec == null) {
            throw new IllegalArgumentException("Prefix " + prefix + " not supported");
        }
        return codec;
    }
}

