/*
 * Decompiled with CFR 0.152.
 */
package com.digitalmediaserver.crowdin;

import com.digitalmediaserver.crowdin.tool.GitUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public abstract class AbstractCrowdinMojo
extends AbstractMojo {
    private static final String HTTP_AUTH_NTLM_DOMAIN = "http.auth.ntlm.domain";
    private static final String HTTP_PROXY_PASSWORD = "http.proxyPassword";
    private static final String HTTP_PROXY_USER = "http.proxyUser";
    private static final String HTTP_PROXY_PORT = "http.proxyPort";
    private static final String HTTP_PROXY_HOST = "http.proxyHost";
    protected static final SAXBuilder SAX_BUILDER = new SAXBuilder();
    protected static final String API_URL = "https://api.crowdin.com/api/project/";
    protected MavenProject project;
    protected File languageFilesFolder;
    protected File downloadFolder;
    protected File statusFile;
    protected String rootBranch;
    protected WagonManager wagonManager;
    protected String crowdinServerId;
    protected CloseableHttpClient client;
    protected AuthenticationInfo authenticationInfo;

    protected void setProject(MavenProject value) {
        this.project = value;
    }

    protected void setLanguageFilesFolder(File folder) {
        this.languageFilesFolder = folder;
    }

    protected void setDownloadFolder(File folder) {
        this.downloadFolder = folder;
    }

    protected void setStatusFile(File statusFile) {
        this.statusFile = statusFile;
    }

    protected void setRootBranch(String branch) {
        this.rootBranch = branch;
    }

    protected void setWagonManager(WagonManager wagonManager) {
        this.wagonManager = wagonManager;
    }

    protected void setCrowdinServerId(String serverId) {
        this.crowdinServerId = serverId;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.authenticationInfo = this.wagonManager.getAuthenticationInfo(this.crowdinServerId);
        if (this.authenticationInfo == null || this.authenticationInfo.getUserName() == null || this.authenticationInfo.getPassword() == null) {
            throw new MojoExecutionException("Failed to find server with id " + this.crowdinServerId + " in Maven settings (~/.m2/settings.xml)");
        }
        HttpClientBuilder clientBuilder = HttpClientBuilder.create();
        if (System.getProperty(HTTP_PROXY_HOST) != null) {
            String host = System.getProperty(HTTP_PROXY_HOST);
            String port = System.getProperty(HTTP_PROXY_PORT);
            if (port == null) {
                throw new MojoExecutionException("http.proxyHost without http.proxyPort");
            }
            RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
            HttpHost proxy = new HttpHost(host, Integer.parseInt(port));
            requestConfigBuilder.setProxy(proxy);
            UsernamePasswordCredentials credentials = null;
            String user = System.getProperty(HTTP_PROXY_USER);
            String password = System.getProperty(HTTP_PROXY_PASSWORD);
            if (System.getProperty(HTTP_AUTH_NTLM_DOMAIN) != null) {
                String domain = System.getProperty(HTTP_AUTH_NTLM_DOMAIN);
                if (user == null || password == null) {
                    throw new MojoExecutionException("http.auth.ntlm.domain without http.proxyUser and http.proxyPassword");
                }
                credentials = new NTCredentials(user, password, host, domain);
            } else if (user != null || password != null) {
                if (user == null || password == null) {
                    throw new MojoExecutionException("http.proxyUser and http.proxyPassword go together");
                }
                credentials = new UsernamePasswordCredentials(user, password);
            }
            if (credentials != null) {
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                credsProvider.setCredentials(new AuthScope(host, Integer.parseInt(port)), (Credentials)credentials);
                clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
            }
            clientBuilder.setDefaultRequestConfig(requestConfigBuilder.build());
        }
        this.client = clientBuilder.build();
    }

    protected boolean crowdinContainsFile(Element files, String fileName, boolean folder, boolean branch) throws MojoExecutionException {
        if (folder && branch) {
            throw new MojoExecutionException("fileName can't be both folder and branch!");
        }
        this.getLog().debug((CharSequence)("Check if crowdin project contains " + fileName));
        List items = files.getChildren("item");
        int slash = fileName.indexOf(47);
        if (slash == -1) {
            if (folder) {
                Element folderElement = this.crowdinGetFolder(items, fileName);
                if (folderElement != null) {
                    this.getLog().debug((CharSequence)("Crowdin project contains folder " + fileName));
                    return true;
                }
            } else if (branch) {
                Element branchElement = this.crowdinGetBranch(items, fileName);
                if (branchElement != null) {
                    this.getLog().debug((CharSequence)("Crowdin project contains branch " + fileName));
                    return true;
                }
            } else {
                for (Element item : items) {
                    if (!fileName.equals(item.getChildTextNormalize("name"))) continue;
                    this.getLog().debug((CharSequence)("Crowdin project contains file " + fileName));
                    return true;
                }
            }
        } else {
            String folderName = fileName.substring(0, slash);
            String subPath = fileName.substring(slash + 1);
            Element folderElement = this.crowdinGetFolder(items, folderName);
            if (folderElement != null) {
                Element subFiles = folderElement.getChild("files");
                return this.crowdinContainsFile(subFiles, subPath, folder, branch);
            }
        }
        this.getLog().debug((CharSequence)("Crowdin project doesn't contain " + (folder ? "folder " : (branch ? "branch " : "file ")) + fileName));
        return false;
    }

    protected boolean crowdinContainsFile(Element files, String fileName) throws MojoExecutionException {
        return this.crowdinContainsFile(files, fileName, false, false);
    }

    protected boolean crowdinContainsFolder(Element files, String folderName) throws MojoExecutionException {
        return this.crowdinContainsFile(files, folderName, true, false);
    }

    protected boolean crowdinContainsBranch(Element files, String branchName) throws MojoExecutionException {
        return this.crowdinContainsFile(files, branchName, false, true);
    }

    protected Element crowdinGetFolder(List<Element> items, String folderName) {
        return this.crowdinGetFolder(items, folderName, false);
    }

    protected Element crowdinGetBranch(List<Element> items, String branchName) {
        return this.crowdinGetFolder(items, branchName, true);
    }

    protected Element crowdinGetFolder(List<Element> items, String folderName, boolean branch) {
        for (Element item : items) {
            if (!folderName.equals(item.getChildTextNormalize("name"))) continue;
            if (branch && this.crowdinIsBranch(item)) {
                return item;
            }
            if (branch || !this.crowdinIsFolder(item)) continue;
            return item;
        }
        return null;
    }

    protected boolean crowdinIsFolder(Element item) {
        return item.getChild("node_type") != null && item.getChildTextNormalize("node_type").equalsIgnoreCase("directory");
    }

    protected boolean crowdinIsBranch(Element item) {
        return item.getChild("node_type") != null && item.getChildTextNormalize("node_type").equalsIgnoreCase("branch");
    }

    protected void crowdinCreateFolder(String folderName) throws MojoExecutionException {
        this.getLog().info((CharSequence)("Creating " + folderName + " folder on crowdin"));
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("name", folderName);
        this.crowdinRequestAPI("add-directory", parameters, null, true);
    }

    protected void crowdinCreateBranch(String branchName) throws MojoExecutionException {
        this.getLog().info((CharSequence)("Creating " + branchName + " branch on crowdin"));
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("name", branchName);
        parameters.put("is_branch", "1");
        this.crowdinRequestAPI("add-directory", parameters, null, true);
    }

    protected Document crowdinRequestAPI(String method, Map<String, String> parameters, Map<String, File> files, boolean mustSucceed) throws MojoExecutionException {
        return this.crowdinRequestAPI(method, parameters, files, null, null, mustSucceed);
    }

    protected Document crowdinRequestAPI(String method, Map<String, String> parameters, Map<String, File> files, Map<String, String> titles, Map<String, String> patterns, boolean mustSucceed) throws MojoExecutionException {
        try {
            StringBuilder url = new StringBuilder(API_URL);
            url.append(this.authenticationInfo.getUserName()).append("/").append(method).append("?key=");
            this.getLog().debug((CharSequence)("Calling " + url + "<API Key>"));
            url.append(this.authenticationInfo.getPassword());
            HttpPost postMethod = new HttpPost(url.toString());
            MultipartEntityBuilder reqEntityBuilder = MultipartEntityBuilder.create();
            if (parameters != null) {
                Set<Map.Entry<String, String>> entrySetParameters = parameters.entrySet();
                for (Map.Entry<String, Object> entry : entrySetParameters) {
                    reqEntityBuilder.addTextBody(entry.getKey(), (String)entry.getValue());
                }
            }
            if (files != null) {
                Set<Map.Entry<String, File>> entrySetFiles = files.entrySet();
                for (Map.Entry<String, Object> entry : entrySetFiles) {
                    String key = "files[" + entry.getKey() + "]";
                    reqEntityBuilder.addPart(key, (ContentBody)new FileBody((File)entry.getValue()));
                }
            }
            if (titles != null) {
                Set<Map.Entry<String, String>> entrySetTitles = titles.entrySet();
                for (Map.Entry<String, Object> entry : entrySetTitles) {
                    reqEntityBuilder.addTextBody("titles[" + entry.getKey() + "]", (String)entry.getValue());
                }
            }
            if (patterns != null) {
                Set<Map.Entry<String, String>> entrySetPatterns = patterns.entrySet();
                for (Map.Entry<String, Object> entry : entrySetPatterns) {
                    reqEntityBuilder.addTextBody("export_patterns[" + entry.getKey() + "]", (String)entry.getValue());
                }
            }
            postMethod.setEntity(reqEntityBuilder.build());
            CloseableHttpResponse response = this.client.execute((HttpUriRequest)postMethod);
            int returnCode = response.getStatusLine().getStatusCode();
            this.getLog().debug((CharSequence)("Return code : " + returnCode));
            InputStream inputStream = response.getEntity().getContent();
            Document document = SAX_BUILDER.build(inputStream);
            if (mustSucceed && document.getRootElement().getName().equals("error")) {
                String code = document.getRootElement().getChildTextNormalize("code");
                String message = document.getRootElement().getChildTextNormalize("message");
                throw new MojoExecutionException("Failed to call API - " + code + " - " + message);
            }
            return document;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to call API: " + e.getMessage(), (Exception)e);
        }
        catch (JDOMException e) {
            throw new MojoExecutionException("Failed to call API: " + e.getMessage(), (Exception)((Object)e));
        }
    }

    protected Element getCrowdinFiles(String branch, Document projectDetails) throws MojoExecutionException {
        if (projectDetails == null) {
            this.getLog().info((CharSequence)"Retrieving crowdin project information");
            projectDetails = this.crowdinRequestAPI("info", null, null, true);
        }
        if (branch != null) {
            Element branchElement = this.crowdinGetBranch(projectDetails.getRootElement().getChild("files").getChildren(), branch);
            if (branchElement == null || !this.crowdinIsBranch(branchElement)) {
                throw new MojoExecutionException("Can't find branch \"" + branch + "\" in crowdin project information");
            }
            return branchElement.getChild("files");
        }
        return projectDetails.getRootElement().getChild("files");
    }

    protected String getMavenId(Artifact artifact) {
        return artifact.getGroupId() + "." + artifact.getArtifactId();
    }

    protected String getBranch() throws MojoExecutionException {
        return this.getBranch(false, null);
    }

    protected String getBranch(boolean create, Document projectDetails) throws MojoExecutionException {
        this.getLog().info((CharSequence)"Determining git branch");
        String branch = GitUtil.getBranch(this.project.getBasedir(), this.getLog());
        if (branch == null || branch.trim().equals("")) {
            throw new MojoExecutionException("Could not determine current git branch");
        }
        if (branch.equals(this.rootBranch)) {
            return null;
        }
        if (this.crowdinContainsBranch(this.getCrowdinFiles(null, projectDetails), branch)) {
            return branch;
        }
        if (create) {
            this.crowdinCreateBranch(branch);
            return branch;
        }
        throw new MojoExecutionException("Crowdin project doesn't contain branch \"" + branch + "\". Please push this branch first.");
    }
}

