/*
 * Decompiled with CFR 0.152.
 */
package com.digitalmediaserver.crowdin;

import com.digitalmediaserver.crowdin.AbstractCrowdinMojo;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.jdom.Document;
import org.jdom.Element;

public class PushCrowdinMojo
extends AbstractCrowdinMojo {
    protected String pushFileName;
    protected String pushFileTitle;
    protected String projectName;
    protected String confirm;

    @Override
    @SuppressFBWarnings(value={"NP_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD", "UWF_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD"})
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!(this.confirm.equalsIgnoreCase("confirm") || this.confirm.equalsIgnoreCase("yes") || this.confirm.equalsIgnoreCase("true"))) {
            throw new MojoExecutionException("Push is not confirmed - aborting!");
        }
        if (!this.project.getName().equals(this.projectName)) {
            throw new MojoExecutionException("POM name (" + this.project.getName() + ") differs from \"projectName\" parameter (" + this.projectName + ") - push aborted!");
        }
        super.execute();
        if (this.languageFilesFolder.exists()) {
            this.getLog().info((CharSequence)"Retrieving crowdin project information");
            Document projectDetails = this.crowdinRequestAPI("info", null, null, true);
            String crowdinProjectName = projectDetails.getRootElement().getChild("details").getChild("name").getText();
            if (!crowdinProjectName.equals(this.projectName)) {
                throw new MojoExecutionException("crowdin project name (" + crowdinProjectName + ") differs from the \"projectName\" parameter (" + this.projectName + ") - push aborted!");
            }
            String branch = this.getBranch(true, projectDetails);
            if (branch != null && !this.crowdinContainsBranch(projectDetails.getRootElement().getChild("files"), branch)) {
                projectDetails = this.crowdinRequestAPI("info", null, null, true);
            }
            Element filesElement = this.getCrowdinFiles(branch, projectDetails);
            this.getLog().debug((CharSequence)("Retrieving message file " + this.pushFileName));
            File pushFile = new File(this.languageFilesFolder, this.pushFileName);
            if (pushFile.exists()) {
                HashMap<String, String> parameters;
                if (this.pushFileTitle == null || this.pushFileTitle.trim().equals("")) {
                    this.pushFileTitle = this.pushFileName;
                }
                HashMap<String, File> fileMap = new HashMap<String, File>();
                fileMap.put(pushFile.getName(), pushFile);
                HashMap<String, String> titleMap = new HashMap<String, String>();
                titleMap.put(this.pushFileName, this.pushFileTitle);
                HashMap<String, String> patternMap = new HashMap<String, String>();
                int dotIdx = this.pushFileName.lastIndexOf(".");
                if (dotIdx > 0) {
                    String bareFileName = this.pushFileName.substring(0, dotIdx);
                    String fileExtension = this.pushFileName.substring(dotIdx);
                    patternMap.put(this.pushFileName, bareFileName + "_%locale_with_underscore%" + fileExtension);
                } else {
                    this.getLog().warn((CharSequence)("Could not figure out export pattern for " + this.pushFileName));
                }
                if (this.crowdinContainsFile(filesElement, this.pushFileName)) {
                    this.getLog().info((CharSequence)("Updating " + this.pushFileName + " on crowdin"));
                    parameters = new HashMap<String, String>();
                    if (branch != null) {
                        parameters.put("branch", branch);
                    }
                    parameters.put("update_option", "update_as_unapproved");
                    parameters.put("escape_quotes", "0");
                    this.crowdinRequestAPI("update-file", parameters, fileMap, titleMap, patternMap, true);
                } else {
                    this.getLog().info((CharSequence)("Adding " + this.pushFileName + " to crowdin"));
                    parameters = new HashMap();
                    if (branch != null) {
                        parameters.put("branch", branch);
                    }
                    parameters.put("type", "properties");
                    parameters.put("escape_quotes", "0");
                    this.crowdinRequestAPI("add-file", parameters, fileMap, titleMap, patternMap, true);
                }
            } else {
                this.getLog().warn((CharSequence)(this.languageFilesFolder.getPath() + "/" + this.pushFileName + " push skipped - file not found"));
            }
        } else {
            this.getLog().warn((CharSequence)(this.languageFilesFolder.getPath() + "/" + this.pushFileName + " push skipped - folder not found"));
        }
    }

    private Map<String, File> getMessageFiles(String folderName) {
        File[] listFiles;
        HashMap<String, File> result = new HashMap<String, File>();
        for (File file : listFiles = this.languageFilesFolder.listFiles()) {
            if (file.isDirectory() || file.getName().startsWith(".") || !file.getName().endsWith(".properties")) continue;
            String crowdinPath = folderName + "/" + file.getName();
            this.getLog().debug((CharSequence)("Found " + crowdinPath));
            result.put(crowdinPath, file);
        }
        return result;
    }
}

