/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.crowdin;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.digitalmediaserver.crowdin.configuration.StatusFile;
import org.digitalmediaserver.crowdin.configuration.TranslationFileSet;
import org.digitalmediaserver.crowdin.tool.CrowdinAPI;
import org.digitalmediaserver.crowdin.tool.CrowdinFileSystem;
import org.digitalmediaserver.crowdin.tool.GitUtil;
import org.jdom2.Document;

@SuppressFBWarnings(value={"UUF_UNUSED_PUBLIC_OR_PROTECTED_FIELD", "URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD", "UWF_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD", "UWF_UNWRITTEN_FIELD"})
public abstract class AbstractCrowdinMojo
extends AbstractMojo {
    protected MavenSession mavenSession;
    protected MavenProject project;
    protected File downloadFolder;
    protected Path downloadFolderPath;
    protected String comment;
    protected String lineSeparator;
    protected String rootBranch;
    protected String crowdinServerId;
    protected List<TranslationFileSet> translationFileSets;
    protected List<StatusFile> statusFiles;
    protected CloseableHttpClient client;
    protected Server server;

    protected void setProject(MavenProject value) {
        this.project = value;
    }

    protected void setDownloadFolder(Path folder) {
        this.downloadFolder = folder.toFile();
        this.downloadFolderPath = folder;
    }

    protected void setDownloadFolder(File folder) {
        this.downloadFolder = folder;
        this.downloadFolderPath = folder.toPath();
    }

    protected void setRootBranch(String branch) {
        this.rootBranch = branch;
    }

    protected void setCrowdinServerId(String serverId) {
        this.crowdinServerId = serverId;
    }

    protected void setTranslationFileSets(List<TranslationFileSet> translationFileSets) {
        this.translationFileSets = translationFileSets;
    }

    protected void setStatusFiles(List<StatusFile> statusFiles) {
        this.statusFiles = statusFiles;
    }

    protected void setClient(CloseableHttpClient client) {
        this.client = client;
    }

    protected void setServer(Server server) {
        this.server = server;
    }

    protected void initializeServer() throws MojoExecutionException {
        if (this.server == null) {
            if (AbstractCrowdinMojo.isBlank(this.crowdinServerId)) {
                throw new MojoExecutionException("Parameter \"crowdinServerId\" must be specified");
            }
            if (this.mavenSession == null) {
                throw new MojoExecutionException("Parameter \"mavenSession\" is null");
            }
            Settings settings = this.mavenSession.getSettings();
            if (settings != null) {
                this.server = settings.getServer(this.crowdinServerId);
            }
        }
        if (this.server == null) {
            throw new MojoExecutionException("Failed to find server setting with ID " + this.crowdinServerId + " in the Maven settings (~/.m2/settings.xml)");
        }
        if (AbstractCrowdinMojo.isBlank(this.server.getUsername())) {
            throw new MojoExecutionException("No username is configured for the server setting with ID " + this.crowdinServerId);
        }
        if (AbstractCrowdinMojo.isBlank(this.server.getPassword())) {
            throw new MojoExecutionException("No password is configured for the server setting with ID " + this.crowdinServerId);
        }
    }

    protected void createClient() throws MojoExecutionException {
        if (this.client != null) {
            return;
        }
        try {
            this.client = CrowdinAPI.createHTTPClient();
        }
        catch (IOException e) {
            throw new MojoExecutionException("An error occurred while creating the HTTP client: " + e.getMessage(), (Exception)e);
        }
    }

    protected void initializeParameters() throws MojoExecutionException {
        this.downloadFolderPath = this.downloadFolder != null ? this.downloadFolder.toPath() : null;
    }

    @Nullable
    protected String getBranch() throws MojoExecutionException {
        return this.getBranch(false, null);
    }

    @Nullable
    protected String getBranch(boolean create, @Nullable Document projectDetails) throws MojoExecutionException {
        this.getLog().info((CharSequence)"Determining git branch..");
        String branch = GitUtil.getBranch(this.project.getBasedir(), this.getLog());
        if (AbstractCrowdinMojo.isBlank(branch)) {
            throw new MojoExecutionException("Could not determine current git branch");
        }
        this.getLog().info((CharSequence)("Git branch is \"" + branch + "\""));
        if (branch.equals(this.rootBranch)) {
            return null;
        }
        try {
            if (CrowdinFileSystem.containsBranch(CrowdinAPI.getFiles((HttpClient)this.client, this.server, null, projectDetails, this.getLog()), branch, this.getLog())) {
                this.getLog().info((CharSequence)("Found branch \"" + branch + "\" on Crowdin"));
                return branch;
            }
            if (create) {
                CrowdinFileSystem.createBranch((HttpClient)this.client, this.server, branch, this.getLog());
                return branch;
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("An error occured while trying to resolve Crowdin branch: " + e.getMessage(), (Exception)e);
        }
        throw new MojoExecutionException("Crowdin project doesn't contain branch \"" + branch + "\". Please push this branch first.");
    }

    protected void cleanDownloadFolder() throws MojoExecutionException {
        if (Files.exists(this.downloadFolderPath, new LinkOption[0])) {
            this.getLog().info((CharSequence)("Deleting the content of \"" + this.downloadFolderPath.toAbsolutePath() + "\""));
            try {
                Files.walkFileTree(this.downloadFolderPath, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Files.delete(file);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                        throw exc;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                        if (!AbstractCrowdinMojo.this.downloadFolderPath.equals(dir)) {
                            Files.delete(dir);
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException e) {
                throw new MojoExecutionException("Could not clean \"" + this.downloadFolderPath.toAbsolutePath() + "\": " + e.getMessage(), (Exception)e);
            }
        }
        this.getLog().info((CharSequence)("Creating download folder \"" + this.downloadFolderPath.toAbsolutePath() + "\""));
        try {
            Files.createDirectories(this.downloadFolderPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Couldn't create folder \"" + this.downloadFolderPath.toAbsolutePath() + "\": " + e.getMessage(), (Exception)e);
        }
    }

    public static boolean isBlank(@Nullable CharSequence cs) {
        if (cs == null) {
            return true;
        }
        int strLen = cs.length();
        if (strLen == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

