/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.crowdin.configuration;

import java.nio.charset.Charset;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.maven.plugin.MojoExecutionException;
import org.digitalmediaserver.crowdin.configuration.Conversion;
import org.digitalmediaserver.crowdin.configuration.FileType;

public abstract class AbstractFileSet {
    @Nullable
    protected String encoding;
    @Nullable
    protected Boolean sortLines;
    @Nullable
    protected Boolean addComment;
    @Nullable
    protected String comment;
    @Nullable
    protected String lineSeparator;
    @Nullable
    protected Boolean escapeUnicode;
    @Nullable
    protected FileType type;
    @Nullable
    protected List<Conversion> conversions;
    @Nullable
    protected Charset charset;

    @Nullable
    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Nullable
    public Charset getCharset() {
        return this.charset;
    }

    public void setCharset(@Nullable Charset charset) {
        this.charset = charset;
    }

    @Nullable
    public Boolean getSortLines() {
        return this.sortLines;
    }

    @Nullable
    public Boolean getAddComment() {
        return this.addComment;
    }

    @Nullable
    public String getComment() {
        return this.comment;
    }

    @Nullable
    public String getLineSeparator() {
        return this.lineSeparator;
    }

    @Nullable
    public Boolean getEscapeUnicode() {
        return this.escapeUnicode;
    }

    @Nullable
    public FileType getType() {
        return this.type;
    }

    public void setType(@Nullable FileType type) {
        this.type = type;
    }

    @Nullable
    public List<Conversion> getConversions() {
        return this.conversions;
    }

    public static void initialize(@Nullable List<? extends AbstractFileSet> fileSets) throws MojoExecutionException {
        if (fileSets == null || fileSets.isEmpty()) {
            return;
        }
        for (AbstractFileSet abstractFileSet : fileSets) {
            abstractFileSet.initializeInstance();
        }
    }

    protected void initializeInstance() throws MojoExecutionException {
        if (this.conversions != null && !this.conversions.isEmpty()) {
            for (Conversion conversion : this.conversions) {
                if (conversion.getFrom() != null && !conversion.getFrom().isEmpty() && conversion.getTo() != null) continue;
                String from = conversion.getFrom() == null ? "null" : "\"" + conversion.getFrom() + "\"";
                String to = conversion.getTo() == null ? "null" : "\"" + conversion.getTo() + "\"";
                throw new MojoExecutionException("Invalid conversion: \"" + from + " -> " + to + "\" in file set \"" + this.toString() + "\"");
            }
        }
    }
}

