/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.crowdin.tool;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.digitalmediaserver.crowdin.tool.OrderedProperties;

public class GroupSortedProperties
extends OrderedProperties {
    private static final long serialVersionUID = 1L;
    protected static final EntryComparator COMPARATOR = new EntryComparator();
    private final ArrayList<Map.Entry<String, String>> storage = new ArrayList();

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        Collections.sort(this.storage, COMPARATOR);
        return this.storage.iterator();
    }

    @Override
    public String put(String key, String value) {
        for (Map.Entry<String, String> entry : this.storage) {
            if (!Objects.equals(key, entry.getKey())) continue;
            return entry.setValue(value);
        }
        this.storage.add(new Entry(key, value));
        return null;
    }

    protected static class Entry
    implements Map.Entry<String, String>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final String key;
        private String value;

        public Entry(@Nullable String key, @Nullable String value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public String setValue(String value) {
            String oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Entry)) {
                return false;
            }
            Entry other = (Entry)obj;
            if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    protected static class EntryComparator
    implements Comparator<Map.Entry<String, String>>,
    Serializable {
        private static final long serialVersionUID = 1L;

        protected EntryComparator() {
        }

        @Override
        public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
            if (o1 == null || o2 == null) {
                return o1 == null && o2 == null ? 0 : (o1 == null ? 1 : -1);
            }
            String s1 = o1.getKey();
            String s2 = o2.getKey();
            if (s1 == null || s2 == null) {
                return s1 == null && s2 == null ? 0 : (s1 == null ? 1 : -1);
            }
            int s1start = 0;
            int s2start = 0;
            int s1end = 0;
            int s2end = 0;
            int result = 0;
            while (result == 0 && (s1start < s1.length() || s2start < s2.length())) {
                boolean isDigit;
                while (s1start < s1.length() && Character.isWhitespace(s1.charAt(s1start))) {
                    ++s1start;
                }
                while (s2start < s2.length() && Character.isWhitespace(s2.charAt(s2start))) {
                    ++s2start;
                }
                boolean s1IsNumber = true;
                boolean s1HasDigit = false;
                boolean s2IsNumber = true;
                boolean s2HasDigit = false;
                s2end = s2start;
                for (s1end = s1start; s1end < s1.length() && s1.charAt(s1end) != '.'; ++s1end) {
                    isDigit = Character.isDigit(s1.charAt(s1end));
                    s1IsNumber &= isDigit;
                    s1HasDigit |= isDigit;
                }
                while (s2end < s2.length() && s2.charAt(s2end) != '.') {
                    isDigit = Character.isDigit(s2.charAt(s2end));
                    s2IsNumber &= isDigit;
                    s2HasDigit |= isDigit;
                    ++s2end;
                }
                String s1Part = s1.substring(s1start, s1end);
                String s2Part = s2.substring(s2start, s2end);
                if (s1IsNumber && s1HasDigit && s2IsNumber && s2HasDigit) {
                    result = Integer.parseInt(s1Part) - Integer.parseInt(s2Part);
                } else {
                    if (s1IsNumber && s1HasDigit) {
                        return 1;
                    }
                    if (s2IsNumber && s2HasDigit) {
                        return -1;
                    }
                    result = s1Part.compareTo(s2Part);
                }
                s1start = s1end == s1.length() ? s1end : s1end + 1;
                s2start = s2end == s2.length() ? s2end : s2end + 1;
            }
            return result;
        }
    }
}

