/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.crowdin.tool;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.digitalmediaserver.crowdin.AbstractCrowdinMojo;

public abstract class OrderedProperties
implements Iterable<Map.Entry<String, String>>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final char[] HEX_DIGIT = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public abstract String put(String var1, String var2);

    public void store(@Nonnull OutputStream out, @Nullable String comment, @Nullable String lineSeparator, boolean escapeUnicode) throws IOException {
        this.store(new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.ISO_8859_1)), comment, lineSeparator, escapeUnicode);
    }

    public void store(@Nonnull Writer writer, @Nullable String comment, @Nullable String lineSeparator, boolean escapeUnicode) throws IOException {
        this.store(writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer), comment, lineSeparator, escapeUnicode);
    }

    public void store(@Nonnull BufferedWriter bw, @Nullable String comment, @Nullable String lineSeparator, boolean escapeUnicode) throws IOException {
        if (!AbstractCrowdinMojo.isBlank(comment)) {
            OrderedProperties.writeComment(bw, comment, lineSeparator);
            OrderedProperties.writeNewLine(bw, lineSeparator);
        }
        for (Map.Entry entry : this) {
            String key = OrderedProperties.saveConvert((String)entry.getKey(), true, escapeUnicode);
            String value = OrderedProperties.saveConvert((String)entry.getValue(), false, escapeUnicode);
            bw.write(key + "=" + value);
            OrderedProperties.writeNewLine(bw, lineSeparator);
        }
        bw.flush();
    }

    public static void writeNewLine(@Nonnull BufferedWriter bw, @Nullable String lineSeparator) throws IOException {
        if (lineSeparator == null) {
            bw.newLine();
        } else {
            bw.write(lineSeparator);
        }
    }

    public void load(@Nullable InputStream inputStream) throws IOException {
        if (inputStream != null) {
            this.doLoad(new LineReader(inputStream));
        }
    }

    public void load(@Nullable BufferedReader reader) throws IOException {
        if (reader != null) {
            this.doLoad(new LineReader(reader));
        }
    }

    protected void doLoad(@Nonnull LineReader lineReader) throws IOException {
        int limit;
        char[] convtBuf = new char[1024];
        while ((limit = lineReader.readLine()) >= 0) {
            int keyLen;
            char c = '\u0000';
            int valueStart = limit;
            boolean hasSep = false;
            boolean precedingBackslash = false;
            for (keyLen = 0; keyLen < limit; ++keyLen) {
                c = lineReader.lineBuf[keyLen];
                if (!(c != '=' && c != ':' || precedingBackslash)) {
                    valueStart = keyLen + 1;
                    hasSep = true;
                    break;
                }
                if (!(c != ' ' && c != '\t' && c != '\f' || precedingBackslash)) {
                    valueStart = keyLen + 1;
                    break;
                }
                precedingBackslash = c == '\\' ? !precedingBackslash : false;
            }
            while (valueStart < limit) {
                c = lineReader.lineBuf[valueStart];
                if (c != ' ' && c != '\t' && c != '\f') {
                    if (hasSep || c != '=' && c != ':') break;
                    hasSep = true;
                }
                ++valueStart;
            }
            String key = OrderedProperties.loadConvert(lineReader.lineBuf, 0, keyLen, convtBuf);
            String value = OrderedProperties.loadConvert(lineReader.lineBuf, valueStart, limit - valueStart, convtBuf);
            this.put(key, value);
        }
    }

    protected static String loadConvert(@Nonnull char[] in, int off, int len, @Nonnull char[] convertBuffer) {
        if (convertBuffer.length < len) {
            int newLen = len * 2;
            if (newLen < 0) {
                newLen = Integer.MAX_VALUE;
            }
            convertBuffer = new char[newLen];
        }
        char[] out = convertBuffer;
        int outLen = 0;
        int end = off + len;
        while (off < end) {
            int aChar;
            if ((aChar = in[off++]) == 92) {
                if ((aChar = in[off++]) == 117) {
                    int value = 0;
                    block6: for (int i = 0; i < 4; ++i) {
                        aChar = in[off++];
                        switch (aChar) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                value = (value << 4) + aChar - 48;
                                continue block6;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                value = (value << 4) + 10 + aChar - 97;
                                continue block6;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                value = (value << 4) + 10 + aChar - 65;
                                continue block6;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                    }
                    out[outLen++] = (char)value;
                    continue;
                }
                if (aChar == 116) {
                    aChar = 9;
                } else if (aChar == 114) {
                    aChar = 13;
                } else if (aChar == 110) {
                    aChar = 10;
                } else if (aChar == 102) {
                    aChar = 12;
                }
                out[outLen++] = aChar;
                continue;
            }
            out[outLen++] = aChar;
        }
        return new String(out, 0, outLen);
    }

    @Nullable
    protected static String saveConvert(@Nullable String content, boolean isKey, boolean escapeUnicode) {
        if (content == null) {
            return null;
        }
        int len = content.length();
        int bufLen = len * 2;
        if (bufLen < 0) {
            bufLen = Integer.MAX_VALUE;
        }
        StringBuilder outBuffer = new StringBuilder(bufLen);
        block8: for (int x = 0; x < len; ++x) {
            char aChar = content.charAt(x);
            if (aChar > '=' && aChar < '\u007f') {
                if (aChar == '\\') {
                    outBuffer.append('\\').append('\\');
                    continue;
                }
                outBuffer.append(aChar);
                continue;
            }
            switch (aChar) {
                case ' ': {
                    if (x == 0 || isKey) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(' ');
                    continue block8;
                }
                case '\t': {
                    outBuffer.append('\\').append('t');
                    continue block8;
                }
                case '\n': {
                    outBuffer.append('\\').append('n');
                    continue block8;
                }
                case '\r': {
                    outBuffer.append('\\').append('r');
                    continue block8;
                }
                case '\f': {
                    outBuffer.append('\\').append('f');
                    continue block8;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': {
                    if (isKey) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(aChar);
                    continue block8;
                }
                default: {
                    if ((aChar < ' ' || aChar > '~') & escapeUnicode) {
                        outBuffer.append('\\').append('u').append(OrderedProperties.toHex(aChar >> 12 & 0xF)).append(OrderedProperties.toHex(aChar >> 8 & 0xF)).append(OrderedProperties.toHex(aChar >> 4 & 0xF)).append(OrderedProperties.toHex(aChar & 0xF));
                        continue block8;
                    }
                    outBuffer.append(aChar);
                }
            }
        }
        return outBuffer.toString();
    }

    protected static void writeComment(@Nonnull BufferedWriter bw, @Nullable String comment, @Nullable String lineSeparator) throws IOException {
        int current;
        if (AbstractCrowdinMojo.isBlank(comment)) {
            return;
        }
        bw.write("# ");
        int len = comment.length();
        int last = 0;
        char[] uu = new char[6];
        uu[0] = 92;
        uu[1] = 117;
        for (current = 0; current < len; ++current) {
            char c = comment.charAt(current);
            if (c <= '\u00ff' && c != '\n' && c != '\r') continue;
            if (last != current) {
                bw.write(comment.substring(last, current));
            }
            if (c > '\u00ff') {
                uu[2] = OrderedProperties.toHex(c >> 12 & 0xF);
                uu[3] = OrderedProperties.toHex(c >> 8 & 0xF);
                uu[4] = OrderedProperties.toHex(c >> 4 & 0xF);
                uu[5] = OrderedProperties.toHex(c & 0xF);
                bw.write(new String(uu));
            } else {
                OrderedProperties.writeNewLine(bw, lineSeparator);
                if (c == '\r' && current != len - 1 && comment.charAt(current + 1) == '\n') {
                    ++current;
                }
                if (current == len - 1 || comment.charAt(current + 1) != '#' && comment.charAt(current + 1) != '!') {
                    bw.write("#");
                }
            }
            last = current + 1;
        }
        if (last != current) {
            bw.write(comment.substring(last, current));
        }
        OrderedProperties.writeNewLine(bw, lineSeparator);
    }

    public static char toHex(int nibble) {
        return HEX_DIGIT[nibble & 0xF];
    }

    protected static class LineReader {
        private byte[] inByteBuf;
        private char[] inCharBuf;
        private char[] lineBuf = new char[1024];
        private int inLimit = 0;
        private int inOff = 0;
        private InputStream inStream;
        private Reader reader;

        public LineReader(@Nonnull InputStream inStream) {
            this.inStream = inStream;
            this.inByteBuf = new byte[8192];
        }

        public LineReader(@Nonnull Reader reader) {
            this.reader = reader;
            this.inCharBuf = new char[8192];
        }

        int readLine() throws IOException {
            int len = 0;
            char c = '\u0000';
            boolean skipWhiteSpace = true;
            boolean isCommentLine = false;
            boolean isNewLine = true;
            boolean appendedLineBegin = false;
            boolean precedingBackslash = false;
            boolean skipLF = false;
            while (true) {
                if (this.inOff >= this.inLimit) {
                    this.inLimit = this.inStream == null ? this.reader.read(this.inCharBuf) : this.inStream.read(this.inByteBuf);
                    this.inOff = 0;
                    if (this.inLimit <= 0) {
                        if (len == 0 || isCommentLine) {
                            return -1;
                        }
                        return len;
                    }
                }
                c = this.inStream != null ? (char)(0xFF & this.inByteBuf[this.inOff++]) : this.inCharBuf[this.inOff++];
                if (skipLF) {
                    skipLF = false;
                    if (c == '\n') continue;
                }
                if (skipWhiteSpace) {
                    if (c == ' ' || c == '\t' || c == '\f' || !appendedLineBegin && (c == '\r' || c == '\n')) continue;
                    skipWhiteSpace = false;
                    appendedLineBegin = false;
                }
                if (isNewLine) {
                    isNewLine = false;
                    if (c == '#' || c == '!') {
                        isCommentLine = true;
                        continue;
                    }
                }
                if (c != '\n' && c != '\r') {
                    this.lineBuf[len++] = c;
                    if (len == this.lineBuf.length) {
                        int newLength = this.lineBuf.length * 2;
                        if (newLength < 0) {
                            newLength = Integer.MAX_VALUE;
                        }
                        char[] buf = new char[newLength];
                        System.arraycopy(this.lineBuf, 0, buf, 0, this.lineBuf.length);
                        this.lineBuf = buf;
                    }
                    if (c == '\\') {
                        precedingBackslash = !precedingBackslash;
                        continue;
                    }
                    precedingBackslash = false;
                    continue;
                }
                if (isCommentLine || len == 0) {
                    isCommentLine = false;
                    isNewLine = true;
                    skipWhiteSpace = true;
                    len = 0;
                    continue;
                }
                if (this.inOff >= this.inLimit) {
                    this.inLimit = this.inStream == null ? this.reader.read(this.inCharBuf) : this.inStream.read(this.inByteBuf);
                    this.inOff = 0;
                    if (this.inLimit <= 0) {
                        return len;
                    }
                }
                if (!precedingBackslash) break;
                --len;
                skipWhiteSpace = true;
                appendedLineBegin = true;
                precedingBackslash = false;
                if (c != '\r') continue;
                skipLF = true;
            }
            return len;
        }
    }
}

