/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.crowdin;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.digitalmediaserver.crowdin.AbstractCrowdinMojo;
import org.digitalmediaserver.crowdin.configuration.StatusFile;
import org.digitalmediaserver.crowdin.configuration.TranslationFileSet;
import org.digitalmediaserver.crowdin.tool.CrowdinAPI;
import org.jdom2.Document;
import org.jdom2.output.XMLOutputter;

public class FetchCrowdinMojo
extends AbstractCrowdinMojo {
    public void execute() throws MojoExecutionException {
        this.initializeParameters();
        TranslationFileSet.initialize(this.translationFileSets);
        StatusFile.initialize(this.statusFiles);
        this.createClient();
        this.initializeServer();
        this.doExecute();
    }

    public void doExecute() throws MojoExecutionException {
        if (this.translationFileSets == null || this.translationFileSets.isEmpty()) {
            throw new MojoExecutionException("No filesets are defined");
        }
        this.cleanDownloadFolder();
        String branch = this.getBranch();
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (branch != null) {
            parameters.put("branch", branch);
        }
        this.getLog().info((CharSequence)"Downloading translations from Crowdin");
        try {
            HttpResponse response = CrowdinAPI.requestPost((HttpClient)this.client, this.server, "download/all.zip", parameters, this.getLog());
            int returnCode = response.getStatusLine().getStatusCode();
            this.getLog().debug((CharSequence)("Crowdin return code : " + returnCode));
            if (returnCode == 200) {
                int count = 0;
                byte[] buf = new byte[1024];
                try (InputStream responseBodyAsStream = response.getEntity().getContent();
                     ZipInputStream zis = new ZipInputStream(responseBodyAsStream);){
                    ZipEntry entry;
                    while ((entry = zis.getNextEntry()) != null) {
                        if (entry.isDirectory()) {
                            this.getLog().debug((CharSequence)("Creating folder \"" + entry.getName() + "\""));
                            Files.createDirectories(this.downloadFolderPath.resolve(entry.getName()), new FileAttribute[0]);
                            continue;
                        }
                        this.getLog().debug((CharSequence)("Writing \"" + entry.getName() + "\""));
                        Path path = this.downloadFolderPath.resolve(entry.getName());
                        try (OutputStream os = Files.newOutputStream(path, new OpenOption[0]);){
                            while (zis.available() > 0) {
                                int read = zis.read(buf);
                                if (read == -1) continue;
                                os.write(buf, 0, read);
                            }
                        }
                        ++count;
                    }
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Failed to download translation files: " + e.getMessage(), (Exception)e);
                }
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                if (count == 0) {
                    this.getLog().info((CharSequence)"No translations available for this project!");
                } else {
                    this.getLog().info((CharSequence)("Successfully downloaded " + count + " files from Crowdin"));
                }
            } else {
                if (returnCode == 404) {
                    throw new MojoExecutionException("Could not find any files in branch \"" + (branch != null ? branch : this.rootBranch) + "\" on Crowdin");
                }
                throw new MojoExecutionException("Failed to get translations from Crowdin with return code " + Integer.toString(returnCode));
            }
            this.downloadStatusFile();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to call API: " + e.getMessage(), (Exception)e);
        }
    }

    protected void downloadStatusFile() throws MojoExecutionException {
        Document document;
        if (this.statusFiles == null || this.statusFiles.isEmpty()) {
            return;
        }
        try {
            document = CrowdinAPI.requestPostDocument((HttpClient)this.client, this.server, "status", null, null, true, this.getLog());
        }
        catch (IOException e) {
            throw new MojoExecutionException("An error occurred while getting the Crowdin status: " + e.getMessage(), (Exception)e);
        }
        XMLOutputter xmlOut = new XMLOutputter();
        Path statusFile = this.downloadFolderPath.resolve("crowdin_status.xml");
        this.getLog().info((CharSequence)("Writing translations status to \"" + statusFile + "\""));
        try (BufferedWriter writer = Files.newBufferedWriter(statusFile, StandardCharsets.UTF_8, new OpenOption[0]);){
            xmlOut.output(document, (Writer)writer);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to write file \"" + statusFile + "\": " + e.getMessage(), (Exception)e);
        }
    }
}

