/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.crowdin.configuration;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Locale;
import org.digitalmediaserver.crowdin.AbstractCrowdinMojo;

public enum FileType {
    auto(new String[0]),
    android("xml"),
    macosx("strings"),
    resx("resx", "resw"),
    properties("properties"),
    gettext("po", "pot"),
    yaml("yaml"),
    php("php"),
    json("json"),
    xml("xml"),
    ini("ini"),
    rc("rc"),
    resw("resw"),
    resjson("resjson"),
    qtts("ts"),
    joomla("ini"),
    chrome("json"),
    dtd("dtd"),
    dklang("dklang"),
    flex("properties"),
    nsh("nsh"),
    wxl("wxl"),
    xliff("xliff"),
    html("html", "htm", "xhtml", "xhtm"),
    haml("haml"),
    txt("txt"),
    csv("csv"),
    md("md", "text", "markdown"),
    flsnp("flnsp", "flpgpl", "fltoc"),
    fm_html("html"),
    fm_md("md"),
    mediawiki("wiki", "wikitext", "mediawiki"),
    docx("docx", "dotx", "odt", "ott", "xslx", "xltx", "pptx", "potx", "ods", "ots", "odg", "otg", "odp", "otp", "imdl", "mif"),
    sbv("sbv"),
    vtt("vtt"),
    srt("srt");

    private final String[] extensions;

    private FileType(String ... extensions) {
        this.extensions = extensions;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public String[] getExtensions() {
        return this.extensions;
    }

    public boolean hasExtension(String extension) {
        if (AbstractCrowdinMojo.isBlank(extension) || this.extensions == null || this.extensions.length == 0) {
            return false;
        }
        if (extension.startsWith(".")) {
            extension = extension.substring(1);
        }
        extension = extension.trim().toLowerCase(Locale.ROOT);
        for (String memberExtension : this.extensions) {
            if (!extension.equals(memberExtension)) continue;
            return true;
        }
        return false;
    }
}

