/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.crowdin;

import java.io.IOException;
import java.util.HashMap;
import org.apache.http.client.HttpClient;
import org.apache.maven.plugin.MojoExecutionException;
import org.digitalmediaserver.crowdin.AbstractCrowdinMojo;
import org.digitalmediaserver.crowdin.tool.CrowdinAPI;
import org.jdom2.Document;

public class BuildCrowdinMojo
extends AbstractCrowdinMojo {
    public void execute() throws MojoExecutionException {
        this.createClient();
        this.initializeServer();
        this.doExecute();
    }

    public void doExecute() throws MojoExecutionException {
        Document document;
        String branch = this.getBranch();
        if (branch == null) {
            this.getLog().info((CharSequence)"Asking Crowdin to build translations");
        } else {
            this.getLog().info((CharSequence)("Asking Crowdin to build translations for branch \"" + branch + "\""));
        }
        HashMap<String, String> parameters = null;
        if (branch != null) {
            parameters = new HashMap<String, String>();
            parameters.put("branch", branch);
        }
        try {
            document = CrowdinAPI.requestGetDocument((HttpClient)this.client, this.server, "export", parameters, this.getLog());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to build translations at Crowdin: " + e.getMessage(), (Exception)e);
        }
        String status = document.getRootElement().getAttributeValue("status");
        if (status.equals("skipped")) {
            this.getLog().warn((CharSequence)"Crowdin build skipped either because the files are up to date or because the last build was less than 30 minutes ago");
        } else if (status.equals("built")) {
            this.getLog().info((CharSequence)"Crowdin successfully built translations");
        } else {
            this.getLog().warn((CharSequence)("Crowdin replied to build request with an unexpected status: \"" + status + "\""));
        }
    }
}

