/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.crowdin;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import org.apache.http.client.HttpClient;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.content.AbstractContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.maven.plugin.MojoExecutionException;
import org.digitalmediaserver.crowdin.AbstractCrowdinMojo;
import org.digitalmediaserver.crowdin.configuration.FileType;
import org.digitalmediaserver.crowdin.configuration.TranslationFileSet;
import org.digitalmediaserver.crowdin.configuration.UpdateOption;
import org.digitalmediaserver.crowdin.tool.CrowdinAPI;
import org.digitalmediaserver.crowdin.tool.CrowdinFileSystem;
import org.digitalmediaserver.crowdin.tool.NSISUtil;
import org.jdom2.Document;
import org.jdom2.Element;

public class PushCrowdinMojo
extends AbstractCrowdinMojo {
    protected String projectName;
    protected String confirm;
    protected int escapeQuotes;
    protected UpdateOption updateOption;

    @SuppressFBWarnings(value={"NP_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD", "UWF_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD"})
    public void execute() throws MojoExecutionException {
        Element filesElement;
        Document projectDetails;
        if (!(this.confirm.equalsIgnoreCase("confirm") || this.confirm.equalsIgnoreCase("yes") || this.confirm.equalsIgnoreCase("true"))) {
            throw new MojoExecutionException("Push is not confirmed - aborting!");
        }
        if (!this.project.getName().equals(this.projectName)) {
            throw new MojoExecutionException("POM name (" + this.project.getName() + ") differs from \"projectName\" parameter (" + this.projectName + ") - push aborted!");
        }
        this.initializeParameters();
        this.initializeServer();
        this.createClient();
        TranslationFileSet.initialize(this.translationFileSets);
        this.getLog().info((CharSequence)"Retrieving Crowdin project information");
        try {
            projectDetails = CrowdinAPI.requestPostDocument((HttpClient)this.client, this.server, "info", null, null, true, this.getLog());
        }
        catch (IOException e) {
            throw new MojoExecutionException("An error occurred while getting Crowdin information: " + e.getMessage(), (Exception)e);
        }
        String crowdinProjectName = projectDetails.getRootElement().getChild("details").getChild("name").getText();
        if (!crowdinProjectName.equals(this.projectName)) {
            throw new MojoExecutionException("Crowdin project name (" + crowdinProjectName + ") differs from the \"projectName\" parameter (" + this.projectName + ") - push aborted!");
        }
        String branch = this.getBranch(true, projectDetails);
        if (branch != null && !CrowdinFileSystem.containsBranch(projectDetails.getRootElement().getChild("files"), branch, this.getLog())) {
            try {
                projectDetails = CrowdinAPI.requestPostDocument((HttpClient)this.client, this.server, "info", null, null, true, this.getLog());
            }
            catch (IOException e) {
                throw new MojoExecutionException("An error occurred while getting Crowdin information: " + e.getMessage(), (Exception)e);
            }
        }
        try {
            filesElement = CrowdinAPI.getFiles((HttpClient)this.client, this.server, branch, projectDetails, this.getLog());
        }
        catch (IOException e) {
            throw new MojoExecutionException("An error occurred while getting Crowdin files: " + e.getMessage(), (Exception)e);
        }
        for (TranslationFileSet fileSet : this.translationFileSets) {
            Path pushFile = fileSet.getLanguageFilesFolder().toPath().resolve(fileSet.getBaseFileName());
            if (Files.exists(pushFile, new LinkOption[0])) {
                String pushFolder = CrowdinFileSystem.getPushFolder(fileSet, true);
                if (!PushCrowdinMojo.isBlank(pushFolder) && !CrowdinFileSystem.containsFolder(filesElement, pushFolder, this.getLog())) {
                    try {
                        CrowdinFileSystem.createFolders((HttpClient)this.client, this.server, filesElement, pushFolder, this.getLog());
                    }
                    catch (IOException e) {
                        throw new MojoExecutionException("An error occurred while creating folder \"" + pushFolder + "\" on Crowdin: " + e.getMessage(), (Exception)e);
                    }
                }
                HashMap<String, AbstractContentBody> fileMap = new HashMap<String, AbstractContentBody>();
                HashMap<String, String> titleMap = new HashMap<String, String>();
                HashMap<String, String> patternMap = new HashMap<String, String>();
                String pushName = PushCrowdinMojo.isBlank(fileSet.getCrowdinPath()) ? fileSet.getBaseFileName() : CrowdinFileSystem.formatPath(fileSet.getCrowdinPath(), true) + fileSet.getBaseFileName();
                boolean update = CrowdinFileSystem.containsFile(filesElement, pushName, this.getLog());
                try {
                    Path pushFileName = pushFile.getFileName();
                    fileMap.put(pushName, (AbstractContentBody)(fileSet.getType() == FileType.nsh ? new InputStreamBody((InputStream)new NSISUtil.NSISInputStream(pushFile), ContentType.DEFAULT_BINARY, pushFileName == null ? null : pushFileName.toString()) : new FileBody(pushFile.toFile())));
                }
                catch (FileNotFoundException e) {
                    if (!fileSet.getBaseFileName().equals(fileSet.getTitle())) {
                        this.getLog().warn((CharSequence)("\"" + pushFile.toAbsolutePath() + "\" not found - upload skipped for fileset \"" + fileSet.getTitle() + "\": " + e.getMessage()));
                        continue;
                    }
                    this.getLog().warn((CharSequence)("\"" + pushFile.toAbsolutePath() + "\" not found - upload skipped: " + e.getMessage()));
                    continue;
                }
                catch (IOException e) {
                    if (!fileSet.getBaseFileName().equals(fileSet.getTitle())) {
                        this.getLog().error((CharSequence)("An error occurred while reading \"" + pushFile.toAbsolutePath() + "\" - upload skipped for fileset \"" + fileSet.getTitle() + "\": " + e.getMessage()));
                        continue;
                    }
                    this.getLog().error((CharSequence)("An error occurred while reading \"" + pushFile.toAbsolutePath() + "\" - upload skipped: " + e.getMessage()));
                    continue;
                }
                if (!fileSet.getBaseFileName().equals(fileSet.getTitle())) {
                    titleMap.put(pushName, fileSet.getTitle());
                }
                patternMap.put(pushName, fileSet.getFileNameWhenExported());
                if (!fileSet.getBaseFileName().equals(fileSet.getTitle())) {
                    this.getLog().info((CharSequence)((update ? "Updating" : "Adding") + " file \"" + fileSet.getBaseFileName() + "\" for fileset \"" + fileSet.getTitle() + "\" on Crowdin"));
                } else {
                    this.getLog().info((CharSequence)((update ? "Updating" : "Adding") + " file \"" + fileSet.getBaseFileName() + "\" on Crowdin"));
                }
                HashMap<String, String> parameters = new HashMap<String, String>();
                if (branch != null) {
                    parameters.put("branch", branch);
                }
                parameters.put("escape_quotes", Integer.toString(this.getEscapeQuotes(fileSet)));
                try {
                    if (update) {
                        UpdateOption tmpUpdateOption = this.getUpdateOption(fileSet);
                        if (tmpUpdateOption != UpdateOption.delete_translations) {
                            parameters.put("update_option", tmpUpdateOption.name());
                        }
                        CrowdinAPI.requestPostDocument((HttpClient)this.client, this.server, "update-file", parameters, fileMap, titleMap, patternMap, true, this.getLog());
                    } else {
                        parameters.put("type", fileSet.getType().name());
                        CrowdinAPI.requestPostDocument((HttpClient)this.client, this.server, "add-file", parameters, fileMap, titleMap, patternMap, true, this.getLog());
                    }
                }
                catch (IOException e) {
                    throw new MojoExecutionException("An error occurred while " + (update ? "updating" : "adding") + " file \"" + pushFile + "\": " + e.getMessage(), (Exception)e);
                }
                if (fileMap.isEmpty()) continue;
                for (AbstractContentBody contentBody : fileMap.values()) {
                    InputStreamBody inputStreamBody;
                    if (!(contentBody instanceof InputStreamBody) || (inputStreamBody = (InputStreamBody)contentBody).getInputStream() == null) continue;
                    try {
                        inputStreamBody.getInputStream().close();
                    }
                    catch (IOException e) {
                        this.getLog().warn((CharSequence)("Couldn't close \"" + pushFile + "\" after reading"));
                    }
                }
                continue;
            }
            if (!fileSet.getBaseFileName().equals(fileSet.getTitle())) {
                this.getLog().warn((CharSequence)("\"" + pushFile.toAbsolutePath() + "\" not found - upload skipped for fileset \"" + fileSet.getTitle() + "\""));
                continue;
            }
            this.getLog().warn((CharSequence)("\"" + pushFile.toAbsolutePath() + "\" not found - upload skipped"));
        }
    }

    protected int getEscapeQuotes(TranslationFileSet fileSet) {
        return fileSet != null && fileSet.getEscapeQuotes() != null ? fileSet.getEscapeQuotes() : this.escapeQuotes;
    }

    protected UpdateOption getUpdateOption(TranslationFileSet fileSet) {
        return fileSet != null && fileSet.getUpdateOption() != null ? fileSet.getUpdateOption() : this.updateOption;
    }

    @Override
    protected void initializeParameters() throws MojoExecutionException {
        super.initializeParameters();
        if (this.escapeQuotes < 0 || this.escapeQuotes > 3) {
            throw new MojoExecutionException("Invalid default \"escapeQuotes\" value " + this.escapeQuotes);
        }
        if (this.updateOption == null) {
            this.updateOption = UpdateOption.delete_translations;
        }
    }
}

