/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.crowdin.tool;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.AbstractContentBody;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.settings.Server;
import org.digitalmediaserver.crowdin.AbstractCrowdinMojo;
import org.digitalmediaserver.crowdin.tool.Constants;
import org.digitalmediaserver.crowdin.tool.CrowdinFileSystem;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public class CrowdinAPI {
    private CrowdinAPI() {
    }

    public static CloseableHttpClient createHTTPClient() throws IOException {
        HttpClientBuilder clientBuilder = HttpClientBuilder.create();
        if (System.getProperty("http.proxyHost") != null) {
            String host = System.getProperty("http.proxyHost");
            String port = System.getProperty("http.proxyPort");
            if (port == null) {
                throw new IOException("http.proxyHost without http.proxyPort");
            }
            RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
            HttpHost proxy = new HttpHost(host, Integer.parseInt(port));
            requestConfigBuilder.setProxy(proxy);
            UsernamePasswordCredentials credentials = null;
            String user = System.getProperty("http.proxyUser");
            String password = System.getProperty("http.proxyPassword");
            if (System.getProperty("http.auth.ntlm.domain") != null) {
                String domain = System.getProperty("http.auth.ntlm.domain");
                if (user == null || password == null) {
                    throw new IOException("http.auth.ntlm.domain without http.proxyUser and http.proxyPassword");
                }
                credentials = new NTCredentials(user, password, host, domain);
            } else if (user != null || password != null) {
                if (user == null || password == null) {
                    throw new IOException("http.proxyUser and http.proxyPassword go together");
                }
                credentials = new UsernamePasswordCredentials(user, password);
            }
            if (credentials != null) {
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                credsProvider.setCredentials(new AuthScope(host, Integer.parseInt(port)), (Credentials)credentials);
                clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
            }
            clientBuilder.setDefaultRequestConfig(requestConfigBuilder.build());
        }
        return clientBuilder.build();
    }

    @Nullable
    public static Element getFiles(@Nonnull HttpClient httpClient, @Nonnull Server server, @Nullable String branch, @Nullable Document projectDetails, @Nullable Log logger) throws IOException {
        if (projectDetails == null) {
            if (logger != null) {
                logger.info((CharSequence)"Retrieving Crowdin project information");
            }
            projectDetails = CrowdinAPI.requestPostDocument(httpClient, server, "info", null, null, true, logger);
        }
        if (branch != null) {
            Element branchElement = CrowdinFileSystem.getBranch(projectDetails.getRootElement().getChild("files").getChildren(), branch);
            if (branchElement == null || !CrowdinFileSystem.isBranch(branchElement)) {
                throw new IOException("Can't find branch \"" + branch + "\" in Crowdin project information");
            }
            return branchElement.getChild("files");
        }
        return projectDetails.getRootElement().getChild("files");
    }

    @Nonnull
    public static Document requestGetDocument(@Nonnull HttpClient httpClient, @Nonnull Server server, @Nonnull String method, @Nullable Map<String, String> parameters, @Nullable Log logger) throws IOException {
        Document document;
        if (AbstractCrowdinMojo.isBlank(method)) {
            throw new IllegalArgumentException("method cannot be blank");
        }
        StringBuilder url = new StringBuilder("https://api.crowdin.com/api/project/");
        url.append(server.getUsername()).append("/").append(method);
        boolean first = true;
        if (parameters != null) {
            for (Map.Entry<String, String> parameter : parameters.entrySet()) {
                url.append(first ? "?" : "&").append(parameter.getKey()).append("=").append(parameter.getValue());
                first = false;
            }
        }
        url.append(first ? "?" : "&").append("key=");
        if (logger != null) {
            logger.debug((CharSequence)("Calling " + url + "<API Key>"));
        }
        url.append(server.getPassword());
        HttpGet getMethod = new HttpGet(url.toString());
        HttpResponse response = httpClient.execute((HttpUriRequest)getMethod);
        int returnCode = response.getStatusLine().getStatusCode();
        if (logger != null) {
            logger.debug((CharSequence)("Return code: " + returnCode));
        }
        if (returnCode != 200) {
            throw new IOException("Failed to call API with return code " + returnCode);
        }
        InputStream responseBodyAsStream = response.getEntity().getContent();
        try {
            document = Constants.SAX_BUILDER.build(responseBodyAsStream);
        }
        catch (JDOMException e) {
            throw new IOException("Failed to parse API reponse: " + e.getMessage(), e);
        }
        if (!document.getRootElement().getName().equals("success")) {
            String code = document.getRootElement().getChildTextNormalize("code");
            String message = document.getRootElement().getChildTextNormalize("message");
            throw new IOException("Failed to call API, response was: " + code + " - " + message);
        }
        return document;
    }

    @Nonnull
    public static Document requestPostDocument(@Nonnull HttpClient httpClient, @Nonnull Server server, @Nonnull String method, @Nullable Map<String, String> parameters, @Nullable Map<String, AbstractContentBody> files, boolean mustSucceed, @Nullable Log logger) throws IOException {
        return CrowdinAPI.requestPostDocument(httpClient, server, method, parameters, files, null, null, mustSucceed, logger);
    }

    @Nonnull
    public static Document requestPostDocument(@Nonnull HttpClient httpClient, @Nonnull Server server, @Nonnull String method, @Nullable Map<String, String> parameters, @Nullable Map<String, AbstractContentBody> files, @Nullable Map<String, String> titles, @Nullable Map<String, String> patterns, boolean mustSucceed, @Nullable Log logger) throws IOException {
        try {
            HttpResponse response = CrowdinAPI.requestPost(httpClient, server, method, parameters, files, titles, patterns, logger);
            int returnCode = response.getStatusLine().getStatusCode();
            if (logger != null) {
                logger.debug((CharSequence)("Return code : " + returnCode));
            }
            InputStream responseBodyAsStream = response.getEntity().getContent();
            Document document = Constants.SAX_BUILDER.build(responseBodyAsStream);
            if (mustSucceed && document.getRootElement().getName().equals("error")) {
                String code = document.getRootElement().getChildTextNormalize("code");
                String message = document.getRootElement().getChildTextNormalize("message");
                throw new IOException("Failed to call API (" + returnCode + "): " + code + " - " + message);
            }
            return document;
        }
        catch (JDOMException e) {
            throw new IOException("Failed to parse API reponse: " + e.getMessage(), e);
        }
    }

    @Nonnull
    public static HttpResponse requestPost(@Nonnull HttpClient httpClient, @Nonnull Server server, @Nonnull String method, @Nullable Map<String, String> parameters, @Nullable Log logger) throws IOException {
        return CrowdinAPI.requestPost(httpClient, server, method, parameters, null, null, null, logger);
    }

    @Nonnull
    public static HttpResponse requestPost(@Nonnull HttpClient httpClient, @Nonnull Server server, @Nonnull String method, @Nullable Map<String, String> parameters, @Nullable Map<String, AbstractContentBody> files, @Nullable Map<String, String> titles, @Nullable Map<String, String> patterns, @Nullable Log logger) throws IOException {
        if (AbstractCrowdinMojo.isBlank(method)) {
            throw new IllegalArgumentException("method cannot be blank");
        }
        StringBuilder url = new StringBuilder("https://api.crowdin.com/api/project/");
        url.append(server.getUsername()).append("/").append(method).append("?key=");
        if (logger != null) {
            logger.debug((CharSequence)("Calling " + url + "<API Key>"));
        }
        url.append(server.getPassword());
        HttpPost postMethod = new HttpPost(url.toString());
        MultipartEntityBuilder reqEntityBuilder = MultipartEntityBuilder.create();
        if (parameters != null && !parameters.isEmpty()) {
            Set<Map.Entry<String, String>> entrySetParameters = parameters.entrySet();
            for (Map.Entry<String, String> entryParameter : entrySetParameters) {
                reqEntityBuilder.addTextBody(entryParameter.getKey(), entryParameter.getValue());
            }
        }
        if (files != null && !files.isEmpty()) {
            for (Map.Entry<String, AbstractContentBody> entryFile : files.entrySet()) {
                String key = "files[" + entryFile.getKey() + "]";
                reqEntityBuilder.addPart(key, (ContentBody)entryFile.getValue());
            }
        }
        if (titles != null && !titles.isEmpty()) {
            Set<Map.Entry<String, String>> entrySetTitles = titles.entrySet();
            for (Map.Entry<String, String> entryTitle : entrySetTitles) {
                reqEntityBuilder.addTextBody("titles[" + entryTitle.getKey() + "]", entryTitle.getValue());
            }
        }
        if (patterns != null && !patterns.isEmpty()) {
            Set<Map.Entry<String, String>> entrySetPatterns = patterns.entrySet();
            for (Map.Entry<String, String> entryPattern : entrySetPatterns) {
                reqEntityBuilder.addTextBody("export_patterns[" + entryPattern.getKey() + "]", entryPattern.getValue());
            }
        }
        postMethod.setEntity(reqEntityBuilder.build());
        return httpClient.execute((HttpUriRequest)postMethod);
    }
}

