/*
 * Decompiled with CFR 0.152.
 */
package org.digitalmediaserver.crowdin.tool;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.http.client.HttpClient;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.settings.Server;
import org.digitalmediaserver.crowdin.AbstractCrowdinMojo;
import org.digitalmediaserver.crowdin.configuration.TranslationFileSet;
import org.digitalmediaserver.crowdin.tool.CrowdinAPI;
import org.jdom2.Element;

public class CrowdinFileSystem {
    private CrowdinFileSystem() {
    }

    public static boolean containsFile(@Nullable Element currentElement, @Nullable String fileName, @Nullable Log logger) {
        return CrowdinFileSystem.containsFile(currentElement, fileName, EnumSet.of(ItemType.FILE), logger);
    }

    public static boolean containsFolder(@Nullable Element currentElement, @Nullable String folderName, @Nullable Log logger) {
        return CrowdinFileSystem.containsFile(currentElement, folderName, EnumSet.of(ItemType.FOLDER), logger);
    }

    public static boolean containsBranch(@Nullable Element currentElement, @Nullable String branchName, @Nullable Log logger) {
        return CrowdinFileSystem.containsFile(currentElement, branchName, EnumSet.of(ItemType.BRANCH), logger);
    }

    public static boolean containsFile(@Nullable Element currentElement, @Nullable String name, @Nullable EnumSet<ItemType> filter, @Nullable Log logger) {
        Element file;
        if (logger != null) {
            logger.debug((CharSequence)("Checking if Crowdin project contains " + name));
        }
        return (file = CrowdinFileSystem.getFile(currentElement, name, filter, logger)) != null;
    }

    @Nullable
    public static Element getFolder(@Nullable List<Element> items, @Nullable String folderName) {
        return CrowdinFileSystem.getFile(items, folderName, EnumSet.of(ItemType.FOLDER));
    }

    @Nullable
    public static Element getFolder(@Nullable Element currentElement, @Nullable String folderName, @Nullable Log logger) {
        return CrowdinFileSystem.getFile(currentElement, folderName, EnumSet.of(ItemType.FOLDER), logger);
    }

    @Nullable
    public static Element getBranch(@Nullable List<Element> items, @Nullable String branchName) {
        return CrowdinFileSystem.getFile(items, branchName, EnumSet.of(ItemType.BRANCH));
    }

    @Nullable
    public static Element getBranch(@Nullable Element currentElement, @Nullable String branchName, @Nullable Log logger) {
        return CrowdinFileSystem.getFile(currentElement, branchName, EnumSet.of(ItemType.BRANCH), logger);
    }

    @Nullable
    public static Element getFile(@Nullable List<Element> items, @Nullable String fileName) {
        return CrowdinFileSystem.getFile(items, fileName, EnumSet.of(ItemType.FILE));
    }

    @Nullable
    public static Element getFile(@Nullable List<Element> items, @Nullable String name, @Nullable EnumSet<ItemType> filter) {
        if (items == null || items.isEmpty() || AbstractCrowdinMojo.isBlank(name)) {
            return null;
        }
        for (Element item : items) {
            if (!name.equals(item.getChildText("name"))) continue;
            if (filter != null && !filter.isEmpty()) {
                ItemType itemType = ItemType.typeOf(item);
                if (itemType == null) {
                    return null;
                }
                return filter.contains((Object)itemType) ? item : null;
            }
            return item;
        }
        return null;
    }

    @Nullable
    public static Element getFile(@Nullable Element currentElement, @Nullable String fileName, @Nullable Log logger) {
        return CrowdinFileSystem.getFile(currentElement, fileName, EnumSet.of(ItemType.FILE), logger);
    }

    @Nullable
    public static Element getFile(@Nullable Element currentElement, @Nullable String name, @Nullable EnumSet<ItemType> filter, @Nullable Log logger) {
        if (currentElement == null || AbstractCrowdinMojo.isBlank(name)) {
            return null;
        }
        if (!"files".equals(currentElement.getName()) && (currentElement = currentElement.getChild("files")) == null) {
            return null;
        }
        if (logger != null) {
            logger.debug((CharSequence)("Looking for \"" + name + "\" in Crowdin project"));
        }
        List items = currentElement.getChildren("item");
        int slash = name.indexOf(47);
        if (slash == -1) {
            for (Element item : items) {
                if (!name.equals(item.getChildText("name"))) continue;
                ItemType itemType = ItemType.typeOf(item);
                if (filter != null && !filter.isEmpty()) {
                    if (itemType == null) {
                        if (logger != null) {
                            logger.warn((CharSequence)("Found \"" + name + "\" with an unknown type, but it isn't " + (filter.size() == 1 ? "the expected type: " : "among the expected types: ") + filter));
                        }
                        return null;
                    }
                    if (!filter.contains((Object)itemType)) {
                        if (logger != null) {
                            logger.warn((CharSequence)("Found " + itemType.toString().toLowerCase(Locale.ROOT) + " \"" + name + "\" but it isn't " + (filter.size() == 1 ? "the expected type: " : "among the expected types: ") + filter));
                        }
                        return null;
                    }
                }
                if (logger != null) {
                    logger.debug((CharSequence)("Found " + itemType.toString().toLowerCase(Locale.ROOT) + " \"" + name + "\""));
                }
                return item;
            }
        } else {
            String folderName = name.substring(0, slash);
            String subPath = name.substring(slash + 1);
            Element folderElement = CrowdinFileSystem.getFile(items, folderName, EnumSet.of(ItemType.BRANCH, ItemType.FOLDER));
            if (folderElement != null) {
                return CrowdinFileSystem.getFile(folderElement, subPath, filter, logger);
            }
        }
        if (logger != null) {
            if (filter != null && filter.size() == 1) {
                logger.debug((CharSequence)("Couldn't find " + ((ItemType)((Object)filter.iterator().next())).toString().toLowerCase(Locale.ROOT) + " \"" + name + "\""));
            } else {
                logger.debug((CharSequence)("Couldn't find \"" + name + "\""));
            }
        }
        return null;
    }

    public static boolean isFile(@Nullable Element item) {
        return ItemType.typeOf(item) == ItemType.FILE;
    }

    public static boolean isFolder(@Nullable Element item) {
        return ItemType.typeOf(item) == ItemType.FOLDER;
    }

    public static boolean isBranch(@Nullable Element item) {
        return ItemType.typeOf(item) == ItemType.BRANCH;
    }

    public static boolean isRoot(@Nullable Element item) {
        if (item == null) {
            return false;
        }
        if ("files".equals(item.getName())) {
            item = item.getParentElement();
        }
        return item == null ? false : "info".equals(item.getName());
    }

    @Nullable
    public static Element getParent(@Nullable Element item) {
        if (item == null) {
            return null;
        }
        if ("files".equals(item.getName())) {
            item = item.getParentElement();
        }
        item = item == null ? null : item.getParentElement();
        item = item == null ? null : item.getParentElement();
        return item;
    }

    @Nonnull
    public static String getPushFolder(@Nonnull TranslationFileSet fileSet, boolean includeCrowdinPath) {
        ArrayList<String> folders = new ArrayList<String>();
        if (includeCrowdinPath && !AbstractCrowdinMojo.isBlank(fileSet.getCrowdinPath())) {
            folders.addAll(Arrays.asList(fileSet.getCrowdinPath().split("/")));
        }
        if (!AbstractCrowdinMojo.isBlank(fileSet.getBaseFileName())) {
            folders.addAll(Arrays.asList(fileSet.getBaseFileName().split("/")));
        }
        if (folders.size() > 0) {
            folders.remove(folders.size() - 1);
        }
        StringBuilder sb = new StringBuilder();
        for (String folder : folders) {
            if (sb.length() > 0) {
                sb.append("/");
            }
            sb.append(folder);
        }
        return sb.toString();
    }

    @Nonnull
    public static Element createFolders(@Nonnull HttpClient httpClient, @Nonnull Server server, @Nonnull Element currentElement, String path, @Nullable Log logger) throws IOException {
        int i;
        if (AbstractCrowdinMojo.isBlank(path)) {
            return currentElement;
        }
        if (currentElement != null && "files".equals(currentElement.getName())) {
            currentElement = currentElement.getParentElement();
        }
        if (currentElement == null) {
            throw new IllegalArgumentException("currentElement is null or invalid");
        }
        if (!CrowdinFileSystem.isFolder(currentElement) && !CrowdinFileSystem.isBranch(currentElement)) {
            throw new IllegalArgumentException("currentElement must be a branch or folder");
        }
        String[] folders = path.split("\\\\|/");
        ArrayList<String> parents = new ArrayList<String>();
        Element parentElement = currentElement;
        while (parentElement != null && !CrowdinFileSystem.isRoot(parentElement)) {
            parents.add(0, parentElement.getChildText("name"));
            parentElement = CrowdinFileSystem.getParent(parentElement);
        }
        StringBuilder currentFolder = new StringBuilder();
        for (i = 0; i < parents.size(); ++i) {
            if (i > 0) {
                currentFolder.append("/");
            }
            currentFolder.append((String)parents.get(i));
        }
        for (i = 0; i < folders.length; ++i) {
            String folder = folders[i];
            if (currentFolder.length() > 0) {
                currentFolder.append("/");
            }
            currentFolder.append(folder);
            if (CrowdinFileSystem.containsFile(currentElement, folder, EnumSet.of(ItemType.BRANCH, ItemType.FOLDER), logger)) {
                currentElement = CrowdinFileSystem.getFile(currentElement, folder, EnumSet.of(ItemType.BRANCH, ItemType.FOLDER), null);
            } else {
                CrowdinFileSystem.createFolder(httpClient, server, currentFolder.toString(), logger);
                Element rootFilesElement = CrowdinAPI.getFiles(httpClient, server, null, null, null);
                currentElement = CrowdinFileSystem.getFile(rootFilesElement, currentFolder.toString(), EnumSet.of(ItemType.BRANCH, ItemType.FOLDER), null);
            }
            if (currentElement != null && !CrowdinFileSystem.isFile(currentElement)) continue;
            throw new IOException("Internal error, couldn't find recently created branch or folder \"" + currentFolder.toString() + "\"");
        }
        return currentElement;
    }

    public static void createFolder(@Nonnull HttpClient httpClient, @Nonnull Server server, @Nonnull String folderName, @Nullable Log logger) throws IOException {
        if (AbstractCrowdinMojo.isBlank(folderName)) {
            throw new IllegalArgumentException("folderName cannot be blank");
        }
        if (logger != null) {
            logger.info((CharSequence)("Creating folder \"" + folderName + "\" on Crowdin"));
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("name", folderName);
        CrowdinAPI.requestPostDocument(httpClient, server, "add-directory", parameters, null, true, logger);
    }

    public static void createBranch(@Nonnull HttpClient httpClient, @Nonnull Server server, @Nonnull String branchName, @Nullable Log logger) throws IOException {
        if (AbstractCrowdinMojo.isBlank(branchName)) {
            throw new IllegalArgumentException("branchName cannot be blank");
        }
        if (logger != null) {
            logger.info((CharSequence)("Creating branch \"" + branchName + "\" on Crowdin"));
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("name", branchName);
        parameters.put("is_branch", "1");
        CrowdinAPI.requestPostDocument(httpClient, server, "add-directory", parameters, null, true, logger);
    }

    @Nonnull
    public static String formatPath(@Nonnull Path path, boolean appendSeparator) {
        return CrowdinFileSystem.formatPath(path.toString(), appendSeparator);
    }

    @Nonnull
    public static String formatPath(@Nonnull String path, boolean appendSeparator) {
        path = path.replace('\\', '/');
        if (appendSeparator && !path.isEmpty() && !path.endsWith("/")) {
            path = path + "/";
        }
        return path;
    }

    public static enum ItemType {
        BRANCH,
        FILE,
        FOLDER;


        @Nullable
        public static ItemType typeOf(@Nullable Element item) {
            if (item != null && "files".equals(item.getName())) {
                item = item.getParentElement();
            }
            if (item == null) {
                return null;
            }
            String nodeType = item.getChildText("node_type");
            if (nodeType == null) {
                return null;
            }
            switch (nodeType) {
                case "branch": {
                    return BRANCH;
                }
                case "directory": {
                    return FOLDER;
                }
                case "file": {
                    return FILE;
                }
            }
            return null;
        }
    }
}

